/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteQueryResult;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0004\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveSqliteResultSet;", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "messenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "connectionId", "", "taskExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;ILjava/util/concurrent/Executor;)V", "sendQueryCommand", "Lcom/google/common/util/concurrent/ListenableFuture;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Response;", "responseSizeByteLimitHint", "", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;Ljava/lang/Long;)Lcom/google/common/util/concurrent/ListenableFuture;", "getRowBatch", "Lcom/android/tools/idea/sqlite/model/SqliteQueryResult;", "rowOffset", "rowBatchSize", "(IILjava/lang/Long;)Lcom/google/common/util/concurrent/ListenableFuture;", "dispose", "", "app-inspection.inspectors.database"})
public abstract class LiveSqliteResultSet
implements SqliteResultSet {
    @NotNull
    private final SqliteStatement sqliteStatement;
    @NotNull
    private final DatabaseInspectorMessenger messenger;
    private final int connectionId;
    @NotNull
    private final Executor taskExecutor;

    public LiveSqliteResultSet(@NotNull SqliteStatement sqliteStatement, @NotNull DatabaseInspectorMessenger messenger, int connectionId, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.sqliteStatement = sqliteStatement;
        this.messenger = messenger;
        this.connectionId = connectionId;
        this.taskExecutor = taskExecutor;
    }

    @NotNull
    protected final ListenableFuture<SqliteInspectorProtocol.Response> sendQueryCommand(@NotNull SqliteStatement sqliteStatement, @Nullable Long responseSizeByteLimitHint) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        SqliteInspectorProtocol.Command queryCommand = UtilsKt.buildQueryCommand(sqliteStatement, this.connectionId, responseSizeByteLimitHint);
        return FutureUtils.cancelOnDispose(this.messenger.sendCommandAsync(queryCommand), (Disposable)this);
    }

    public static /* synthetic */ ListenableFuture sendQueryCommand$default(LiveSqliteResultSet liveSqliteResultSet, SqliteStatement sqliteStatement, Long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendQueryCommand");
        }
        if ((n & 2) != 0) {
            l = null;
        }
        return liveSqliteResultSet.sendQueryCommand(sqliteStatement, l);
    }

    @Override
    @NotNull
    public final ListenableFuture<SqliteQueryResult> getRowBatch(int rowOffset, int rowBatchSize) {
        return this.getRowBatch(rowOffset, rowBatchSize, null);
    }

    @NotNull
    public abstract ListenableFuture<SqliteQueryResult> getRowBatch(int var1, int var2, @Nullable Long var3);

    public static /* synthetic */ ListenableFuture getRowBatch$default(LiveSqliteResultSet liveSqliteResultSet, int n, int n2, Long l, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRowBatch");
        }
        if ((n3 & 4) != 0) {
            l = null;
        }
        return liveSqliteResultSet.getRowBatch(n, n2, l);
    }

    public void dispose() {
    }
}

