/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.tools.idea.lang.androidSql.parser.AndroidSqlLexer;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcDatabaseConnection;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a/\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u0007*\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H\u00070\n\u00a2\u0006\u0002\b\u000b\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"resolvePreparedStatement", "Ljava/sql/PreparedStatement;", "Ljava/sql/Connection;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "map", "Lkotlin/sequences/Sequence;", "T", "Ljava/sql/ResultSet;", "transform", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getColumnNamesInPrimaryKey", "", "", "tableName", "selectAllAndRowIdFromTable", "table", "Lcom/android/tools/idea/sqlite/model/SqliteTable;", "openJdbcDatabaseConnection", "Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "workerExecutor", "Ljava/util/concurrent/Executor;", "workerDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/concurrent/Executor;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nJdbcUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcUtils.kt\ncom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1878#2,3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 JdbcUtils.kt\ncom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcUtilsKt\n*L\n39#1:92,3\n*E\n"})
public final class JdbcUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PreparedStatement resolvePreparedStatement(@NotNull Connection $this$resolvePreparedStatement, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvePreparedStatement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        PreparedStatement preparedStatement = $this$resolvePreparedStatement.prepareStatement(sqliteStatement.getSqliteStatementText());
        Iterable $this$forEachIndexed$iv = sqliteStatement.getParametersValues();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqliteValue sqliteValue = (SqliteValue)item$iv;
            int index = n;
            boolean bl = false;
            void var12_12 = value2;
            if (var12_12 instanceof SqliteValue.StringValue) {
                preparedStatement.setString(index + 1, ((SqliteValue.StringValue)value2).getValue());
                continue;
            }
            if (var12_12 instanceof SqliteValue.NullValue) {
                preparedStatement.setNull(index + 1, 12);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNull((Object)preparedStatement);
        return preparedStatement;
    }

    @NotNull
    public static final <T> Sequence<T> map(@NotNull ResultSet $this$map, @NotNull Function1<? super ResultSet, ? extends T> transform2) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        ResultSet resultSet = $this$map;
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super T>, Continuation<? super Unit>, Object>(resultSet, transform2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ResultSet $resultSet;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            {
                this.$resultSet = $resultSet;
                this.$transform = $transform;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
lbl6:
                        // 3 sources

                        while (this.$resultSet.next()) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(this.$transform.invoke((Object)this.$resultSet), (Continuation)this);
                            if (v0 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public static final List<String> getColumnNamesInPrimaryKey(@NotNull Connection $this$getColumnNamesInPrimaryKey, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getColumnNamesInPrimaryKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        if (((CharSequence)tableName).length() == 0) {
            return CollectionsKt.emptyList();
        }
        ResultSet keySet = $this$getColumnNamesInPrimaryKey.getMetaData().getPrimaryKeys(null, null, tableName);
        Intrinsics.checkNotNull((Object)keySet);
        return SequencesKt.toList(JdbcUtilsKt.map(keySet, JdbcUtilsKt::getColumnNamesInPrimaryKey$lambda$0));
    }

    @NotNull
    public static final String selectAllAndRowIdFromTable(@NotNull SqliteTable table2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                object = table2.getRowIdName();
                if (object == null) break block2;
                RowIdName rowIdName = object;
                boolean bl = false;
                String string = "*, " + rowIdName.getStringName() + " as " + rowIdName.getStringName();
                object = string;
                if (string != null) break block3;
            }
            object = "*";
        }
        Object columnsToSelect = object;
        return "SELECT " + (String)columnsToSelect + " FROM " + AndroidSqlLexer.Companion.getValidName(table2.getName());
    }

    @Nullable
    public static final Object openJdbcDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull VirtualFile virtualFile, @NotNull Executor workerExecutor, @NotNull CoroutineDispatcher workerDispatcher, @NotNull Continuation<? super JdbcDatabaseConnection> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)workerDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JdbcDatabaseConnection>, Object>(virtualFile, parentDisposable, workerExecutor, null){
            int label;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ Executor $workerExecutor;
            {
                this.$virtualFile = $virtualFile;
                this.$parentDisposable = $parentDisposable;
                this.$workerExecutor = $workerExecutor;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        JdbcDatabaseConnection jdbcDatabaseConnection;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            String url = "jdbc:sqlite:" + this.$virtualFile.getPath();
                            Connection connection2 = DriverManager.getConnection(url);
                            Intrinsics.checkNotNull((Object)connection2);
                            jdbcDatabaseConnection = new JdbcDatabaseConnection(this.$parentDisposable, connection2, this.$virtualFile, this.$workerExecutor);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error while opening Sqlite database file '" + this.$virtualFile.getPath() + "'", e);
                        }
                        return jdbcDatabaseConnection;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JdbcDatabaseConnection> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final String getColumnNamesInPrimaryKey$lambda$0(ResultSet $this$map) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        return $this$map.getString("COLUMN_NAME");
    }
}

