/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.lang.androidSql.parser.AndroidSqlLexer;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.LazyJdbcSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.PagedJdbcSqliteResultSet;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteAffinity;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteStatementType;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.UtilsKt;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "connection", "Ljava/sql/Connection;", "sqliteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "pooledExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Lcom/intellij/openapi/Disposable;Ljava/sql/Connection;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/concurrent/Executor;)V", "sequentialTaskExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "query", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "execute", "readColumnDefinitions", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "tableName", "", "Companion", "app-inspection.inspectors.database"})
public final class JdbcDatabaseConnection
implements DatabaseConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Connection connection;
    @NotNull
    private final VirtualFile sqliteFile;
    @NotNull
    private final ExecutorService sequentialTaskExecutor;
    @NotNull
    private static final Logger logger;

    public JdbcDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull Connection connection2, @NotNull VirtualFile sqliteFile, @NotNull Executor pooledExecutor) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteFile, (String)"sqliteFile");
        Intrinsics.checkNotNullParameter((Object)pooledExecutor, (String)"pooledExecutor");
        this.connection = connection2;
        this.sqliteFile = sqliteFile;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Sqlite JDBC service", (Executor)pooledExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.sequentialTaskExecutor = executorService;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, () -> JdbcDatabaseConnection.close$lambda$0(this));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, () -> JdbcDatabaseConnection.readSchema$lambda$0(this));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> query(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        JdbcSqliteResultSet resultSet = switch (WhenMappings.$EnumSwitchMapping$0[sqliteStatement.getStatementType().ordinal()]) {
            case 1 -> new PagedJdbcSqliteResultSet(this.sequentialTaskExecutor, this.connection, sqliteStatement);
            case 2, 3 -> new LazyJdbcSqliteResultSet(this.sequentialTaskExecutor, this.connection, sqliteStatement);
            default -> throw new IllegalArgumentException("SqliteStatement must be of type SELECT, EXPLAIN or PRAGMA, but is " + sqliteStatement.getStatementType());
        };
        Disposer.register((Disposable)this, (Disposable)resultSet);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)resultSet);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, () -> JdbcDatabaseConnection.execute$lambda$0(this, sqliteStatement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<SqliteColumn> readColumnDefinitions(Connection connection2, String tableName) {
        AutoCloseable autoCloseable = connection2.createStatement();
        Throwable throwable = null;
        try {
            List list2;
            Statement statement = (Statement)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = statement.executeQuery("PRAGMA table_info(" + AndroidSqlLexer.Companion.getValidName(tableName) + ")");
            Throwable throwable2 = null;
            try {
                ResultSet it = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                list2 = SequencesKt.toList(JdbcUtilsKt.map(it, JdbcDatabaseConnection::readColumnDefinitions$lambda$0$0$0));
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            List list3 = list2;
            return list3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Unit close$lambda$0(JdbcDatabaseConnection this$0) {
        this$0.connection.close();
        logger.info("Successfully closed database: " + this$0.sqliteFile.getPath());
        return Unit.INSTANCE;
    }

    private static final SqliteSchema readSchema$lambda$0(JdbcDatabaseConnection this$0) {
        SqliteSchema sqliteSchema;
        ResultSet tables = this$0.connection.getMetaData().getTables(null, null, null, null);
        List sqliteTables = new ArrayList();
        while (tables.next()) {
            Connection connection2 = this$0.connection;
            String string = tables.getString("TABLE_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            List<SqliteColumn> columns2 = this$0.readColumnDefinitions(connection2, string);
            RowIdName rowIdName = UtilsKt.getRowIdName(columns2);
            String string2 = tables.getString("TABLE_NAME");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            sqliteTables.add(new SqliteTable(string2, columns2, rowIdName, Intrinsics.areEqual((Object)tables.getString("TABLE_TYPE"), (Object)"VIEW")));
        }
        SqliteSchema $this$readSchema_u24lambda_u240_u240 = sqliteSchema = new SqliteSchema(sqliteTables);
        boolean bl = false;
        logger.info("Successfully read database schema: " + this$0.sqliteFile.getPath());
        return sqliteSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit execute$lambda$0(JdbcDatabaseConnection this$0, SqliteStatement $sqliteStatement) {
        AutoCloseable autoCloseable = JdbcUtilsKt.resolvePreparedStatement(this$0.connection, $sqliteStatement);
        Throwable throwable = null;
        try {
            int n;
            PreparedStatement preparedStatement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            int it = n = preparedStatement.executeUpdate();
            boolean bl2 = false;
            logger.info("SQL statement \"" + $sqliteStatement.getSqliteStatementText() + "\" executed with success.");
            int n2 = n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final SqliteColumn readColumnDefinitions$lambda$0$0$0(ResultSet $this$map) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        String columnName = $this$map.getString(2);
        String columnType = $this$map.getString(3);
        String colNotNull = $this$map.getString(4);
        String colPk = $this$map.getString(6);
        Intrinsics.checkNotNull((Object)columnName);
        Intrinsics.checkNotNull((Object)columnType);
        SqliteAffinity sqliteAffinity = SqliteAffinity.Companion.fromTypename(columnType);
        boolean bl = Intrinsics.areEqual((Object)colNotNull, (Object)"0");
        Intrinsics.checkNotNull((Object)colPk);
        return new SqliteColumn(columnName, sqliteAffinity, bl, Integer.parseInt(colPk) > 0);
    }

    static {
        Logger logger = Logger.getInstance(JdbcDatabaseConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        JdbcDatabaseConnection.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "app-inspection.inspectors.database"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqliteStatementType.values().length];
            try {
                nArray[SqliteStatementType.SELECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.EXPLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteStatementType.PRAGMA_QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

