/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016J8\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTrackerImpl;", "Lcom/android/tools/idea/sqlite/DatabaseInspectorAnalyticsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "trackErrorOccurred", "", "errorKind", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ErrorKind;", "trackTableCellEdited", "trackTargetRefreshed", "targetType", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$TargetType;", "trackStatementExecuted", "connectivityState", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ConnectivityState;", "statementContext", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$StatementContext;", "trackStatementExecutionCanceled", "trackLiveUpdatedToggled", "enabled", "", "trackEnterOfflineModeUserCanceled", "trackOfflineDatabaseDownloadFailed", "trackOfflineModeEntered", "metadata", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$OfflineModeMetadata;", "trackExportDialogOpened", "actionOrigin", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportDialogOpenedEvent$Origin;", "trackExportCompleted", "source", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportOperationCompletedEvent$Source;", "sourceFormat", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportOperationCompletedEvent$SourceFormat;", "destination", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportOperationCompletedEvent$Destination;", "durationMs", "", "outcome", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$ExportOperationCompletedEvent$Outcome;", "track", "inspectorEvent", "Lcom/google/wireless/android/sdk/stats/AppInspectionEvent$DatabaseInspectorEvent$Builder;", "app-inspection.inspectors.database"})
public final class DatabaseInspectorAnalyticsTrackerImpl
implements DatabaseInspectorAnalyticsTracker {
    @NotNull
    private final Project project;

    public DatabaseInspectorAnalyticsTrackerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void trackErrorOccurred(@NotNull AppInspectionEvent.DatabaseInspectorEvent.ErrorKind errorKind) {
        Intrinsics.checkNotNullParameter((Object)errorKind, (String)"errorKind");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.ERROR_OCCURRED).setErrorKind(errorKind);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setErrorKind(...)");
        this.track(builder);
    }

    @Override
    public void trackTableCellEdited() {
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.TABLE_CELL_EDITED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setType(...)");
        this.track(builder);
    }

    @Override
    public void trackTargetRefreshed(@NotNull AppInspectionEvent.DatabaseInspectorEvent.TargetType targetType) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.TARGET_REFRESHED).setTargetType(targetType);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setTargetType(...)");
        this.track(builder);
    }

    @Override
    public void trackStatementExecuted(@NotNull AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState, @NotNull AppInspectionEvent.DatabaseInspectorEvent.StatementContext statementContext) {
        Intrinsics.checkNotNullParameter((Object)connectivityState, (String)"connectivityState");
        Intrinsics.checkNotNullParameter((Object)statementContext, (String)"statementContext");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.STATEMENT_EXECUTED).setConnectivityState(connectivityState).setStatementContext(statementContext);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setStatementContext(...)");
        this.track(builder);
    }

    @Override
    public void trackStatementExecutionCanceled(@NotNull AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState, @NotNull AppInspectionEvent.DatabaseInspectorEvent.StatementContext statementContext) {
        Intrinsics.checkNotNullParameter((Object)connectivityState, (String)"connectivityState");
        Intrinsics.checkNotNullParameter((Object)statementContext, (String)"statementContext");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.STATEMENT_EXECUTION_CANCELED).setConnectivityState(connectivityState).setStatementContext(statementContext);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setStatementContext(...)");
        this.track(builder);
    }

    @Override
    public void trackLiveUpdatedToggled(boolean enabled) {
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.LIVE_UPDATES_TOGGLED).setLiveUpdatingEnabled(enabled);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setLiveUpdatingEnabled(...)");
        this.track(builder);
    }

    @Override
    public void trackEnterOfflineModeUserCanceled() {
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.ENTER_OFFLINE_MODE_USER_CANCELED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setType(...)");
        this.track(builder);
    }

    @Override
    public void trackOfflineDatabaseDownloadFailed() {
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.OFFLINE_DATABASE_DOWNLOAD_FAILED);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setType(...)");
        this.track(builder);
    }

    @Override
    public void trackOfflineModeEntered(@NotNull AppInspectionEvent.DatabaseInspectorEvent.OfflineModeMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.OFFLINE_MODE_ENTERED).setOfflineModeMetadata(metadata);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setOfflineModeMetadata(...)");
        this.track(builder);
    }

    @Override
    public void trackExportDialogOpened(@NotNull AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.Origin actionOrigin) {
        Intrinsics.checkNotNullParameter((Object)actionOrigin, (String)"actionOrigin");
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.EXPORT_DIALOG_OPENED).setExportDialogOpenedEvent(AppInspectionEvent.DatabaseInspectorEvent.ExportDialogOpenedEvent.newBuilder().setOrigin(actionOrigin));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExportDialogOpenedEvent(...)");
        this.track(builder);
    }

    @Override
    public void trackExportCompleted(@NotNull AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent.Source source2, @NotNull AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent.SourceFormat sourceFormat, @NotNull AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent.Destination destination, int durationMs, @NotNull AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent.Outcome outcome, @NotNull AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sourceFormat, (String)"sourceFormat");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter((Object)connectivityState, (String)"connectivityState");
        AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent event = AppInspectionEvent.DatabaseInspectorEvent.ExportOperationCompletedEvent.newBuilder().setSource(source2).setSourceFormat(sourceFormat).setDestination(destination).setExportDurationMs(durationMs).setOutcome(outcome).build();
        AppInspectionEvent.DatabaseInspectorEvent.Builder builder = AppInspectionEvent.DatabaseInspectorEvent.newBuilder().setType(AppInspectionEvent.DatabaseInspectorEvent.Type.EXPORT_OPERATION_COMPLETED).setConnectivityState(connectivityState).setExportCompletedEvent(event);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setExportCompletedEvent(...)");
        this.track(builder);
    }

    private final void track(AppInspectionEvent.DatabaseInspectorEvent.Builder inspectorEvent) {
        AppInspectionEvent.Builder inspectionEvent = AppInspectionEvent.newBuilder().setType(AppInspectionEvent.Type.INSPECTOR_EVENT).setDatabaseInspectorEvent(inspectorEvent);
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_INSPECTION).setAppInspectionEvent(inspectionEvent);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setAppInspectionEvent(...)");
        AndroidStudioEvent.Builder studioEvent = builder;
        String string = this.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        studioEvent.setProjectId(AnonymizerUtil.anonymizeUtf8((String)string));
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }
}

