/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.settingssync;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontWeight;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.settingssync.SettingsSyncFeature;
import com.android.tools.idea.settingssync.onboarding.BackupAndSyncWizardProvider;
import com.android.tools.idea.settingssync.onboarding.ChooseCategoriesStepPage;
import com.android.tools.idea.settingssync.onboarding.EnableOrSkipStepPage;
import com.android.tools.idea.settingssync.onboarding.PushOrPullStepPage;
import com.google.gct.login2.LoginCompletedCallback;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.OAuthScope;
import com.google.gct.login2.PreferredUser;
import com.google.gct.wizard.WizardPage;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.options.ex.Settings;
import icons.StudioIllustrations;
import icons.StudioIllustrationsCompose;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.ui.icon.IconKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/settingssync/SettingsSyncFeature;", "Lcom/google/gct/login2/LoginFeature;", "<init>", "()V", "key", "", "getKey", "()Ljava/lang/String;", "title", "getTitle", "description", "getDescription", "infoUrl", "getInfoUrl", "infoUrlDisplayText", "getInfoUrlDisplayText", "permissionInfoUrl", "getPermissionInfoUrl", "settingsAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getSettingsAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "oAuthScopes", "", "Lcom/google/gct/login2/OAuthScope;", "getOAuthScopes", "()Ljava/util/Collection;", "isAvailable", "", "()Z", "activeUserSwitchRequired", "getActiveUserSwitchRequired", "onboardingWizardEntry", "Lcom/google/gct/login2/LoginFeature$OnboardingWizardEntry;", "getOnboardingWizardEntry", "()Lcom/google/gct/login2/LoginFeature$OnboardingWizardEntry;", "allOnboardingPages", "", "Lcom/google/gct/wizard/WizardPage;", "onLoginCompleted", "Lcom/google/gct/login2/LoginCompletedCallback;", "getOnLoginCompleted", "()Lcom/google/gct/login2/LoginCompletedCallback;", "intellij.android.settings-sync"})
@StabilityInferred(parameters=0)
public final class SettingsSyncFeature
implements LoginFeature {
    @NotNull
    private final String key;
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @Nullable
    private final String infoUrl;
    @Nullable
    private final String infoUrlDisplayText;
    @NotNull
    private final String permissionInfoUrl;
    @NotNull
    private final AnAction settingsAction = new AnAction(){

        public void actionPerformed(AnActionEvent e) {
            block0: {
                Settings settings;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Settings settings2 = settings = (Settings)e.getData(Settings.KEY);
                if (settings2 == null) break block0;
                settings2.select(settings.find("settings.sync"));
            }
        }
    };
    @NotNull
    private final Collection<OAuthScope> oAuthScopes = SetsKt.setOf((Object)((Object)OAuthScope.DriveAppData));
    private final boolean isAvailable;
    private final boolean activeUserSwitchRequired;
    @NotNull
    private final LoginFeature.OnboardingWizardEntry onboardingWizardEntry;
    public static final int $stable = 8;

    public SettingsSyncFeature() {
        this.key = "Backup and Sync";
        this.title = "Backup and Sync";
        this.description = "Sync your settings to your Google Account to keep them across computers and re-installs.";
        this.permissionInfoUrl = "https://d.android.com/r/studio-ui/settings-sync/permissions";
        Object t = StudioFlags.SETTINGS_SYNC_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this.isAvailable = (Boolean)t;
        this.onboardingWizardEntry = new LoginFeature.OnboardingWizardEntry(){
            private final Icon icon;
            private final IconKey composeIconKey;
            private final String title;
            private final AnnotatedString annotatedTitle;
            private final String description;
            {
                void $this$withStyle$iv;
                void $this$annotatedTitle_u24lambda_u240;
                AnnotatedString.Builder builder;
                Icon icon = StudioIllustrations.Common.GOOGLE_LOGO;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GOOGLE_LOGO");
                this.icon = icon;
                this.composeIconKey = (IconKey)StudioIllustrationsCompose.Common.INSTANCE.getGoogleLogo();
                this.title = "<b>Google Account Storage:</b> Enable Backup and Sync";
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                onboardingWizardEntry.1 var11_4 = this;
                boolean bl = false;
                void var5_6 = $this$annotatedTitle_u24lambda_u240;
                SpanStyle style$iv = new SpanStyle(0L, 0L, FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65531, null);
                boolean $i$f$withStyle = false;
                int index$iv = $this$withStyle$iv.pushStyle(style$iv);
                try {
                    void $this$annotatedTitle_u24lambda_u240_u240 = $this$withStyle$iv;
                    boolean bl2 = false;
                    $this$annotatedTitle_u24lambda_u240_u240.append("Google Account Storage:");
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withStyle$iv.pop(index$iv);
                }
                $this$annotatedTitle_u24lambda_u240.append(" Enable Backup and Sync");
                var11_4.annotatedTitle = builder.toAnnotatedString();
                this.description = "Backup and Sync backs up your IDE settings to your Google Account and restores them to other workstations signed into the same account so that your Android Studio experience is just the way you like it.";
            }

            public Icon getIcon() {
                return this.icon;
            }

            public IconKey getComposeIconKey() {
                return this.composeIconKey;
            }

            public String getTitle() {
                return this.title;
            }

            public AnnotatedString getAnnotatedTitle() {
                return this.annotatedTitle;
            }

            public String getDescription() {
                return this.description;
            }

            public List<WizardPage> getPages() {
                Object[] objectArray = new WizardPage[]{new EnableOrSkipStepPage(), new PushOrPullStepPage()};
                return CollectionsKt.listOf((Object[])objectArray);
            }
        };
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Override
    @Nullable
    public String getInfoUrlDisplayText() {
        return this.infoUrlDisplayText;
    }

    @Override
    @NotNull
    public String getPermissionInfoUrl() {
        return this.permissionInfoUrl;
    }

    @Override
    @NotNull
    public AnAction getSettingsAction() {
        return this.settingsAction;
    }

    @Override
    @NotNull
    public Collection<OAuthScope> getOAuthScopes() {
        return this.oAuthScopes;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    public boolean getActiveUserSwitchRequired() {
        return this.activeUserSwitchRequired;
    }

    @Override
    @NotNull
    public LoginFeature.OnboardingWizardEntry getOnboardingWizardEntry() {
        return this.onboardingWizardEntry;
    }

    @NotNull
    public final List<WizardPage> allOnboardingPages() {
        Object[] objectArray = new WizardPage[]{new EnableOrSkipStepPage(), new PushOrPullStepPage(), new ChooseCategoriesStepPage()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public LoginCompletedCallback getOnLoginCompleted() {
        return SettingsSyncFeature::_get_onLoginCompleted_$lambda$0;
    }

    private static final void _get_onLoginCompleted_$lambda$0(PreferredUser user, GoogleLoginPluginEvent.LoginType loginType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)loginType, (String)"loginType");
            if (WhenMappings.$EnumSwitchMapping$0[loginType.ordinal()] != 1) break block0;
            ActionsKt.runInEdt$default(null, () -> SettingsSyncFeature._get_onLoginCompleted_$lambda$0$0(user), (int)1, null);
        }
    }

    private static final Unit _get_onLoginCompleted_$lambda$0$0(PreferredUser $user) {
        BackupAndSyncWizardProvider.Companion.create().createDialog($user).showAndGet();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GoogleLoginPluginEvent.LoginType.values().length];
            try {
                nArray[GoogleLoginPluginEvent.LoginType.FEATURE_LOGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

