/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Checksum;
import com.android.repository.api.Downloader;
import com.android.repository.api.SettingsController;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.progress.StudioProgressIndicatorAdapter;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.NetUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioDownloader
implements Downloader {
    @VisibleForTesting
    static final String DOWNLOAD_SUFFIX_FN = ".asdownload";
    @Nullable
    Path mDownloadIntermediatesLocation;
    @NotNull
    private final SettingsController mySettingsController;
    @NotNull
    private final RepositoryAddonsListVersionUrlFilter myUrlFilter = new RiscVUrlFilter();

    public StudioDownloader() {
        this(StudioSettingsController.getInstance());
    }

    @VisibleForTesting
    StudioDownloader(@NotNull SettingsController settingsController) {
        this.mySettingsController = settingsController;
    }

    @Nullable
    public InputStream downloadAndStream(@NotNull URL url, @NotNull com.android.repository.api.ProgressIndicator indicator) throws IOException {
        return this.downloadAndStreamWithOptions(url, indicator, StandardOpenOption.DELETE_ON_CLOSE);
    }

    @Nullable
    public InputStream downloadAndStreamWithOptions(@NotNull URL url, @NotNull com.android.repository.api.ProgressIndicator indicator, OpenOption ... streamOpenOptions) throws IOException {
        Path file = this.downloadFully(url, indicator);
        if (file == null) {
            return null;
        }
        return CancellableFileIo.newInputStream((Path)file, (OpenOption[])streamOpenOptions);
    }

    public void downloadFully(@NotNull URL url, @NotNull Path target2, @Nullable Checksum checksum, @NotNull com.android.repository.api.ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target2, checksum, false, indicator);
    }

    public void downloadFullyWithCaching(@NotNull URL url, @NotNull Path target2, @Nullable Checksum checksum, @NotNull com.android.repository.api.ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target2, checksum, true, indicator);
    }

    public void setDownloadIntermediatesLocation(@Nullable Path downloadIntermediatesLocation) {
        try {
            if (downloadIntermediatesLocation != null) {
                PathUtils.createDirectories((Path)downloadIntermediatesLocation);
            }
            this.mDownloadIntermediatesLocation = downloadIntermediatesLocation;
        }
        catch (IOException exception) {
            Logger.getInstance(StudioDownloader.class).warn("Unable resolve intermediates location", (Throwable)exception);
        }
    }

    private void doDownloadFully(@NotNull URL url, @NotNull Path target2, @Nullable Checksum checksum, boolean allowNetworkCaches, @NotNull com.android.repository.api.ProgressIndicator indicator) throws IOException {
        block27: {
            if (!this.myUrlFilter.isUrlAllowed(url)) {
                throw new HttpRequests.HttpStatusException("URL may exist, but is internally disabled by " + this.myUrlFilter.getClass().getName(), 404, url.toExternalForm());
            }
            if (CancellableFileIo.exists((Path)target2, (LinkOption[])new LinkOption[0]) && checksum != null) {
                try (BufferedInputStream stream = new BufferedInputStream(CancellableFileIo.newInputStream((Path)target2, (OpenOption[])new OpenOption[0]));){
                    String hash = Downloader.hash((InputStream)stream, (long)CancellableFileIo.size((Path)target2), (String)checksum.getType(), (com.android.repository.api.ProgressIndicator)indicator.createSubProgress(0.1));
                    if (checksum.getValue().equals(hash)) {
                        return;
                    }
                }
            }
            String preparedUrl = this.prepareUrl(url);
            indicator.logInfo("Downloading " + preparedUrl);
            indicator.setText("Starting download...");
            indicator.setSecondaryText(preparedUrl);
            RequestBuilder rb = HttpRequests.request((String)preparedUrl).productNameAsUserAgent();
            if (this.mySettingsController.getForceHttp()) {
                rb.forceHttps(false);
            }
            rb.tuner(c -> c.setUseCaches(allowNetworkCaches));
            Path interimDownload = this.getInterimDownloadLocationForTarget(target2);
            boolean interimExists = CancellableFileIo.exists((Path)interimDownload, (LinkOption[])new LinkOption[0]);
            if (interimExists) {
                if (allowNetworkCaches) {
                    String rangeHeader = String.format("bytes=%1$s-", CancellableFileIo.size((Path)interimDownload));
                    rb.tuner(c -> c.setRequestProperty("Range", rangeHeader));
                    rb.gzip(false);
                } else {
                    Files.deleteIfExists(interimDownload);
                }
            }
            try {
                rb.connect(request -> {
                    long startOffset = interimExists ? CancellableFileIo.size((Path)interimDownload) : 0L;
                    long contentLength = startOffset + request.getConnection().getContentLengthLong();
                    DownloadProgressIndicator downloadProgressIndicator = new DownloadProgressIndicator(indicator.createSubProgress(0.8), target2.getFileName().toString(), contentLength, startOffset);
                    PathUtils.createDirectories((Path)interimDownload.getParent());
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(interimDownload, StandardOpenOption.APPEND, StandardOpenOption.CREATE));){
                        NetUtils.copyStreamContent((ProgressIndicator)downloadProgressIndicator, (InputStream)request.getInputStream(), (OutputStream)out, (long)request.getConnection().getContentLengthLong());
                    }
                    return null;
                });
            }
            catch (HttpRequests.HttpStatusException e) {
                if (e.getStatusCode() == 416) {
                    indicator.logInfo("Intermediate file is already complete");
                }
                throw e;
            }
            try {
                PathUtils.createDirectories((Path)target2.getParent());
                Files.move(interimDownload, target2, StandardCopyOption.REPLACE_EXISTING);
                if (!CancellableFileIo.exists((Path)target2, (LinkOption[])new LinkOption[0]) || checksum == null) break block27;
                try (BufferedInputStream stream = new BufferedInputStream(CancellableFileIo.newInputStream((Path)target2, (OpenOption[])new OpenOption[0]));){
                    String hash = Downloader.hash((InputStream)stream, (long)CancellableFileIo.size((Path)target2), (String)checksum.getType(), (com.android.repository.api.ProgressIndicator)indicator.createSubProgress(1.0));
                    if (!checksum.getValue().equals(hash)) {
                        throw new IllegalStateException("Checksum of the downloaded result didn't match the expected value.");
                    }
                }
            }
            catch (Throwable e) {
                if (allowNetworkCaches) {
                    indicator.logWarning("This download could not be finalized from the interim state. Retrying without caching.", e);
                    try {
                        Files.delete(interimDownload);
                        Files.delete(target2);
                    }
                    catch (Exception deleteException) {
                        indicator.logWarning("Error removing interim files, continuing with download", (Throwable)deleteException);
                    }
                    this.doDownloadFully(url, target2, checksum, false, indicator);
                }
                throw e;
            }
        }
    }

    @NotNull
    private Path getInterimDownloadLocationForTarget(@NotNull Path target2) {
        if (this.mDownloadIntermediatesLocation != null) {
            return this.mDownloadIntermediatesLocation.resolve(target2.getFileName().toString() + DOWNLOAD_SUFFIX_FN);
        }
        return target2.getFileSystem().getPath(String.valueOf(target2) + DOWNLOAD_SUFFIX_FN, new String[0]);
    }

    @Nullable
    public Path downloadFully(@NotNull URL url, @NotNull com.android.repository.api.ProgressIndicator indicator) throws IOException {
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf(47) + 1);
        Path tempDir = this.mDownloadIntermediatesLocation == null ? Paths.get(System.getProperty("java.io.tmpdir"), new String[0]) : this.mDownloadIntermediatesLocation;
        Path tempFile = Files.createTempFile(tempDir, suffix, "", new FileAttribute[0]);
        PathUtils.addRemovePathHook((Path)tempFile);
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile;
    }

    @VisibleForTesting
    @NotNull
    String prepareUrl(@NotNull URL url) {
        Object prepared = url.toExternalForm();
        if (this.mySettingsController.getForceHttp() && StringUtil.startsWith((CharSequence)prepared, (CharSequence)"https:")) {
            prepared = "http:" + ((String)prepared).substring(6);
        }
        return prepared;
    }

    @VisibleForTesting
    static class RiscVUrlFilter
    extends RepositoryAddonsListVersionUrlFilter {
        RiscVUrlFilter() {
        }

        @Override
        protected int getMaximumVersionAllowed() {
            if (((Boolean)StudioFlags.RISC_V.get()).booleanValue()) {
                return -1;
            }
            return 5;
        }
    }

    @VisibleForTesting
    static abstract class RepositoryAddonsListVersionUrlFilter {
        private static final Pattern addonsListPattern = Pattern.compile("/addons_list-(\\d+).xml$");

        RepositoryAddonsListVersionUrlFilter() {
        }

        public boolean isUrlAllowed(@NotNull URL url) {
            Matcher matcher;
            int maximumVersionAllowed = this.getMaximumVersionAllowed();
            if (maximumVersionAllowed >= 0 && (matcher = addonsListPattern.matcher(url.getPath())).find()) {
                try {
                    int versionNumber = Integer.parseInt(matcher.group(1));
                    if (versionNumber > maximumVersionAllowed) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }

        protected abstract int getMaximumVersionAllowed();
    }

    @VisibleForTesting
    static class DownloadProgressIndicator
    extends StudioProgressIndicatorAdapter {
        private final String mTargetName;
        private final long mContentLength;
        private final String mTotalDisplaySize;
        private int mCurrentPercentage;
        private long mStartOffset;
        private Storage.Unit mReasonableUnit;

        DownloadProgressIndicator(@NotNull com.android.repository.api.ProgressIndicator wrapped, @NotNull String targetName, long contentLength, long startOffset) {
            super(wrapped);
            this.mTargetName = targetName;
            if (contentLength > 0L) {
                this.mCurrentPercentage = (int)((double)this.mStartOffset / (double)contentLength);
                this.mContentLength = contentLength;
                this.mStartOffset = startOffset;
                Storage storage = new Storage(this.mContentLength);
                this.mReasonableUnit = storage.getLargestReasonableUnits();
                this.mTotalDisplaySize = storage.toUiString(Locale.US, 1);
                this.setIndeterminate(false);
            } else {
                this.mCurrentPercentage = 0;
                this.mContentLength = 0L;
                this.mStartOffset = 0L;
                this.mTotalDisplaySize = null;
                this.setText(String.format("Downloading %s...", this.mTargetName));
                this.setIndeterminate(true);
            }
        }

        public void setFraction(double fraction) {
            if (this.isIndeterminate()) {
                return;
            }
            double adjustedFraction = ((double)this.mStartOffset + fraction * (double)(this.mContentLength - this.mStartOffset)) / (double)this.mContentLength;
            super.setFraction(adjustedFraction);
            this.checkCanceled();
            int percentage = (int)(adjustedFraction * 100.0);
            if (percentage == this.mCurrentPercentage) {
                return;
            }
            this.mCurrentPercentage = percentage;
            long downloadedSize = (long)(adjustedFraction * (double)this.mContentLength);
            double downloadedSizeInReasonableUnits = new Storage(downloadedSize).getPreciseSizeAsUnit(this.mReasonableUnit);
            this.setText(String.format(Locale.US, "Downloading %1$s (%2$d%%): %3$.1f / %4$s ...", this.mTargetName, this.mCurrentPercentage, downloadedSizeInReasonableUnits, this.mTotalDisplaySize));
        }
    }
}

