/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.Arrays;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public enum InstallOption {
    DEFAULT_APK("Default APK"),
    APK_FROM_BUNDLE("APK from app bundle"),
    CUSTOM_ARTIFACT("Custom Artifact"),
    NOTHING("Nothing");

    public final String displayName;

    private InstallOption(String displayName) {
        this.displayName = displayName;
    }

    public static List<InstallOption> supportedValues() {
        if (((Boolean)StudioFlags.SUPPORT_CUSTOM_ARTIFACTS.get()).booleanValue()) {
            return Arrays.asList(InstallOption.values());
        }
        return List.of(DEFAULT_APK, APK_FROM_BUNDLE, NOTHING);
    }

    public static class Renderer
    extends ColoredListCellRenderer<InstallOption> {
        protected void customizeCellRenderer(@NotNull JList list2, InstallOption option, int index, boolean selected, boolean hasFocus) {
            this.append(option.displayName);
        }
    }
}

