/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.selector;

import com.android.sdklib.deviceprovisioner.DeviceId;
import com.android.tools.idea.run.DeviceHandleAndroidDevice;
import com.android.tools.idea.run.DeviceProvisionerAndroidDevice;
import com.android.tools.idea.run.deployment.selector.BootOption;
import com.android.tools.idea.run.deployment.selector.BootSnapshot;
import com.android.tools.idea.run.deployment.selector.ColdBoot;
import com.android.tools.idea.run.deployment.selector.DefaultBoot;
import com.android.tools.idea.run.deployment.selector.DeploymentTargetDevice;
import com.android.tools.idea.run.deployment.selector.TargetId;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/run/deployment/selector/DeploymentTarget;", "", "device", "Lcom/android/tools/idea/run/deployment/selector/DeploymentTargetDevice;", "bootOption", "Lcom/android/tools/idea/run/deployment/selector/BootOption;", "<init>", "(Lcom/android/tools/idea/run/deployment/selector/DeploymentTargetDevice;Lcom/android/tools/idea/run/deployment/selector/BootOption;)V", "getDevice", "()Lcom/android/tools/idea/run/deployment/selector/DeploymentTargetDevice;", "getBootOption", "()Lcom/android/tools/idea/run/deployment/selector/BootOption;", "deviceId", "Lcom/android/sdklib/deviceprovisioner/DeviceId;", "getDeviceId", "()Lcom/android/sdklib/deviceprovisioner/DeviceId;", "templateId", "getTemplateId", "boot", "", "id", "Lcom/android/tools/idea/run/deployment/selector/TargetId;", "getId", "()Lcom/android/tools/idea/run/deployment/selector/TargetId;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
public final class DeploymentTarget {
    @NotNull
    private final DeploymentTargetDevice device;
    @NotNull
    private final BootOption bootOption;

    public DeploymentTarget(@NotNull DeploymentTargetDevice device2, @NotNull BootOption bootOption) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)bootOption, (String)"bootOption");
        this.device = device2;
        this.bootOption = bootOption;
    }

    @NotNull
    public final DeploymentTargetDevice getDevice() {
        return this.device;
    }

    @NotNull
    public final BootOption getBootOption() {
        return this.bootOption;
    }

    @NotNull
    public final DeviceId getDeviceId() {
        return this.device.getId();
    }

    @Nullable
    public final DeviceId getTemplateId() {
        return this.device.getTemplateId();
    }

    public final void boot() {
        BootOption bootOption = this.bootOption;
        if (bootOption instanceof BootSnapshot) {
            DeviceProvisionerAndroidDevice deviceProvisionerAndroidDevice = this.device.getAndroidDevice();
            Intrinsics.checkNotNull((Object)deviceProvisionerAndroidDevice, (String)"null cannot be cast to non-null type com.android.tools.idea.run.DeviceHandleAndroidDevice");
            v1 = ((DeviceHandleAndroidDevice)deviceProvisionerAndroidDevice).bootFromSnapshot(((BootSnapshot)this.bootOption).getSnapshot());
        } else if (Intrinsics.areEqual((Object)bootOption, (Object)ColdBoot.INSTANCE)) {
            DeviceProvisionerAndroidDevice deviceProvisionerAndroidDevice = this.device.getAndroidDevice();
            Intrinsics.checkNotNull((Object)deviceProvisionerAndroidDevice, (String)"null cannot be cast to non-null type com.android.tools.idea.run.DeviceHandleAndroidDevice");
            v1 = ((DeviceHandleAndroidDevice)deviceProvisionerAndroidDevice).coldBoot();
        } else if (Intrinsics.areEqual((Object)bootOption, (Object)DefaultBoot.INSTANCE)) {
            v1 = this.device.getAndroidDevice().bootDefault();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final TargetId getId() {
        return new TargetId(this.getDeviceId(), this.getTemplateId(), this.bootOption);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DeploymentTarget && Intrinsics.areEqual((Object)this.getId(), (Object)((DeploymentTarget)other).getId()) && Intrinsics.areEqual((Object)this.bootOption, (Object)((DeploymentTarget)other).bootOption);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.bootOption};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "Target(" + this.bootOption + ", " + this.getId() + ")";
    }
}

