/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditMarkerInfoConsumer;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.r8.ExtractMarker;
import com.android.tools.r8.ExtractMarkerCommand;
import com.android.tools.r8.MarkerInfoConsumer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0017\u001a\u00060\u0006j\u0002`\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001e\u0010\u0018\u001a\u00020\u0019*\f\u0012\b\u0012\u00060\u0006j\u0002`\n0\t2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u00060\u0006j\u0002`\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/LiveEditApp;", "", "apks", "", "Ljava/nio/file/Path;", "deviceAPILevel", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ApiLevel;", "buildSystemAPILevels", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "<init>", "(Ljava/util/Set;ILjava/util/Set;)V", "minAPI", "getMinAPI", "()I", "minAPI$delegate", "Lkotlin/Lazy;", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "journal", "", "", "calculateMinAPI", "extractMinApiFromDexMarkers", "", "apk", "msg", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditApp.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditApp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1869#2,2:78\n1#3:80\n*S KotlinDebug\n*F\n+ 1 LiveEditApp.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditApp\n*L\n45#1:78,2\n*E\n"})
public final class LiveEditApp {
    @NotNull
    private final Set<Path> apks;
    private final int deviceAPILevel;
    @NotNull
    private final Set<Integer> buildSystemAPILevels;
    @NotNull
    private final Lazy minAPI$delegate;
    @NotNull
    private final LiveEditLogger logger;
    @NotNull
    private final List<String> journal;

    public LiveEditApp(@NotNull Set<? extends Path> apks, int deviceAPILevel, @NotNull Set<Integer> buildSystemAPILevels) {
        Intrinsics.checkNotNullParameter(apks, (String)"apks");
        Intrinsics.checkNotNullParameter(buildSystemAPILevels, (String)"buildSystemAPILevels");
        this.apks = apks;
        this.deviceAPILevel = deviceAPILevel;
        this.buildSystemAPILevels = buildSystemAPILevels;
        this.minAPI$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> LiveEditApp.minAPI_delegate$lambda$0(this));
        this.logger = new LiveEditLogger("LE App");
        this.journal = new ArrayList();
    }

    public /* synthetic */ LiveEditApp(Set set2, int n, Set set3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            set3 = new LinkedHashSet();
        }
        this(set2, n, set3);
    }

    public final int getMinAPI() {
        Lazy lazy = this.minAPI$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int calculateMinAPI(Set<? extends Path> apks) {
        Set minApis;
        long start2 = System.nanoTime();
        if (this.buildSystemAPILevels.isEmpty()) {
            Set set2;
            Set $this$calculateMinAPI_u24lambda_u240 = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            Iterable $this$forEach$iv = apks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                this.extractMinApiFromDexMarkers($this$calculateMinAPI_u24lambda_u240, it);
            }
            v0 = set2;
        } else {
            this.journal("Build system minSdkVersionForDexing = " + CollectionsKt.joinToString$default((Iterable)this.buildSystemAPILevels, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            v0 = minApis = this.buildSystemAPILevels;
        }
        if (minApis.size() > 1 && !((Boolean)StudioFlags.COMPOSE_DEPLOY_LIVE_EDIT_ALLOW_MULTIPLE_MIN_API_DEX_MARKERS_IN_APK.get()).booleanValue()) {
            throw LiveEditUpdateException.Companion.badMinAPIError$default(LiveEditUpdateException.Companion, "Too many minAPI. Details:\n " + CollectionsKt.joinToString$default((Iterable)this.journal, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 2, null);
        }
        if (minApis.isEmpty()) {
            this.logger.log$intellij_android_core("APks " + apks + " did not contain R8 markers (not desugared?). Falling back to device api=" + this.deviceAPILevel);
            minApis.add(this.deviceAPILevel);
        }
        long duration = (System.nanoTime() - start2) / (long)1000000;
        this.logger.log$intellij_android_core("Found minAPI = " + minApis + " in " + duration + "ms");
        Iterator iterator2 = ((Iterable)minApis).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        int it = ((Number)iterator2.next()).intValue();
        boolean bl = false;
        int n = it;
        while (iterator2.hasNext()) {
            int it2 = ((Number)iterator2.next()).intValue();
            $i$a$-minOf-LiveEditApp$calculateMinAPI$1 = false;
            int n2 = it2;
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    private final void extractMinApiFromDexMarkers(Set<Integer> $this$extractMinApiFromDexMarkers, Path apk) {
        LiveEditMarkerInfoConsumer consumer2 = new LiveEditMarkerInfoConsumer();
        Path[] pathArray = new Path[]{apk};
        ExtractMarker.run((ExtractMarkerCommand)ExtractMarkerCommand.builder().addProgramFiles(pathArray).setMarkerInfoConsumer((MarkerInfoConsumer)consumer2).build());
        this.journal("Apk '" + apk.getFileName() + "' contains minAPI = " + consumer2.getMinApis());
        $this$extractMinApiFromDexMarkers.addAll((Collection<Integer>)consumer2.getMinApis());
    }

    private final void journal(String msg) {
        this.logger.log$intellij_android_core(msg);
        this.journal.add(msg);
    }

    private static final int minAPI_delegate$lambda$0(LiveEditApp this$0) {
        return this$0.calculateMinAPI(this$0.apks);
    }
}

