/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.deployable.Device;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationIdResolver
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, Device> myDevices = new ConcurrentHashMap<IDevice, Device>();
    @NotNull
    private final ExecutorService myApplicationIdResolverExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Package-Name-Resolver", (int)4);

    public ApplicationIdResolver() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myApplicationIdResolverExecutor.shutdownNow();
        try {
            if (!this.myApplicationIdResolverExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                Logger.getInstance(ApplicationIdResolver.class).warn("ApplicationIdResolver failed to shut down its executor within the time limit.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @NotNull
    public List<Client> resolve(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        Device device2 = this.myDevices.get(iDevice);
        return device2 == null ? Collections.emptyList() : device2.findClientWithApplicationId(applicationId2);
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected()) {
            for (IDevice iDevice : bridge.getDevices()) {
                this.refresh(iDevice);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device2) {
        this.refresh(device2);
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        this.myDevices.remove(device2);
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        if ((changeMask & 3) != 0) {
            this.refresh(device2);
        }
    }

    private void refresh(@NotNull IDevice iDevice) {
        this.myDevices.compute(iDevice, (ignored, device2) -> {
            if (!iDevice.isOnline()) {
                return null;
            }
            Device newDevice = device2;
            if (newDevice == null) {
                newDevice = new Device(this.myApplicationIdResolverExecutor, iDevice);
            }
            newDevice.refresh();
            return newDevice;
        });
    }
}

