/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.ddmlib.IDevice;
import com.android.ide.common.build.BaselineProfileDetails;
import com.android.tools.deployer.Deployer;
import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.android.tools.idea.execution.common.ApplicationDeployer;
import com.android.tools.idea.execution.common.DeployOptions;
import com.android.tools.idea.execution.common.stats.RunStats;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.configuration.execution.ApplicationDeployListener;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.android.tools.idea.run.tasks.ApplyChangesTask;
import com.android.tools.idea.run.tasks.ApplyCodeChangesTask;
import com.android.tools.idea.run.tasks.DeployTask;
import com.android.tools.idea.util.DynamicAppUtils;
import com.google.wireless.android.sdk.stats.ArtifactDetail;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/run/configuration/execution/ApplicationDeployerImpl;", "Lcom/android/tools/idea/execution/common/ApplicationDeployer;", "project", "Lcom/intellij/openapi/project/Project;", "stats", "Lcom/android/tools/idea/execution/common/stats/RunStats;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/execution/common/stats/RunStats;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fullDeploy", "Lcom/android/tools/deployer/Deployer$Result;", "device", "Lcom/android/ddmlib/IDevice;", "app", "Lcom/android/tools/idea/run/ApkInfo;", "deployOptions", "Lcom/android/tools/idea/execution/common/DeployOptions;", "hasMakeBeforeRun", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "applyChangesDeploy", "applyCodeChangesDeploy", "filterDisabledFeatures", "apkInfo", "disabledFeatures", "", "", "runDeployTask", "deployTask", "Lcom/android/tools/idea/run/tasks/AbstractDeployTask;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nApplicationDeployerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationDeployerImpl.kt\ncom/android/tools/idea/run/configuration/execution/ApplicationDeployerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RunStatsUtils.kt\ncom/android/tools/idea/execution/common/stats/RunStatsUtilsKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n38#3,10:163\n*S KotlinDebug\n*F\n+ 1 ApplicationDeployerImpl.kt\ncom/android/tools/idea/run/configuration/execution/ApplicationDeployerImpl\n*L\n101#1:160\n101#1:161,2\n110#1:163,10\n*E\n"})
public final class ApplicationDeployerImpl
implements ApplicationDeployer {
    @NotNull
    private final Project project;
    @NotNull
    private final RunStats stats;
    @NotNull
    private final Logger LOG;

    public ApplicationDeployerImpl(@NotNull Project project, @NotNull RunStats stats) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.project = project;
        this.stats = stats;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @Override
    @NotNull
    public Deployer.Result fullDeploy(@NotNull IDevice device2, @NotNull ApkInfo app, @NotNull DeployOptions deployOptions, boolean hasMakeBeforeRun, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)deployOptions, (String)"deployOptions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.LOG.info("Full deploy on " + device2);
        ((ApplicationDeployListener)this.project.getMessageBus().syncPublisher(ApplicationDeployListener.TOPIC)).beforeDeploy(device2, app);
        DeployTask deployTask = new DeployTask(this.project, CollectionsKt.listOf((Object)this.filterDisabledFeatures(app, deployOptions.getDisabledDynamicFeatures())), deployOptions.getPmInstallFlags(), deployOptions.getInstallOnAllUsers(), deployOptions.getAlwaysInstallWithPm(), deployOptions.getAllowAssumeVerified(), hasMakeBeforeRun);
        return this.runDeployTask(app, deployTask, device2, indicator);
    }

    @Override
    @NotNull
    public Deployer.Result applyChangesDeploy(@NotNull IDevice device2, @NotNull ApkInfo app, @NotNull DeployOptions deployOptions, boolean hasMakeBeforeRun, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)deployOptions, (String)"deployOptions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.LOG.info("Apply Changes on " + device2);
        ((ApplicationDeployListener)this.project.getMessageBus().syncPublisher(ApplicationDeployListener.TOPIC)).beforeDeploy(device2, app);
        ApplyChangesTask deployTask = new ApplyChangesTask(this.project, CollectionsKt.listOf((Object)this.filterDisabledFeatures(app, deployOptions.getDisabledDynamicFeatures())), DeploymentConfiguration.getInstance().APPLY_CHANGES_FALLBACK_TO_RUN, deployOptions.getAlwaysInstallWithPm(), deployOptions.getAllowAssumeVerified(), hasMakeBeforeRun);
        return this.runDeployTask(app, deployTask, device2, indicator);
    }

    @Override
    @NotNull
    public Deployer.Result applyCodeChangesDeploy(@NotNull IDevice device2, @NotNull ApkInfo app, @NotNull DeployOptions deployOptions, boolean hasMakeBeforeRun, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)deployOptions, (String)"deployOptions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.LOG.info("Apply Code Changes on " + device2);
        ((ApplicationDeployListener)this.project.getMessageBus().syncPublisher(ApplicationDeployListener.TOPIC)).beforeDeploy(device2, app);
        ApplyCodeChangesTask deployTask = new ApplyCodeChangesTask(this.project, CollectionsKt.listOf((Object)this.filterDisabledFeatures(app, deployOptions.getDisabledDynamicFeatures())), DeploymentConfiguration.getInstance().APPLY_CODE_CHANGES_FALLBACK_TO_RUN, deployOptions.getAlwaysInstallWithPm(), deployOptions.getAllowAssumeVerified(), hasMakeBeforeRun);
        return this.runDeployTask(app, deployTask, device2, indicator);
    }

    /*
     * WARNING - void declaration
     */
    private final ApkInfo filterDisabledFeatures(ApkInfo apkInfo, List<String> disabledFeatures) {
        ApkInfo apkInfo2;
        if (apkInfo.getFiles().size() > 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = apkInfo.getFiles();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ApkFileUnit feature = (ApkFileUnit)element$iv$iv;
                boolean bl = false;
                if (!DynamicAppUtils.isFeatureEnabled(disabledFeatures, feature)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            apkInfo2 = ApkInfo.copy$default(apkInfo, filtered, null, null, false, null, null, 62, null);
        } else {
            apkInfo2 = apkInfo;
        }
        return apkInfo2;
    }

    /*
     * WARNING - void declaration
     */
    private final Deployer.Result runDeployTask(ApkInfo app, AbstractDeployTask deployTask, IDevice device2, ProgressIndicator indicator) {
        Deployer.Result result2;
        void $this$track$iv;
        RunStats runStats = this.stats;
        String string = deployTask.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String taskId$iv = string;
        boolean $i$f$track = false;
        RunStats.CustomTask customTask = $this$track$iv.beginCustomTask(taskId$iv);
        Intrinsics.checkNotNullExpressionValue((Object)customTask, (String)"beginCustomTask(...)");
        RunStats.CustomTask customTask$iv = customTask;
        try {
            LaunchTaskDetail.Builder builder = customTask$iv.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getBuilder(...)");
            LaunchTaskDetail.Builder $this$runDeployTask_u24lambda_u240 = builder;
            boolean bl = false;
            for (ApkFileUnit unit : app.getFiles()) {
                ArtifactDetail.Builder artifactDetailBuilder = ArtifactDetail.newBuilder();
                artifactDetailBuilder.setSize(unit.getApkFile().length());
                artifactDetailBuilder.setType(ArtifactDetail.ArtifactType.APK);
                $this$runDeployTask_u24lambda_u240.addArtifact(artifactDetailBuilder);
            }
            for (BaselineProfileDetails bpSet : app.getBaselineProfiles()) {
                int n = bpSet.getMinApi();
                int n2 = bpSet.getMaxApi();
                int n3 = device2.getVersion().getApiLevel();
                boolean bl2 = n <= n3 ? n3 <= n2 : false;
                if (!bl2) continue;
                for (File bpFile : bpSet.getBaselineProfileFiles()) {
                    ArtifactDetail.Builder artifactDetailBuilder = ArtifactDetail.newBuilder();
                    artifactDetailBuilder.setSize(bpFile.length());
                    artifactDetailBuilder.setType(ArtifactDetail.ArtifactType.BASELINE_PROFILE);
                    $this$runDeployTask_u24lambda_u240.addArtifact(artifactDetailBuilder);
                }
            }
            List<Deployer.Result> list2 = deployTask.run(device2, indicator);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"run(...)");
            result2 = (Deployer.Result)CollectionsKt.single(list2);
        }
        catch (Throwable t$iv) {
            $this$track$iv.endCustomTask(customTask$iv, t$iv);
            throw t$iv;
        }
        Deployer.Result it$iv = result2;
        boolean bl = false;
        $this$track$iv.endCustomTask(customTask$iv, null);
        Deployer.Result result3 = result2;
        this.stats.addAllLaunchTaskDetail((Iterable<LaunchTaskDetail>)deployTask.getSubTaskDetails());
        Intrinsics.checkNotNull((Object)result3);
        return result3;
    }
}

