/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.NonGradleAndroidArtifactResolver;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonGradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @Nullable
    private final String myArtifactName;

    public NonGradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @Nullable String artifactName) {
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myArtifactName = artifactName;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device2) throws ApkProvisionException {
        String packageName = this.myApplicationIdProvider.getPackageName();
        HashMap<AndroidFacet, String> depFacet2PackageName = new HashMap<AndroidFacet, String>();
        NonGradleApkProvider.fillRuntimeAndTestDependencies(this.myFacet.getModule(), depFacet2PackageName);
        NonGradleApkProvider.checkPackageNames(depFacet2PackageName, this.myFacet, packageName);
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        this.addApk(apkList, packageName, this.myFacet);
        for (AndroidFacet depFacet : depFacet2PackageName.keySet()) {
            this.addApk(apkList, depFacet2PackageName.get(depFacet), depFacet);
        }
        return apkList;
    }

    private void addApk(@NotNull List<ApkInfo> apkList, @NotNull String packageName, @NotNull AndroidFacet facet) throws ApkProvisionException {
        Module module = facet.getModule();
        String localPath = this.myArtifactName != null && !this.myArtifactName.isEmpty() ? NonGradleAndroidArtifactResolver.getInstance().getModuleApkPathByArtifactName(module, this.myArtifactName) : AndroidCompileUtil.getUnsignedApkPath(facet);
        if (localPath == null) {
            throw new ApkProvisionException("ERROR: APK path is not specified for module \"" + module.getName() + "\"");
        }
        apkList.add(new ApkInfo(new File(localPath), packageName));
    }

    private static void fillRuntimeAndTestDependencies(@NotNull Module module, @NotNull Map<AndroidFacet, String> module2PackageName) throws ApkProvisionException {
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            AndroidFacet depFacet;
            ModuleOrderEntry moduleOrderEntry;
            Module depModule;
            if (!(entry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || module2PackageName.containsKey(depFacet) || !((AndroidFacetConfiguration)depFacet.getConfiguration()).isAppProject()) continue;
            String packageName = NonGradleApplicationIdProvider.computePackageName(depFacet);
            module2PackageName.put(depFacet, packageName);
            NonGradleApkProvider.fillRuntimeAndTestDependencies(depModule, module2PackageName);
        }
    }

    private static void checkPackageNames(@NotNull Map<AndroidFacet, String> additionalFacet2PackageName, @NotNull AndroidFacet facet, @NotNull String mainPackageName) throws ApkProvisionException {
        HashMap<String, ArrayList<String>> packageName2ModuleNames = new HashMap<String, ArrayList<String>>();
        packageName2ModuleNames.put(mainPackageName, new ArrayList<String>(Collections.singletonList(facet.getModule().getName())));
        for (Map.Entry<AndroidFacet, String> entry : additionalFacet2PackageName.entrySet()) {
            String moduleName = entry.getKey().getModule().getName();
            String packageName = entry.getValue();
            ArrayList<String> list2 = (ArrayList<String>)packageName2ModuleNames.get(packageName);
            if (list2 == null) {
                list2 = new ArrayList<String>();
                packageName2ModuleNames.put(packageName, list2);
            }
            list2.add(moduleName);
        }
        StringBuilder messageBuilder = new StringBuilder("Applications have the same package name ");
        boolean fail = false;
        for (Map.Entry entry : packageName2ModuleNames.entrySet()) {
            String packageName = (String)entry.getKey();
            List moduleNames = (List)entry.getValue();
            if (moduleNames.size() <= 1) continue;
            fail = true;
            messageBuilder.append(packageName).append(":\n    ");
            Iterator it = moduleNames.iterator();
            while (it.hasNext()) {
                String moduleName = (String)it.next();
                messageBuilder.append(moduleName);
                if (!it.hasNext()) continue;
                messageBuilder.append(", ");
            }
            messageBuilder.append("\n");
        }
        if (fail) {
            throw new ApkProvisionException(messageBuilder.toString());
        }
    }
}

