/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.VariantBuildOutput;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.BaselineProfileDetails;
import com.android.ide.common.build.GenericBuiltArtifact;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsLoader;
import com.android.ide.common.build.GenericBuiltArtifactsSplitOutputMatcher;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.gradle.model.IdeAndroidArtifactCore;
import com.android.tools.idea.gradle.model.IdeAndroidArtifactOutput;
import com.android.tools.idea.gradle.model.IdeAndroidProjectType;
import com.android.tools.idea.gradle.model.IdeArtifactName;
import com.android.tools.idea.gradle.model.IdeBasicVariant;
import com.android.tools.idea.gradle.model.IdeTestedTargetVariant;
import com.android.tools.idea.gradle.model.IdeVariantCore;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.sync.ModelCache;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.BuildOutputUtil;
import com.android.tools.idea.gradle.util.OutputType;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleHolderProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.SplitOutputMatcher;
import com.android.tools.idea.run.UnsignedApkQuickFix;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.DynamicAppUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final GradleApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;
    private final boolean myTest;
    private final boolean myAlwaysDeployApkFromBundle;
    public static final Key<PostBuildModel> POST_BUILD_MODEL = Key.create((String)"com.android.tools.idea.post_build_model");

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull GradleApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test, boolean alwaysDeployApkFromBundle) {
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myOutputModelProvider = outputModelProvider;
        this.myTest = test;
        this.myAlwaysDeployApkFromBundle = alwaysDeployApkFromBundle;
    }

    private static OutputKind getOutputKind(@NotNull Module module, boolean alwaysDeployApkFromBundle, boolean isTest, @Nullable AndroidVersion targetDevicesMinVersion) {
        if (DynamicAppUtils.useSelectApksFromBundleBuilder(module, alwaysDeployApkFromBundle, isTest, targetDevicesMinVersion)) {
            return OutputKind.AppBundleOutputModel;
        }
        return OutputKind.Default;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device2) throws ApkProvisionException {
        GradleAndroidModel androidModel = GradleAndroidModel.get(this.myFacet);
        if (androidModel == null) {
            GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
            return Collections.emptyList();
        }
        boolean deviceSupportsPrivacySandbox = GradleApkProvider.deviceSupportsPrivacySandbox(device2);
        return this.getApks(device2.getAbis(), device2.getVersion(), deviceSupportsPrivacySandbox, androidModel, androidModel.getSelectedVariant(), GradleApkProvider.getOutputKind(this.myFacet.getModule(), this.myAlwaysDeployApkFromBundle, this.myTest, device2.getVersion()));
    }

    private static boolean deviceSupportsPrivacySandbox(@NotNull IDevice device2) {
        return device2.getVersion().isAtLeast(34) && device2.services().containsKey("sdk_sandbox");
    }

    @NotNull
    public List<ApkInfo> getApks(@NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, boolean deviceSupportsPrivacySandbox, @NotNull GradleAndroidModel androidModel, @NotNull IdeVariantCore variant, @NotNull OutputKind outputKind) throws ApkProvisionException {
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        IdeAndroidProjectType projectType = androidModel.getAndroidProject().getProjectType();
        Logger logger = GradleApkProvider.getLogger();
        if (projectType == IdeAndroidProjectType.PROJECT_TYPE_APP || projectType == IdeAndroidProjectType.PROJECT_TYPE_INSTANTAPP || projectType == IdeAndroidProjectType.PROJECT_TYPE_TEST || projectType == IdeAndroidProjectType.PROJECT_TYPE_DYNAMIC_FEATURE) {
            String pkgName;
            String string = pkgName = projectType == IdeAndroidProjectType.PROJECT_TYPE_TEST ? this.myApplicationIdProvider.getTestPackageName() : this.myApplicationIdProvider.getPackageName();
            if (pkgName == null) {
                logger.warn("Package name is null. Sync might have failed");
                return Collections.emptyList();
            }
            switch (outputKind.ordinal()) {
                case 0: {
                    ArrayList<ApkFileUnit> apkFileList = new ArrayList<ApkFileUnit>();
                    apkFileList.add(new ApkFileUnit(androidModel.getModuleName(), this.getApk(variant.getName(), variant.getMainArtifact(), deviceAbis, deviceVersion, this.myFacet)));
                    apkFileList.addAll(this.collectDependentFeaturesApks(androidModel, deviceAbis, deviceVersion));
                    if (variant.getMainArtifact().getPrivacySandboxSdkInfo() != null) {
                        if (deviceSupportsPrivacySandbox) {
                            apkList.addAll(this.getApksForPrivacySandboxSdks(variant.getName(), variant.getMainArtifact().getPrivacySandboxSdkInfo().getOutputListingFile(), variant.getMainArtifact().getAbiFilters(), deviceAbis));
                            apkFileList.addAll(GradleApkProvider.getSplitApksForPrivacySandbox(androidModel.getModuleName(), variant.getMainArtifact().getPrivacySandboxSdkInfo().getAdditionalApkSplitFile()));
                        } else {
                            apkFileList.addAll(GradleApkProvider.getSplitApksForPrivacySandbox(androidModel.getModuleName(), variant.getMainArtifact().getPrivacySandboxSdkInfo().getOutputListingLegacyFile()));
                        }
                    }
                    @Nullable GenericBuiltArtifacts builtArtifacts = this.getGenericBuiltArtifacts(variant.getMainArtifact(), this.myFacet);
                    apkList.add(new ApkInfo(apkFileList, pkgName, this.getBaselineProfiles(builtArtifacts), this.getMinSdkVersionForDexing(builtArtifacts)));
                    break;
                }
                case 1: {
                    ApkInfo apkInfo;
                    Module baseAppModule = this.myFacet.getModule();
                    if (projectType == IdeAndroidProjectType.PROJECT_TYPE_DYNAMIC_FEATURE) {
                        baseAppModule = DynamicAppUtils.getBaseFeature(this.myFacet.getModule());
                    }
                    if (baseAppModule == null) break;
                    GradleAndroidModel baseAndroidModel = GradleAndroidModel.get(baseAppModule);
                    if (baseAndroidModel == null) {
                        GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
                        break;
                    }
                    IdeVariantCore baseVariant = baseAndroidModel.getSelectedVariant();
                    if (deviceSupportsPrivacySandbox && baseVariant.getMainArtifact().getPrivacySandboxSdkInfo() != null) {
                        apkList.addAll(this.getApksForPrivacySandboxSdks(baseVariant.getName(), baseVariant.getMainArtifact().getPrivacySandboxSdkInfo().getOutputListingFile(), baseVariant.getMainArtifact().getAbiFilters(), deviceAbis));
                    }
                    if ((apkInfo = GradleApkProvider.collectAppBundleOutput(baseAndroidModel, baseAppModule, this.myOutputModelProvider, pkgName)) == null) break;
                    apkList.add(apkInfo);
                }
            }
        }
        apkList.addAll(GradleApkProvider.getAdditionalApks(variant.getMainArtifact()));
        if (this.myTest) {
            if (projectType == IdeAndroidProjectType.PROJECT_TYPE_TEST) {
                apkList.addAll(0, this.getTargetedApks(variant, deviceAbis, deviceVersion));
            } else {
                IdeAndroidArtifactCore testArtifactInfo = androidModel.getSelectedVariant().getDeviceTestArtifacts().stream().filter(it -> it.getName() == IdeArtifactName.ANDROID_TEST).findFirst().orElse(null);
                if (testArtifactInfo != null) {
                    @NotNull IdeAndroidArtifactCore artifact = GradleApkProvider.getAndroidTestArtifact(androidModel.getSelectedVariant());
                    File testApk = this.getApk(androidModel.getSelectedVariant().getName(), artifact, deviceAbis, deviceVersion, this.myFacet);
                    String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                    assert (testPackageName != null);
                    @Nullable GenericBuiltArtifacts builtArtifacts = this.getGenericBuiltArtifacts(artifact, this.myFacet);
                    apkList.add(new ApkInfo(testApk, testPackageName, this.getMinSdkVersionForDexing(builtArtifacts)));
                    apkList.addAll(GradleApkProvider.getAdditionalApks(testArtifactInfo));
                }
            }
        }
        logger.info(String.format("APKs for %s:", this.myFacet.getModule()));
        for (ApkInfo info : apkList) {
            logger.info(String.format("  %s =>", info.getApplicationId()));
            for (ApkFileUnit file : info.getFiles()) {
                logger.info(String.format("    apk from %s : %s", file.getModuleName(), file.getApkFile()));
            }
            for (BaselineProfileDetails bps : info.getBaselineProfiles()) {
                logger.info("    baseline prof: api [" + bps.getMinApi() + "," + bps.getMaxApi() + "]");
                for (File f : bps.getBaselineProfileFiles()) {
                    logger.info("        md : '" + f.getName() + "'");
                }
            }
        }
        return apkList;
    }

    @NotNull
    private List<BaselineProfileDetails> getBaselineProfiles(GenericBuiltArtifacts builtArtifacts) {
        if (builtArtifacts == null) {
            return Collections.emptyList();
        }
        List bp = builtArtifacts.getBaselineProfiles();
        if (bp == null) {
            return Collections.emptyList();
        }
        return bp;
    }

    @Nullable
    private Integer getMinSdkVersionForDexing(GenericBuiltArtifacts builtArtifacts) {
        if (builtArtifacts == null) {
            return null;
        }
        return builtArtifacts.getMinSdkVersionForDexing();
    }

    @Nullable
    private GenericBuiltArtifacts getGenericBuiltArtifacts(IdeAndroidArtifactCore artifact, AndroidFacet facet) {
        GradleAndroidModel androidModel = GradleAndroidModel.get(facet);
        if (androidModel == null) {
            return null;
        }
        if (!androidModel.getFeatures().isBuildOutputFileSupported()) {
            return null;
        }
        String outputFile = BuildOutputUtil.getOutputListingFile(artifact.getBuildInformation(), OutputType.Apk);
        if (outputFile == null) {
            return null;
        }
        return GenericBuiltArtifactsLoader.loadFromFile((File)new File(outputFile), (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
    }

    @NotNull
    private List<ApkFileUnit> collectDependentFeaturesApks(@NotNull GradleAndroidModel androidModel, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) {
        return ProjectSystemUtil.getModuleSystem(this.myFacet).getDynamicFeatureModules().stream().map(module -> {
            AndroidFacet featureFacet = AndroidFacet.getInstance((Module)module);
            if (featureFacet == null) {
                return null;
            }
            GradleAndroidModel androidFeatureModel = GradleAndroidModel.get(featureFacet);
            if (androidFeatureModel == null) {
                return null;
            }
            IdeVariantCore selectedVariant = androidFeatureModel.getSelectedVariant();
            try {
                File apk = this.getApk(selectedVariant.getName(), selectedVariant.getMainArtifact(), deviceAbis, deviceVersion, featureFacet);
                return new ApkFileUnit(androidFeatureModel.getModuleName(), apk);
            }
            catch (ApkProvisionException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private static List<ApkInfo> getAdditionalApks(@NotNull IdeAndroidArtifactCore testArtifactInfo) {
        ArrayList<ApkInfo> result2 = new ArrayList<ApkInfo>();
        for (File fileApk : testArtifactInfo.getAdditionalRuntimeApks()) {
            try {
                String packageId = GradleApkProvider.getPackageId(fileApk);
                result2.add(new ApkInfo(fileApk, packageId, (Set<? extends ApkInfo.AppInstallOption>)ImmutableSet.of((Object)((Object)ApkInfo.AppInstallOption.FORCE_QUERYABLE), (Object)((Object)ApkInfo.AppInstallOption.GRANT_ALL_PERMISSIONS))));
            }
            catch (ApkProvisionException e) {
                GradleApkProvider.getLogger().error("Failed to get the package name from the given file. Therefore, we are not be able to install it. Please install it manually: " + fileApk.getName() + " error: " + e.getMessage(), (Throwable)e);
            }
        }
        return result2;
    }

    private static Path getPathToAapt() {
        AndroidSdkHandler handler2 = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return AaptInvoker.getPathToAapt((AndroidSdkHandler)handler2, (ILogger)new LogWrapper(GradleApkProvider.class));
    }

    private static String getPackageId(@NotNull File fileApk) throws ApkProvisionException {
        String string;
        block9: {
            ArchiveContext archiveContext = Archives.open((Path)fileApk.toPath());
            try {
                AndroidApplicationInfo applicationInfo = ApkParser.getAppInfo(GradleApkProvider.getPathToAapt(), archiveContext.getArchive());
                if (applicationInfo == AndroidApplicationInfo.UNKNOWN) {
                    throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName());
                }
                string = applicationInfo.packageId;
                if (archiveContext == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (archiveContext != null) {
                        try {
                            archiveContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName(), e.getCause());
                }
            }
            archiveContext.close();
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    File getApk(@NotNull String variantName, @NotNull IdeAndroidArtifactCore artifact, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet) throws ApkProvisionException {
        GradleAndroidModel androidModel = GradleAndroidModel.get(facet);
        assert (androidModel != null);
        if (androidModel.getFeatures().isBuildOutputFileSupported()) {
            return this.getApkFromBuildOutputFile(variantName, artifact, deviceAbis);
        }
        if (androidModel.getFeatures().isPostBuildSyncSupported()) {
            return this.getApkFromPostBuildSync(variantName, artifact, deviceAbis, deviceVersion, facet);
        }
        throw new IllegalStateException("AGP 3.1.0 and later support either post build models or build output listing files. However, neither is available.");
    }

    @NotNull
    private File getApkFromBuildOutputFile(@NotNull String variantName, @NotNull IdeAndroidArtifactCore artifact, @NotNull List<String> deviceAbis) throws ApkProvisionException {
        String outputFile = BuildOutputUtil.getOutputListingFile(artifact.getBuildInformation(), OutputType.Apk);
        if (outputFile == null) {
            throw new ApkProvisionException("Cannot get output listing file name from the build model");
        }
        GenericBuiltArtifacts builtArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)new File(outputFile), (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
        if (builtArtifacts == null) {
            throw new ApkProvisionException(String.format("Error loading build artifacts from: %s", outputFile));
        }
        return GradleApkProvider.findBestOutput(variantName, (Set<String>)artifact.getAbiFilters(), deviceAbis, builtArtifacts);
    }

    @NotNull
    List<ApkInfo> getApksForPrivacySandboxSdks(@NotNull String variantName, @NotNull File outputListingFile, @NotNull Set<String> abiFilters, @NotNull List<String> deviceAbis) throws ApkProvisionException {
        List builtArtifacts = GenericBuiltArtifactsLoader.loadListFromFile((File)outputListingFile, (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
        ArrayList<ApkInfo> list2 = new ArrayList<ApkInfo>();
        for (GenericBuiltArtifacts builtArtifact : builtArtifacts) {
            ApkInfo unit = new ApkInfo(GradleApkProvider.findBestOutput(variantName, abiFilters, deviceAbis, builtArtifact), builtArtifact.getApplicationId(), (Set<? extends ApkInfo.AppInstallOption>)ImmutableSet.of(), true);
            list2.add(unit);
        }
        return list2;
    }

    @NotNull
    static List<ApkFileUnit> getSplitApksForPrivacySandbox(@NotNull String moduleName, @NotNull File builtArtifactMetadataFile) {
        List builtArtifacts = GenericBuiltArtifactsLoader.loadListFromFile((File)builtArtifactMetadataFile, (ILogger)new LogWrapper(GradleApkProvider.getLogger()));
        ArrayList<ApkFileUnit> list2 = new ArrayList<ApkFileUnit>();
        for (GenericBuiltArtifacts builtArtifact : builtArtifacts) {
            for (GenericBuiltArtifact element : builtArtifact.getElements()) {
                list2.add(new ApkFileUnit(moduleName, new File(element.getOutputFile())));
            }
        }
        return list2;
    }

    @NotNull
    public static IdeAndroidArtifactCore getAndroidTestArtifact(@NotNull IdeVariantCore variant) throws ApkProvisionException {
        IdeAndroidArtifactCore androidTestArtifact = variant.getDeviceTestArtifacts().stream().filter(it -> it.getName() == IdeArtifactName.ANDROID_TEST).findFirst().orElse(null);
        if (androidTestArtifact == null) {
            throw new ApkProvisionException(String.format("AndroidTest artifact is not configured in %s variant.", variant.getDisplayName()));
        }
        return androidTestArtifact;
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPostBuildSync(@NotNull String variantName, @NotNull IdeAndroidArtifactCore artifact, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion, @NotNull AndroidFacet facet) throws ApkProvisionException {
        ArrayList<IdeAndroidArtifactOutput> outputs = new ArrayList<IdeAndroidArtifactOutput>();
        PostBuildModel outputModels = this.myOutputModelProvider.getPostBuildModel();
        if (outputModels == null) {
            throw new ApkProvisionException(String.format("Couldn't get post build model. Module: %s Variant: %s", facet.getModule().getName(), variantName));
        }
        ModelCache.V1 modelCache = ModelCache.createForPostBuildModels();
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4) {
            outputModel = outputModels.findInstantAppProjectBuildOutput(GradleApkProvider.getGradlePathAsStringForPostBuildModels(facet.getModule()));
            if (outputModel == null) {
                throw new ApkProvisionException("Couldn't get post build model for Instant Apps. Please, make sure to use plugin 3.0.0-alpha10 or later.");
            }
            for (InstantAppVariantBuildOutput instantAppVariantBuildOutput : outputModel.getInstantAppVariantsBuildOutput()) {
                if (!instantAppVariantBuildOutput.getName().equals(variantName)) continue;
                outputs.add((IdeAndroidArtifactOutput)modelCache.androidArtifactOutputFrom(instantAppVariantBuildOutput.getOutput()));
            }
        } else {
            outputModel = outputModels.findProjectBuildOutput(GradleApkProvider.getGradlePathAsStringForPostBuildModels(facet.getModule()));
            if (outputModel == null) {
                throw new ApkProvisionException(String.format("Couldn't get post build model. Module: %s Variant: %s", facet.getModule().getName(), variantName));
            }
            for (VariantBuildOutput variantBuildOutput : outputModel.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(variantName)) continue;
                if (artifact.isTestArtifact()) {
                    for (TestVariantBuildOutput testVariantBuildOutput : variantBuildOutput.getTestingVariants()) {
                        if (!testVariantBuildOutput.getType().equals(TestVariantBuildOutput.ANDROID_TEST)) continue;
                        if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 6 && deviceVersion.compareTo(AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION) < 0) {
                            throw new ApkProvisionException("Running Instrumented Tests for Dynamic Features is currently not supported on API < 21.");
                        }
                        outputs.addAll(ContainerUtil.map((Collection)testVariantBuildOutput.getOutputs(), arg_0 -> ((ModelCache.V1)modelCache).androidArtifactOutputFrom(arg_0)));
                    }
                    continue;
                }
                outputs.addAll(ContainerUtil.map((Collection)variantBuildOutput.getOutputs(), arg_0 -> ((ModelCache.V1)modelCache).androidArtifactOutputFrom(arg_0)));
            }
        }
        Set abiFilters = artifact.getAbiFilters();
        return GradleApkProvider.findBestOutput(variantName, (Set<String>)abiFilters, deviceAbis, outputs);
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull IdeVariantCore selectedVariant, @NotNull List<String> deviceAbis, @NotNull AndroidVersion deviceVersion) throws ApkProvisionException {
        ArrayList<ApkInfo> targetedApks = new ArrayList<ApkInfo>();
        for (IdeTestedTargetVariant testedVariant : selectedVariant.getTestedTargetVariants()) {
            String targetGradlePath = testedVariant.getTargetProjectPath();
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> {
                Project project = this.myFacet.getModule().getProject();
                GradleProjectPath projectPath = GradleProjectPathKt.getGradleProjectPath(LinkedAndroidModuleGroupUtilsKt.getHolderModule(this.myFacet.getModule()));
                if (projectPath == null) {
                    return null;
                }
                GradleHolderProjectPath targetProjectPath = new GradleHolderProjectPath(projectPath.getBuildRoot(), targetGradlePath);
                return GradleProjectPathKt.resolveIn(targetProjectPath, project);
            });
            if (targetModule == null) {
                GradleApkProvider.getLogger().warn(String.format("Module not found for gradle path %s. Please install tested apk manually.", targetGradlePath));
                continue;
            }
            AndroidFacet targetFacet = AndroidFacet.getInstance((Module)targetModule);
            if (targetFacet == null) {
                GradleApkProvider.getLogger().warn("Android facet for tested module is null. Please install tested apk manually.");
                continue;
            }
            GradleAndroidModel targetAndroidModel = GradleAndroidModel.get(targetModule);
            if (targetAndroidModel == null) {
                GradleApkProvider.getLogger().warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            IdeVariantCore targetVariant = targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            IdeBasicVariant targetBasicVariant = targetAndroidModel.findBasicVariantByName(testedVariant.getTargetVariant());
            if (targetBasicVariant == null) {
                GradleApkProvider.getLogger().warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = this.getApk(targetVariant.getName(), targetVariant.getMainArtifact(), deviceAbis, deviceVersion, targetFacet);
            String applicationId2 = GradleApplicationIdProvider.createForBaseModule(targetFacet, targetAndroidModel, targetBasicVariant).getPackageName();
            targetedApks.add(new ApkInfo(targetApk, applicationId2));
        }
        return targetedApks;
    }

    @NotNull
    public static ImmutableList<ValidationError> doValidate(@NotNull AndroidFacet androidFacet, boolean isTest, boolean alwaysDeployApkFromBundle, @Nullable Runnable quickFixCallback) {
        IdeAndroidArtifactCore testArtifact;
        ImmutableList.Builder result2 = ImmutableList.builder();
        GradleAndroidModel gradleAndroidModel = GradleAndroidModel.get(androidFacet);
        if (gradleAndroidModel == null) {
            ConfigurationQuickFix requestProjectSync = dataContext -> ProjectSystemUtil.getSyncManager(androidFacet.getModule().getProject()).requestSyncProject(ProjectSystemSyncManager.SyncReason.USER_REQUEST);
            result2.add((Object)ValidationError.fatal("The project has not yet been synced with Gradle configuration", requestProjectSync));
            return result2.build();
        }
        if (alwaysDeployApkFromBundle && StringUtil.isEmpty((String)gradleAndroidModel.getSelectedVariant().getMainArtifact().getBuildInformation().getBundleTaskName())) {
            ValidationError error = ValidationError.fatal("Bundle task not supported for module '" + androidFacet.getModule().getName() + "'");
            result2.add((Object)error);
        }
        if (isTest && (testArtifact = gradleAndroidModel.getArtifactCoreForAndroidTest()) == null) {
            IdeVariantCore selectedVariant = gradleAndroidModel.getSelectedVariant();
            result2.add((Object)ValidationError.warning("Active build variant \"" + selectedVariant.getName() + "\" does not have a test artifact."));
        }
        AndroidVersion targetDevicesMinVersion = null;
        Module module = androidFacet.getModule();
        if (gradleAndroidModel.getAndroidProject().getProjectType() == IdeAndroidProjectType.PROJECT_TYPE_INSTANTAPP || GradleApkProvider.getOutputKind(module, alwaysDeployApkFromBundle, isTest, targetDevicesMinVersion) == OutputKind.AppBundleOutputModel || GradleApkProvider.isArtifactSigned(gradleAndroidModel, isTest)) {
            return result2.build();
        }
        String message = AndroidBundle.message("run.error.apk.not.signed", gradleAndroidModel.getSelectedVariant().getDisplayName());
        UnsignedApkQuickFix quickfix = UnsignedApkQuickFix.create(module, gradleAndroidModel.getSelectedVariant().getBuildType(), quickFixCallback);
        result2.add((Object)ValidationError.fatal(message, quickfix));
        return result2.build();
    }

    @Nullable
    private static ApkInfo collectAppBundleOutput(@NotNull GradleAndroidModel androidModel, @NotNull Module module, @NotNull PostBuildModelProvider outputModelProvider, @NotNull String pkgName) {
        String outputListingFile;
        List<File> apkFiles = androidModel.getFeatures().isBuildOutputFileSupported() ? ((outputListingFile = BuildOutputUtil.getOutputListingFile(androidModel.getSelectedVariant().getMainArtifact().getBuildInformation(), OutputType.ApkFromBundle)) != null ? BuildOutputUtil.getOutputFilesFromListingFile(outputListingFile) : Collections.emptyList()) : GradleApkProvider.collectApkFilesFromPostBuildModel(outputModelProvider, GradleApkProvider.getGradlePathAsStringForPostBuildModels(module), androidModel.getSelectedVariant().getName());
        if (apkFiles.isEmpty()) {
            GradleApkProvider.getLogger().warn("Could not find apk files.");
            return null;
        }
        List apks = apkFiles.stream().map(path -> new ApkFileUnit(GradleApkProvider.getFeatureNameFromPathHack(path.toPath()), (File)path)).collect(Collectors.toList());
        return new ApkInfo(apks, pkgName);
    }

    @NotNull
    private static List<File> collectApkFilesFromPostBuildModel(@NotNull PostBuildModelProvider outputModelProvider, @Nullable String gradlePath, @Nullable String variantName) {
        PostBuildModel model = outputModelProvider.getPostBuildModel();
        if (model == null) {
            GradleApkProvider.getLogger().warn("Post build model is null. Build might have failed.");
            return Collections.emptyList();
        }
        AppBundleProjectBuildOutput output = model.findAppBundleProjectBuildOutput(gradlePath);
        if (output == null) {
            GradleApkProvider.getLogger().warn("Project output is null. Build may have failed.");
            return Collections.emptyList();
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : output.getAppBundleVariantsBuildOutput()) {
            List<File> list2;
            block11: {
                if (!variantBuildOutput.getName().equals(variantName)) continue;
                Stream<Path> stream = Files.list(variantBuildOutput.getApkFolder().toPath());
                try {
                    list2 = stream.map(Path::toFile).collect(Collectors.toList());
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        GradleApkProvider.getLogger().warn(String.format("Error reading list of APK files from bundle build output directory \"%s\".", variantBuildOutput.getApkFolder()), (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                stream.close();
            }
            return list2;
        }
        GradleApkProvider.getLogger().warn("Bundle variant build output model has no entries. Build may have failed.");
        return Collections.emptyList();
    }

    @NotNull
    private static String getFeatureNameFromPathHack(@NotNull Path path) {
        String fileName = path.getFileName().toString();
        int separatorIndex = fileName.lastIndexOf(45);
        if (separatorIndex < 0) {
            return "";
        }
        return fileName.substring(0, separatorIndex);
    }

    private static boolean isArtifactSigned(GradleAndroidModel gradleAndroidModel, boolean isTest) {
        IdeAndroidArtifactCore artifact = isTest ? gradleAndroidModel.getArtifactCoreForAndroidTest() : gradleAndroidModel.getSelectedVariant().getMainArtifact();
        return artifact != null && artifact.isSigned();
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleApkProvider.class);
    }

    @NotNull
    static File findBestOutput(@NotNull String variantName, @NotNull Set<String> artifactAbiFilters, @NotNull List<String> abis, @NotNull List<IdeAndroidArtifactOutput> outputs) throws ApkProvisionException {
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variantName);
        }
        List apkFiles = ContainerUtil.map(SplitOutputMatcher.computeBestOutput(outputs, artifactAbiFilters, abis), IdeAndroidArtifactOutput::getOutputFile);
        GradleApkProvider.verifyApkCollectionIsNotEmpty(variantName, apkFiles, abis, outputs.size());
        return (File)apkFiles.get(0);
    }

    @NotNull
    static File findBestOutput(@NotNull String variantName, @NotNull Set<String> artifactAbiFilters, @NotNull List<String> abis, @NotNull GenericBuiltArtifacts builtArtifact) throws ApkProvisionException {
        List apkFiles = GenericBuiltArtifactsSplitOutputMatcher.INSTANCE.computeBestOutput(builtArtifact, artifactAbiFilters, abis);
        GradleApkProvider.verifyApkCollectionIsNotEmpty(variantName, apkFiles, abis, builtArtifact.getElements().size());
        return (File)apkFiles.get(0);
    }

    private static void verifyApkCollectionIsNotEmpty(@NotNull String variantName, @NotNull List<File> apkFiles, @NotNull List<String> abis, int outputCount) throws ApkProvisionException {
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variantName, outputCount, Joiner.on((String)", ").join(abis));
            throw new ApkProvisionException(message);
        }
    }

    @Nullable
    private static String getGradlePathAsStringForPostBuildModels(@NotNull Module module) {
        GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(module);
        return gradleProjectPath != null ? gradleProjectPath.getPath() : null;
    }

    public static enum OutputKind {
        Default,
        AppBundleOutputModel;

    }
}

