/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.deployer.DeploymentCacheDatabase;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.tasks.TaskRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DeploymentService {
    private final TaskRunner runner;
    private final NotNullLazyValue<SqlApkFileDatabase> dexDatabase;
    private final NotNullLazyValue<DeploymentCacheDatabase> deploymentCacheDatabase;

    private DeploymentService() {
        ExecutorService service = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Deployment Service", (int)5);
        this.runner = new TaskRunner(service);
        Path dexDbPath = Paths.get(PathManager.getSystemPath(), ".dex_cache.db");
        Path deployDbPath = Paths.get(PathManager.getSystemPath(), ".deploy_cache.db");
        this.dexDatabase = NotNullLazyValue.createValue(() -> new SqlApkFileDatabase(dexDbPath.toFile(), PathManager.getTempPath()));
        this.deploymentCacheDatabase = NotNullLazyValue.createValue(() -> new DeploymentCacheDatabase(deployDbPath.toFile()));
    }

    @NotNull
    public static DeploymentService getInstance() {
        return (DeploymentService)ApplicationManager.getApplication().getService(DeploymentService.class);
    }

    public TaskRunner getTaskRunner() {
        return this.runner;
    }

    public SqlApkFileDatabase getDexDatabase() {
        return (SqlApkFileDatabase)this.dexDatabase.getValue();
    }

    public DeploymentCacheDatabase getDeploymentCacheDatabase() {
        return (DeploymentCacheDatabase)this.deploymentCacheDatabase.getValue();
    }
}

