/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public interface MigrationClassGenerator<T extends PsiElement> {
    public static final String SUPER_CLASS_NAME = "androidx.room.migration.Migration";
    public static final String MIGRATION_METHOD_NAME = "migrate";
    public static final String MIGRATION_METHOD_PARAMETER_NAME = "database";
    public static final String MIGRATION_METHOD_PARAMETER_TYPE = "androidx.sqlite.db.SupportSQLiteDatabase";

    public T createMigrationClass(@NotNull PsiPackage var1, @NotNull PsiDirectory var2, @NotNull DatabaseUpdate var3);

    public static String getMigrationClassName(int migrationStartVersion, int migrationEndVersion) {
        return String.format(Locale.US, "Migration_%d_%d", migrationStartVersion, migrationEndVersion);
    }

    public static String trimSqlStatement(String sqlStatement) {
        return sqlStatement.replace("(\n", "(").replace("\n)", ")").replace("\n", " ").replace("\t", "");
    }
}

