/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J\u0016\u0010\u000b\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J\u001a\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/ResourceFolderVfsListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "registry", "Lcom/android/tools/idea/res/ResourceFolderRegistry;", "<init>", "(Lcom/android/tools/idea/res/ResourceFolderRegistry;)V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "onFileOrDirectoryCreated", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "childName", "", "onFileOrDirectoryRemoved", "file", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceFolderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFolderRegistry.kt\ncom/android/tools/idea/res/ResourceFolderVfsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n1#2:415\n*E\n"})
final class ResourceFolderVfsListener
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceFolderRegistry registry;

    public ResourceFolderVfsListener(@NotNull ResourceFolderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
    }

    @RequiresWriteLock
    public void before(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileMoveEvent) {
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.onFileOrDirectoryRemoved(virtualFile);
                continue;
            }
            if (vFileEvent2 instanceof VFileDeleteEvent) {
                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.onFileOrDirectoryRemoved(virtualFile);
                continue;
            }
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
            VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this.onFileOrDirectoryRemoved(virtualFile);
        }
    }

    @RequiresWriteLock
    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            VirtualFile it;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileCreateEvent) {
                VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getParent();
                String string = ((VFileCreateEvent)vFileEvent).getChildName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                this.onFileOrDirectoryCreated(virtualFile, string);
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                VirtualFile virtualFile = ((VFileCopyEvent)vFileEvent).getNewParent();
                String string = ((VFileCopyEvent)vFileEvent).getNewChildName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewChildName(...)");
                this.onFileOrDirectoryCreated(virtualFile, string);
                continue;
            }
            if (vFileEvent2 instanceof VFileMoveEvent) {
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getNewParent();
                String string = ((VFileMoveEvent)vFileEvent).getFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.onFileOrDirectoryCreated(virtualFile, string);
                continue;
            }
            if (!(vFileEvent2 instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
            if (((VFilePropertyChangeEvent)vFileEvent).getFile().getParent() == null) continue;
            boolean bl = false;
            Object object = ((VFilePropertyChangeEvent)vFileEvent).getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.onFileOrDirectoryCreated(it, (String)object);
        }
    }

    private final void onFileOrDirectoryCreated(VirtualFile parent, String childName) {
        VirtualFile virtualFile;
        Object object;
        block7: {
            block6: {
                VirtualFile virtualFile2;
                ResourceUpdateTracer.Companion.log((Function0<String>)((Function0)() -> ResourceFolderVfsListener.onFileOrDirectoryCreated$lambda$0(parent, childName, this)));
                object = parent;
                if (object == null) break block6;
                VirtualFile p0 = virtualFile2 = object;
                boolean bl = false;
                object = p0.exists() ? virtualFile2 : null;
                if (object != null && (object = object.findChild(childName)) != null) break block7;
            }
            return;
        }
        VirtualFile created = object;
        if (created.isDirectory()) {
            virtualFile = parent;
        } else {
            virtualFile = parent.getParent();
            if (virtualFile == null) {
                return;
            }
        }
        VirtualFile resDir = virtualFile;
        this.registry.dispatchToRepositories(resDir, (arg_0, arg_1) -> ResourceFolderVfsListener.onFileOrDirectoryCreated$lambda$1(created, arg_0, arg_1));
    }

    private final void onFileOrDirectoryRemoved(VirtualFile file) {
        this.registry.dispatchToRepositories(file, ResourceFolderVfsListener::onFileOrDirectoryRemoved$lambda$0);
    }

    private static final String onFileOrDirectoryCreated$lambda$0(VirtualFile $parent, String $childName, ResourceFolderVfsListener this$0) {
        String pathToLog = $parent == null ? $childName : ResourceUpdateTracer.Companion.getInstance().pathForLogging(FileExtensions.toPathString($parent).resolve($childName), this$0.registry.getProject());
        return "ResourceFolderVfsListener.onFileOrDirectoryCreated(" + pathToLog + ")";
    }

    private static final void onFileOrDirectoryCreated$lambda$1(VirtualFile $created, ResourceFolderRepository repo, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        ResourceFolderVfsListener.Companion.onFileOrDirectoryCreated($created, repo);
    }

    private static final void onFileOrDirectoryRemoved$lambda$0(ResourceFolderRepository repo, VirtualFile f) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        repo.onFileOrDirectoryRemoved(f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/res/ResourceFolderVfsListener$Companion;", "", "<init>", "()V", "onFileOrDirectoryCreated", "", "created", "Lcom/intellij/openapi/vfs/VirtualFile;", "repository", "Lcom/android/tools/idea/res/ResourceFolderRepository;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void onFileOrDirectoryCreated(VirtualFile created, ResourceFolderRepository repository2) {
            if (repository2 == null) {
                return;
            }
            ResourceUpdateTracer.Companion.log((Function0<String>)((Function0)() -> Companion.onFileOrDirectoryCreated$lambda$0(created, repository2)));
            if (!created.isDirectory()) {
                repository2.onFileCreated(created);
            } else {
                VirtualFile[] virtualFileArray = created.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                for (VirtualFile child : virtualFileArray) {
                    if (child.isDirectory()) continue;
                    repository2.onFileCreated(child);
                }
            }
        }

        private static final String onFileOrDirectoryCreated$lambda$0(VirtualFile $created, ResourceFolderRepository $repository) {
            return "ResourceFolderVfsListener.onFileOrDirectoryCreated(" + $created + ", " + $repository.getDisplayName() + ")";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

