/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.FileRelevanceKt;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/res/ResourceFolderDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "registry", "Lcom/android/tools/idea/res/ResourceFolderRegistry;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/res/ResourceFolderRegistry;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "runInWriteAction", "runnable", "Ljava/lang/Runnable;", "intellij.android.core"})
final class ResourceFolderDocumentListener
implements DocumentListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ResourceFolderRegistry registry;

    public ResourceFolderDocumentListener(@NotNull Project project, @NotNull ResourceFolderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.project = project;
        this.registry = registry;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (PsiDocumentManager.getInstance((Project)this.project).getCachedPsiFile(document2) == null) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 instanceof LightVirtualFile || !FileRelevanceKt.isRelevantFile(virtualFile2)) {
                return;
            }
            this.runInWriteAction(() -> ResourceFolderDocumentListener.documentChanged$lambda$0(this, virtualFile2));
        }
    }

    private final void runInWriteAction(Runnable runnable2) {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            runnable2.run();
        } else {
            application.invokeLater(() -> ResourceFolderDocumentListener.runInWriteAction$lambda$0(application, runnable2));
        }
    }

    private static final void documentChanged$lambda$0(ResourceFolderDocumentListener this$0, VirtualFile $virtualFile) {
        this$0.registry.dispatchToRepositories($virtualFile, ResourceFolderDocumentListener::documentChanged$lambda$0$0);
    }

    private static final void documentChanged$lambda$0$0(ResourceFolderRepository repo, VirtualFile f) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        repo.scheduleScan(f);
    }

    private static final void runInWriteAction$lambda$0(Application $application, Runnable $runnable) {
        $application.runWriteAction($runnable);
    }
}

