/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.utils.DataBindingUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/res/ProjectPsiTreeChangeListener;", "Lcom/intellij/psi/PsiTreeChangeListener;", "notice", "Lkotlin/Function2;", "Lcom/android/tools/idea/res/ResourceNotificationManager$Reason;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "isRelevantFile", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "ignoreChildrenChanged", "beforeChildAddition", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "beforeChildRemoval", "beforeChildReplacement", "beforeChildMovement", "beforeChildrenChange", "beforePropertyChange", "childAdded", "childRemoved", "childReplaced", "childMoved", "childrenChanged", "propertyChanged", "getVirtualFile", "isIgnorable", "check", "intellij.android.core"})
final class ProjectPsiTreeChangeListener
implements PsiTreeChangeListener {
    @NotNull
    private final Function2<ResourceNotificationManager.Reason, VirtualFile, Unit> notice;
    @NotNull
    private final Function1<VirtualFile, Boolean> isRelevantFile;
    private boolean ignoreChildrenChanged;

    public ProjectPsiTreeChangeListener(@NotNull Function2<? super ResourceNotificationManager.Reason, ? super VirtualFile, Unit> notice, @NotNull Function1<? super VirtualFile, Boolean> isRelevantFile) {
        Intrinsics.checkNotNullParameter(notice, (String)"notice");
        Intrinsics.checkNotNullParameter(isRelevantFile, (String)"isRelevantFile");
        this.notice = notice;
        this.isRelevantFile = isRelevantFile;
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.ignoreChildrenChanged = false;
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.ignoreChildrenChanged = true;
        if (this.isIgnorable(event)) {
            return;
        }
        VirtualFile file = this.getVirtualFile(event);
        if (!((Boolean)this.isRelevantFile.invoke((Object)file)).booleanValue()) {
            this.notice.invoke((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT, (Object)file);
            return;
        }
        PsiElement child = event.getChild();
        PsiElement parent = event.getParent();
        if (child instanceof XmlAttribute && parent instanceof XmlTag) {
            if (((XmlAttribute)child).getValueElement() == null) {
                return;
            }
        } else if (parent instanceof XmlAttribute && child instanceof XmlAttributeValue) {
            String string = ((XmlAttributeValue)child).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        } else if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() == null) {
            String text2 = ((XmlToken)child).getText();
            Intrinsics.checkNotNull((Object)text2);
            if (StringsKt.startsWith$default((String)text2, (String)"@", (boolean)false, (int)2, null) && !DataBindingUtils.isBindingExpression((String)text2)) {
                if (Intrinsics.areEqual((Object)text2, (Object)"@") || Intrinsics.areEqual((Object)text2, (Object)"@android:")) {
                    return;
                }
                ResourceUrl url = ResourceUrl.parse((String)text2);
                if (url != null) {
                    String string = url.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    if (((CharSequence)string).length() == 0) {
                        return;
                    }
                }
            }
        }
        this.notice.invoke((Object)ResourceNotificationManager.Reason.EDIT, (Object)file);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        VirtualFile file;
        block5: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.ignoreChildrenChanged = true;
                if (this.isIgnorable(event)) {
                    return;
                }
                file = this.getVirtualFile(event);
                if (!((Boolean)this.isRelevantFile.invoke((Object)file)).booleanValue()) {
                    this.notice.invoke((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT, (Object)file);
                    return;
                }
                PsiElement child = event.getChild();
                PsiElement parent = event.getParent();
                if (!(parent instanceof XmlAttribute) || !(child instanceof XmlToken)) break block5;
                XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                if (valueElement == null) break block6;
                String string = valueElement.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!(((CharSequence)string).length() == 0)) break block5;
            }
            return;
        }
        this.notice.invoke((Object)ResourceNotificationManager.Reason.EDIT, (Object)file);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        VirtualFile file;
        block10: {
            PsiElement parent;
            PsiElement child;
            block8: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.ignoreChildrenChanged = true;
                    if (this.isIgnorable(event)) {
                        return;
                    }
                    file = this.getVirtualFile(event);
                    if (!((Boolean)this.isRelevantFile.invoke((Object)file)).booleanValue()) {
                        this.notice.invoke((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT, (Object)file);
                        return;
                    }
                    child = event.getChild();
                    parent = event.getParent();
                    if (!(parent instanceof XmlAttribute) || !(child instanceof XmlToken)) break block8;
                    XmlAttributeValue valueElement = ((XmlAttribute)parent).getValueElement();
                    if (valueElement == null) break block9;
                    String string = valueElement.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    if (!(((CharSequence)string).length() == 0)) break block10;
                }
                return;
            }
            if (parent instanceof XmlAttributeValue && child instanceof XmlToken && event.getOldChild() != null) {
                String newText = ((XmlToken)child).getText();
                String prevText = event.getOldChild().getText();
                Intrinsics.checkNotNull((Object)newText);
                if (StringsKt.startsWith$default((String)newText, (String)"@", (boolean)false, (int)2, null) && !DataBindingUtils.isBindingExpression((String)newText)) {
                    ResourceUrl prevUrl = ResourceUrl.parse((String)prevText);
                    ResourceUrl newUrl = ResourceUrl.parse((String)newText);
                    ResourceUrl resourceUrl = prevUrl;
                    CharSequence charSequence = resourceUrl != null ? resourceUrl.name : null;
                    if (charSequence == null || charSequence.length() == 0) {
                        ResourceUrl resourceUrl2 = newUrl;
                        charSequence = resourceUrl2 != null ? resourceUrl2.name : null;
                        if (charSequence == null || charSequence.length() == 0) {
                            return;
                        }
                    }
                }
            }
        }
        this.notice.invoke((Object)ResourceNotificationManager.Reason.EDIT, (Object)file);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.check(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.ignoreChildrenChanged) {
            return;
        }
        this.check(event);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)"fileName", (Object)event.getPropertyName())) {
            return;
        }
        PsiElement psiElement = event.getElement();
        PsiFile psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
        VirtualFile file = psiFile != null ? psiFile.getVirtualFile() : null;
        this.notice.invoke((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT, (Object)file);
    }

    private final VirtualFile getVirtualFile(PsiTreeChangeEvent event) {
        PsiFile psiFile = event.getFile();
        return psiFile != null ? psiFile.getVirtualFile() : null;
    }

    private final boolean isIgnorable(PsiTreeChangeEvent event) {
        PsiElement child = event.getChild();
        PsiElement parent = event.getParent();
        if (child instanceof PsiErrorElement || parent instanceof XmlComment) {
            return true;
        }
        if ((child instanceof PsiWhiteSpace || child instanceof XmlText || parent instanceof XmlText) && IdeResourcesUtil.getFolderType(event.getFile()) != ResourceFolderType.VALUES) {
            return true;
        }
        PsiFile file = event.getFile();
        return file != null && (file.getParent() == null || !file.getViewProvider().isPhysical());
    }

    private final void check(PsiTreeChangeEvent event) {
        if (this.isIgnorable(event)) {
            return;
        }
        VirtualFile file = this.getVirtualFile(event);
        if (((Boolean)this.isRelevantFile.invoke((Object)file)).booleanValue()) {
            this.notice.invoke((Object)ResourceNotificationManager.Reason.EDIT, (Object)file);
        } else {
            this.notice.invoke((Object)ResourceNotificationManager.Reason.RESOURCE_EDIT, (Object)file);
        }
    }
}

