/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.rtl;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.tools.idea.refactoring.rtl.RtlRefactoringUsageInfo;
import com.android.tools.idea.refactoring.rtl.RtlSupportProperties;
import com.android.tools.idea.refactoring.rtl.RtlSupportUsageViewDescriptor;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RtlSupportProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.refactoring.AddRTLSupportProcessor");
    public static final String RES_V_QUALIFIER = "-v";
    public static final String RES_V17_QUALIFIER = "-v17";
    private final RtlSupportProperties myProperties;
    private final Project myProject;
    public static final int RTL_TARGET_SDK_START = 17;
    private static Map<String, String> ourMapMirroredAttributeName = new ImmutableMap.Builder().put((Object)"paddingLeft", (Object)"paddingStart").put((Object)"paddingRight", (Object)"paddingEnd").put((Object)"layout_marginLeft", (Object)"layout_marginStart").put((Object)"layout_marginRight", (Object)"layout_marginEnd").put((Object)"drawableLeft", (Object)"drawableStart").put((Object)"drawableRight", (Object)"drawableEnd").put((Object)"layout_toLeftOf", (Object)"layout_toStartOf").put((Object)"layout_toRightOf", (Object)"layout_toEndOf").put((Object)"layout_alignLeft", (Object)"layout_alignStart").put((Object)"layout_alignRight", (Object)"layout_alignEnd").put((Object)"layout_alignParentLeft", (Object)"layout_alignParentStart").put((Object)"layout_alignParentRight", (Object)"layout_alignParentEnd").put((Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintEnd_toEndOf").put((Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintEnd_toStartOf").put((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintStart_toStartOf").put((Object)"layout_constraintLeft_toRightOf", (Object)"layout_constraintStart_toEndOf").build();

    protected RtlSupportProcessor(Project project, @NotNull RtlSupportProperties properties) {
        super(project);
        this.myProject = project;
        this.myProperties = properties;
        this.setPreviewUsages(true);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new RtlSupportUsageViewDescriptor();
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (!this.myProperties.hasSomethingToDo()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        ArrayList<UsageInfo> list2 = new ArrayList<UsageInfo>();
        if (this.myProperties.updateAndroidManifest) {
            this.addManifestRefactoring(list2);
        }
        if (this.myProperties.updateLayouts) {
            this.addLayoutRefactoring(list2);
        }
        int size = list2.size();
        return list2.toArray(new UsageInfo[size]);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        block6: for (UsageInfo usageInfo : usages) {
            RtlRefactoringUsageInfo refactoring = (RtlRefactoringUsageInfo)usageInfo;
            switch (refactoring.getType()) {
                case MANIFEST_SUPPORTS_RTL: {
                    RtlSupportProcessor.performRefactoringForAndroidManifestApplicationTag(refactoring);
                    continue block6;
                }
                case MANIFEST_TARGET_SDK: {
                    RtlSupportProcessor.performRefactoringForAndroidManifestTargetSdk(refactoring);
                    continue block6;
                }
                case LAYOUT_FILE_ATTRIBUTE: {
                    this.performRefactoringForLayoutFile(refactoring);
                    continue block6;
                }
                case UNDEFINED: {
                    continue block6;
                }
                default: {
                    assert (false) : refactoring.getType();
                    continue block6;
                }
            }
        }
    }

    protected void performPsiSpoilingRefactoring() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    private void addManifestRefactoring(List<UsageInfo> list2) {
        for (AndroidFacet facet : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
            if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject()) continue;
            for (VirtualFile manifestFile : SourceProvidersKt.getManifestFiles(facet)) {
                XmlFile manifestPsiFile = (XmlFile)PsiManager.getInstance((Project)this.myProject).findFile(manifestFile);
                try {
                    int targetSdk;
                    XmlTag[] usesSdkNodes;
                    XmlTag root;
                    if (manifestPsiFile == null || (root = manifestPsiFile.getRootTag()) == null) continue;
                    XmlTag[] applicationNodes = root.findSubTags("application");
                    if (applicationNodes.length > 0) {
                        assert (applicationNodes.length == 1);
                        XmlTag applicationTag = applicationNodes[0];
                        XmlAttribute supportsRtlAttribute = applicationTag.getAttribute("supportsRtl", "http://schemas.android.com/apk/res/android");
                        if (supportsRtlAttribute == null || "false".equals(supportsRtlAttribute.getValue())) {
                            int endOffset;
                            int startOffset;
                            if (supportsRtlAttribute == null) {
                                XmlAttribute[] applicationTagAttributes = applicationTag.getAttributes();
                                XmlAttribute lastAttribute = applicationTagAttributes[applicationTagAttributes.length - 1];
                                PsiElement nextSibling = lastAttribute.getNextSibling();
                                assert (nextSibling != null);
                                endOffset = startOffset = nextSibling.getStartOffsetInParent() + nextSibling.getTextLength();
                            } else {
                                startOffset = supportsRtlAttribute.getStartOffsetInParent();
                                endOffset = startOffset + supportsRtlAttribute.getTextLength();
                            }
                            RtlRefactoringUsageInfo usageInfo = new RtlRefactoringUsageInfo((PsiElement)applicationTag, startOffset, endOffset);
                            usageInfo.setType(RtlRefactoringUsageInfo.RtlRefactoringType.MANIFEST_SUPPORTS_RTL);
                            list2.add(usageInfo);
                        }
                    }
                    if ((usesSdkNodes = root.findSubTags("uses-sdk")).length <= 0) continue;
                    assert (usesSdkNodes.length == 1);
                    XmlTag usesSdkTag = usesSdkNodes[0];
                    XmlAttribute targetSdkAttribute = usesSdkTag.getAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android");
                    int n = targetSdk = targetSdkAttribute != null ? Integer.parseInt(targetSdkAttribute.getValue()) : 0;
                    if (targetSdk != 0 && targetSdk >= 17) continue;
                    int startOffset = targetSdkAttribute != null ? targetSdkAttribute.getStartOffsetInParent() : usesSdkTag.getStartOffsetInParent();
                    int endOffset = startOffset + (targetSdkAttribute != null ? targetSdkAttribute.getTextLength() : usesSdkTag.getTextLength());
                    RtlRefactoringUsageInfo usageInfo = new RtlRefactoringUsageInfo((PsiElement)usesSdkTag, startOffset, endOffset);
                    usageInfo.setType(RtlRefactoringUsageInfo.RtlRefactoringType.MANIFEST_TARGET_SDK);
                    list2.add(usageInfo);
                }
                catch (Exception e) {
                    LOG.error("Could not read Manifest data", (Throwable)e);
                }
            }
        }
    }

    private static String quote(String str) {
        return "'" + str + "'";
    }

    @Nullable
    private VirtualFile getLayoutV17(VirtualFile oneLayoutRes, boolean bCreateIfNeeded) {
        String resName = oneLayoutRes.getName();
        if (resName.contains(RES_V_QUALIFIER)) {
            return null;
        }
        String resNameWithV17 = resName + RES_V17_QUALIFIER;
        VirtualFile parent = oneLayoutRes.getParent();
        assert (parent != null);
        VirtualFile layoutV17Dir = parent.findChild(resNameWithV17);
        if ((layoutV17Dir == null || !layoutV17Dir.exists()) && bCreateIfNeeded) {
            try {
                layoutV17Dir = parent.createChildDirectory((Object)this, resNameWithV17);
            }
            catch (IOException e) {
                LOG.error("Cannot create " + RtlSupportProcessor.quote(resNameWithV17) + " directory in resource directory: " + parent.getName());
            }
        }
        if (layoutV17Dir != null) assert (layoutV17Dir.isDirectory()) : layoutV17Dir;
        return layoutV17Dir;
    }

    private List<UsageInfo> getLayoutRefactoringForOneDir(@NotNull VirtualFile layoutDir, boolean createV17, int minSdk) {
        VirtualFile[] layoutChildren;
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (VirtualFile oneLayoutFile : layoutChildren = layoutDir.getChildren()) {
            result2.addAll(this.getLayoutRefactoringForOneFile(oneLayoutFile, createV17, minSdk));
        }
        return result2;
    }

    private List<UsageInfo> getLayoutRefactoringForOneFile(@NotNull VirtualFile layoutFile, boolean createV17, int minSdk) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(layoutFile);
        assert (psiFile != null);
        return this.getLayoutRefactoringForFile(psiFile, createV17, minSdk);
    }

    private void addLayoutRefactoring(List<UsageInfo> list2) {
        for (AndroidFacet facet : ProjectSystemUtil.getAndroidFacets(this.myProject)) {
            if (facet == null || !((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) continue;
            int minSdk = StudioAndroidModuleInfo.getInstance(facet).getMinSdkVersion().getApiLevel();
            if (this.myProperties.generateV17resourcesOption) {
                List<VirtualFile> allRes = ResourceFolderManager.getInstance(facet).getFolders();
                ArrayList<VirtualFile> allLayoutDir = new ArrayList<VirtualFile>();
                for (VirtualFile oneRes : allRes) {
                    VirtualFile[] children2;
                    for (VirtualFile oneChild : children2 = oneRes.getChildren()) {
                        String childName = oneChild.getName();
                        if (!childName.startsWith("layout") || childName.contains(RES_V_QUALIFIER)) continue;
                        allLayoutDir.add(oneChild);
                    }
                }
                for (VirtualFile layoutDir : allLayoutDir) {
                    VirtualFile layoutV17Dir = this.getLayoutV17(layoutDir, false);
                    if (layoutV17Dir != null) {
                        if (layoutV17Dir.getChildren().length != 0) {
                            list2.addAll(this.getLayoutRefactoringForOneDir(layoutV17Dir, false, minSdk));
                            continue;
                        }
                        list2.addAll(this.getLayoutRefactoringForOneDir(layoutDir, true, minSdk));
                        continue;
                    }
                    list2.addAll(this.getLayoutRefactoringForOneDir(layoutDir, true, minSdk));
                }
                continue;
            }
            LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
            resourceManager.findResourceFiles(ResourceNamespace.TODO(), ResourceFolderType.LAYOUT, null, true, false).forEach(psiFile -> list2.addAll(this.getLayoutRefactoringForFile((PsiFile)psiFile, false, minSdk)));
        }
    }

    private List<UsageInfo> getLayoutRefactoringForFile(@NotNull PsiFile layoutFile, final boolean createV17, final int minSdk) {
        final ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        if (layoutFile instanceof XmlFile && AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)layoutFile, ResourceFolderType.LAYOUT)) {
            layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(@NotNull XmlTag tag) {
                    super.visitXmlTag(tag);
                    List<UsageInfo> usageInfos = RtlSupportProcessor.this.getLayoutRefactoringForTag(tag, createV17, minSdk);
                    if (usageInfos.isEmpty()) {
                        return;
                    }
                    result2.addAll(usageInfos);
                }
            });
        }
        return result2;
    }

    private List<UsageInfo> getLayoutRefactoringForTag(@NotNull XmlTag tag, boolean createV17, int minSdk) {
        XmlAttribute[] attributes;
        DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
        if (!(domElement instanceof LayoutViewElement)) {
            return Collections.emptyList();
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (XmlAttribute attributeToMirror : attributes = tag.getAttributes()) {
            String value2;
            RtlRefactoringUsageInfo usageInfoForAttribute;
            int endOffset;
            boolean startOffset;
            String localName = attributeToMirror.getLocalName();
            String namespacePrefix = attributeToMirror.getNamespacePrefix();
            String mirroredLocalName = ourMapMirroredAttributeName.get(localName);
            if (mirroredLocalName != null) {
                XmlAttribute attributeMirrored = tag.getAttribute(namespacePrefix + ":" + mirroredLocalName);
                if (attributeMirrored != null) continue;
                startOffset = false;
                endOffset = attributeToMirror.getTextLength();
                usageInfoForAttribute = new RtlRefactoringUsageInfo((PsiElement)attributeToMirror, 0, endOffset);
                usageInfoForAttribute.setType(RtlRefactoringUsageInfo.RtlRefactoringType.LAYOUT_FILE_ATTRIBUTE);
                usageInfoForAttribute.setCreateV17(createV17);
                usageInfoForAttribute.setAndroidManifestMinSdkVersion(minSdk);
                result2.add(usageInfoForAttribute);
                continue;
            }
            if (!localName.equals("gravity") && !localName.equals("layout_gravity") || (value2 = attributeToMirror.getValue()) == null || !value2.contains("left") && !value2.contains("right")) continue;
            startOffset = false;
            endOffset = attributeToMirror.getTextLength();
            usageInfoForAttribute = new RtlRefactoringUsageInfo((PsiElement)attributeToMirror, 0, endOffset);
            usageInfoForAttribute.setType(RtlRefactoringUsageInfo.RtlRefactoringType.LAYOUT_FILE_ATTRIBUTE);
            usageInfoForAttribute.setCreateV17(createV17);
            result2.add(usageInfoForAttribute);
        }
        return result2;
    }

    private static void performRefactoringForAndroidManifestApplicationTag(@NotNull UsageInfo usageInfo) {
        PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlTag applicationTag = (XmlTag)element;
        XmlAttribute supportsRtlAttribute = applicationTag.getAttribute("supportsRtl", "http://schemas.android.com/apk/res/android");
        if (supportsRtlAttribute != null) {
            supportsRtlAttribute.setValue("true");
        } else {
            applicationTag.setAttribute("supportsRtl", "http://schemas.android.com/apk/res/android", "true");
        }
    }

    private static void performRefactoringForAndroidManifestTargetSdk(@NotNull UsageInfo usageInfo) {
        PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlTag usesSdkTag = (XmlTag)element;
        XmlAttribute targetSdkAttribute = usesSdkTag.getAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android");
        if (targetSdkAttribute != null) {
            targetSdkAttribute.setValue(Integer.toString(17));
        } else {
            usesSdkTag.setAttribute("targetSdkVersion", "http://schemas.android.com/apk/res/android", Integer.toString(17));
        }
    }

    private void performRefactoringForLayoutFile(@NotNull RtlRefactoringUsageInfo usageInfo) {
        final PsiElement element = usageInfo.getElement();
        assert (element != null);
        XmlAttribute attribute2 = (XmlAttribute)element;
        final int minSdk = usageInfo.getAndroidManifestMinSdkVersion();
        if (!usageInfo.isCreateV17()) {
            this.updateAttributeForElement(attribute2, minSdk);
        } else {
            PsiFile psiFile = element.getContainingFile();
            final VirtualFile layoutFile = psiFile.getVirtualFile();
            assert (layoutFile != null);
            final VirtualFile layoutDir = layoutFile.getParent();
            assert (layoutDir != null);
            final VirtualFile layoutV17Dir = this.getLayoutV17(layoutDir, true);
            assert (layoutV17Dir != null);
            final String layoutFileName = layoutFile.getName();
            if (layoutV17Dir.findChild(layoutFileName) == null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            layoutFile.copy((Object)this, layoutV17Dir, layoutFileName);
                        }
                        catch (IOException e) {
                            LOG.error("Cannot copy layout file " + RtlSupportProcessor.quote(layoutFileName) + " from " + RtlSupportProcessor.quote(layoutDir.getName()) + " directory to " + RtlSupportProcessor.quote(layoutV17Dir.getName()) + " directory");
                        }
                    }
                });
            }
            VirtualFile layoutV17File = layoutV17Dir.findChild(layoutFileName);
            assert (layoutV17File != null);
            XmlFile xmlV17File = (XmlFile)PsiManager.getInstance((Project)this.myProject).findFile(layoutV17File);
            assert (xmlV17File != null);
            LOG.info("Processing refactoring for attribute: " + attribute2.getName() + " into file: " + layoutV17File.getPath());
            if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlV17File, ResourceFolderType.LAYOUT)) {
                xmlV17File.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(@NotNull XmlTag tag) {
                        super.visitXmlTag(tag);
                        XmlAttribute attribute2 = tag.getAttribute(((XmlAttribute)element).getName());
                        if (attribute2 == null) {
                            return;
                        }
                        RtlSupportProcessor.this.updateAttributeForElement(attribute2, minSdk);
                    }
                });
            }
            layoutV17File.refresh(true, false);
        }
    }

    private void updateAttributeForElement(@NotNull XmlAttribute attribute2, int minSdk) {
        String attributeLocalName = attribute2.getLocalName();
        LOG.info("Updating attribute name: " + attributeLocalName + " value: " + attribute2.getValue());
        if (attributeLocalName.equals("gravity") || attributeLocalName.equals("layout_gravity")) {
            String value2 = StringUtil.notNullize((String)attribute2.getValue());
            String newValue = value2.replace("left", "start").replace("right", "end");
            attribute2.setValue(newValue);
            LOG.info("Changing gravity from: " + value2 + " to: " + newValue);
        } else {
            XmlAttribute attributeForUpdatingValue;
            String mirroredAttributeLocalName = ourMapMirroredAttributeName.get(attributeLocalName);
            if (mirroredAttributeLocalName == null) {
                LOG.warn("Cannot mirror attribute: " + attribute2.toString());
                return;
            }
            String mirroredAttributeName = attribute2.getNamespacePrefix() + ":" + mirroredAttributeLocalName;
            if (this.myProperties.replaceLeftRightPropertiesOption) {
                attribute2.setName(mirroredAttributeName);
                LOG.info("Replacing attribute name from: " + attributeLocalName + " to: " + mirroredAttributeLocalName);
                attributeForUpdatingValue = attribute2;
            } else {
                XmlTag parent = attribute2.getParent();
                attributeForUpdatingValue = parent.setAttribute(mirroredAttributeName, StringUtil.notNullize((String)attribute2.getValue()));
                LOG.info("Adding attribute name: " + mirroredAttributeName + " value: " + attribute2.getValue());
            }
            RtlSupportProcessor.updateAttributeValueIfNeeded(attributeForUpdatingValue, minSdk);
        }
    }

    private static void updateAttributeValueIfNeeded(@NotNull XmlAttribute attribute2, int minSdk) {
        String attributeLocalName = attribute2.getLocalName();
        String value2 = StringUtil.notNullize((String)attribute2.getValue());
        if ((attributeLocalName.equals("paddingLeft") || attributeLocalName.equals("paddingRight") || attributeLocalName.equals("paddingStart") || attributeLocalName.equals("paddingEnd")) && minSdk >= 17 && (value2.contains("listPreferredItemPaddingLeft") || value2.contains("listPreferredItemPaddingRight"))) {
            String newValue = value2.replace("listPreferredItemPaddingLeft", "listPreferredItemPaddingStart").replace("listPreferredItemPaddingRight", "listPreferredItemPaddingEnd");
            attribute2.setValue(newValue);
            LOG.info("Changing attribute value from: " + value2 + " to: " + newValue);
        }
    }

    @NotNull
    protected String getCommandName() {
        return RtlSupportProcessor.getRefactoringName();
    }

    private static String getRefactoringName() {
        return AndroidBundle.message("android.refactoring.rtl.addsupport.title", new Object[0]);
    }
}

