/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.tools.idea.gradle.model.IdeAndroidArtifact;
import com.android.tools.idea.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.GradleAndroidDependencyModel;
import com.android.tools.idea.projectsystem.ScopeType;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GradleClassFinderUtil {
    private GradleClassFinderUtil() {
    }

    @NotNull
    private static Stream<File> getCompilerOutputRoots(@NotNull GradleAndroidDependencyModel model, @NotNull EnumSet<ScopeType> scopes) {
        IdeJavaArtifact screenshotArtifact;
        IdeAndroidArtifact testArtifact;
        ArrayList<Object> artifacts = new ArrayList<Object>();
        if (scopes.contains((Object)ScopeType.MAIN)) {
            artifacts.add(model.getMainArtifactWithDependencies());
        }
        if (scopes.contains((Object)ScopeType.ANDROID_TEST) && (testArtifact = model.getArtifactForAndroidTest()) != null) {
            artifacts.add(testArtifact);
        }
        if (scopes.contains((Object)ScopeType.SCREENSHOT_TEST) && (screenshotArtifact = model.getArtifactForScreenshotTest()) != null) {
            artifacts.add(screenshotArtifact);
        }
        return artifacts.stream().flatMap(artifactInfo -> artifactInfo.getClassesFolder().stream());
    }

    @NotNull
    public static Stream<File> getModuleCompileOutputs(@NotNull Module module, @NotNull EnumSet<ScopeType> scopes) {
        GradleAndroidDependencyModel androidModel = GradleAndroidDependencyModel.get(module);
        if (androidModel != null) {
            return GradleClassFinderUtil.getCompilerOutputRoots(androidModel, scopes);
        }
        Module[] modules = new Module[]{module};
        return Stream.of(CompilerPaths.getOutputPaths((Module[])modules)).map(File::new);
    }

    @Deprecated
    @NotNull
    public static Stream<File> getModuleCompileOutputs(@NotNull Module module, boolean includeAndroidTests) {
        EnumSet<ScopeType> scopes = includeAndroidTests ? EnumSet.of(ScopeType.MAIN, ScopeType.ANDROID_TEST) : EnumSet.of(ScopeType.MAIN);
        return GradleClassFinderUtil.getModuleCompileOutputs(module, scopes);
    }
}

