/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfetto.traceprocessor;

import com.android.tools.idea.profilers.perfetto.traceprocessor.HeapProfdConverter;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonClient;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorDaemonQueryResult;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorServiceImpl;
import com.android.tools.idea.profilers.perfetto.traceprocessor.WindowsNameDemangler;
import com.android.tools.profiler.perfetto.proto.Memory;
import com.android.tools.profiler.perfetto.proto.TraceProcessor;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.systemtrace.ProcessModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceModelAdapter;
import com.android.tools.profilers.memory.adapters.classifiers.NativeMemoryHeapSet;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorModel;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonQueryStats;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u00012\u00020\u0002:\u000212B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JW\u0010 \u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122$\u0010!\u001a \u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\"2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0002\u00a2\u0006\u0002\u0010(J&\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00142\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u00100\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl;", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorService;", "Lcom/intellij/openapi/Disposable;", "ticker", "Lcom/google/common/base/Ticker;", "client", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient;", "<init>", "(Lcom/google/common/base/Ticker;Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonClient;)V", "loadedTraces", "", "", "Ljava/io/File;", "loadTrace", "", "traceId", "traceFile", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "getProcessMetadata", "", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "loadCpuData", "Lcom/android/tools/profilers/cpu/systemtrace/SystemTraceModelAdapter;", "processes", "selectedProcess", "loadMemoryData", "", "abi", "", "memorySet", "Lcom/android/tools/profilers/memory/adapters/classifiers/NativeMemoryHeapSet;", "handleRequest", "trackFeature", "Lkotlin/Function4;", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "Lcom/google/wireless/android/sdk/stats/TraceProcessorDaemonQueryStats$QueryReturnStatus;", "requestBuilders", "", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$RequestBuilder;", "(JLcom/android/tools/profilers/IdeProfilerServices;Lkotlin/jvm/functions/Function4;[Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$RequestBuilder;)V", "getTraceMetadata", "metadataName", "executeBatchQuery", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorDaemonQueryResult;", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchResponse;", "query", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchRequest;", "dispose", "Companion", "RequestBuilder", "intellij.android.profilersAndroid"})
@SourceDebugExtension(value={"SMAP\nTraceProcessorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceProcessorService.kt\ncom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n37#2:331\n36#2,3:332\n1869#3,2:335\n1869#3,2:337\n1869#3:339\n1869#3,2:340\n1870#3:342\n1761#3,3:343\n*S KotlinDebug\n*F\n+ 1 TraceProcessorService.kt\ncom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl\n*L\n201#1:331\n201#1:332,3\n245#1:335,2\n252#1:337,2\n286#1:339\n291#1:340,2\n286#1:342\n309#1:343,3\n*E\n"})
public final class TraceProcessorServiceImpl
implements TraceProcessorService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ticker ticker;
    @NotNull
    private final TraceProcessorDaemonClient client;
    @NotNull
    private final Map<Long, File> loadedTraces;
    @NotNull
    private static final Logger LOGGER;

    public TraceProcessorServiceImpl(@NotNull Ticker ticker, @NotNull TraceProcessorDaemonClient client) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.ticker = ticker;
        this.client = client;
        this.loadedTraces = new LinkedHashMap();
        Disposer.register((Disposable)this, (Disposable)this.client);
    }

    public /* synthetic */ TraceProcessorServiceImpl(Ticker ticker, TraceProcessorDaemonClient traceProcessorDaemonClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Ticker ticker2 = Ticker.systemTicker();
            Intrinsics.checkNotNullExpressionValue((Object)ticker2, (String)"systemTicker(...)");
            ticker = ticker2;
        }
        if ((n & 2) != 0) {
            traceProcessorDaemonClient = new TraceProcessorDaemonClient(ticker);
        }
        this(ticker, traceProcessorDaemonClient);
    }

    public boolean loadTrace(long traceId, @NotNull File traceFile, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)traceFile, (String)"traceFile");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        List symbolPaths = ideProfilerServices.getNativeSymbolsDirectories();
        LOGGER.info("TPD Service: Loading trace " + traceId + ": " + traceFile.getAbsolutePath());
        File symbolsFile = new File(FileUtil.getTempDirectory() + File.separator + traceId + ".symbols");
        symbolsFile.deleteOnExit();
        TraceProcessor.LoadTraceRequest requestProto = TraceProcessor.LoadTraceRequest.newBuilder().setTraceId(traceId).setTracePath(traceFile.getAbsolutePath()).addAllSymbolPath((Iterable)symbolPaths).setSymbolizedOutputPath(symbolsFile.getAbsolutePath()).build();
        Intrinsics.checkNotNull((Object)requestProto);
        TraceProcessorDaemonQueryResult<TraceProcessor.LoadTraceResponse> queryResult = this.client.loadTrace(requestProto, ideProfilerServices.getFeatureTracker());
        stopwatch.stop();
        long queryTimeMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        long traceSizeBytes = traceFile.length();
        if (!queryResult.getCompleted()) {
            ideProfilerServices.getFeatureTracker().trackTraceProcessorLoadTrace(TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, queryTimeMs, queryTimeMs, traceSizeBytes);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.warn("TPD Service: Fail to load trace " + traceId + ": " + failureReason.getMessage());
            throw new RuntimeException("TPD Service: Fail to load trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.LoadTraceResponse loadTraceResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)loadTraceResponse);
        TraceProcessor.LoadTraceResponse response2 = loadTraceResponse;
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = response2.getOk() ? TraceProcessorDaemonQueryStats.QueryReturnStatus.OK : TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR;
        ideProfilerServices.getFeatureTracker().trackTraceProcessorLoadTrace(queryStatus, queryTimeMs, queryTimeMs, traceSizeBytes);
        if (response2.getOk()) {
            LOGGER.info("TPD Service: Trace " + traceId + " loaded.");
            this.loadedTraces.put(traceId, traceFile);
            return true;
        }
        LOGGER.info("TPD Service: Error loading trace " + traceId + ": " + response2.getError());
        return false;
    }

    @NotNull
    public List<ProcessModel> getProcessMetadata(long traceId, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        TraceProcessorModel.Builder modelBuilder = new TraceProcessorModel.Builder();
        boolean bl = false;
        RequestBuilder[] requestBuilderArray = new RequestBuilder[]{new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)TraceProcessorServiceImpl::getProcessMetadata$lambda$0$0), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> TraceProcessorServiceImpl.getProcessMetadata$lambda$0$1(modelBuilder, arg_0)))};
        this.handleRequest(traceId, ideProfilerServices, (Function4<? super FeatureTracker, ? super TraceProcessorDaemonQueryStats.QueryReturnStatus, ? super Long, ? super Long, Unit>)((Function4)getProcessMetadata.1.1.INSTANCE), requestBuilderArray);
        return modelBuilder.build().getProcesses();
    }

    @NotNull
    public SystemTraceModelAdapter loadCpuData(long traceId, @NotNull List<ProcessModel> processes, @NotNull ProcessModel selectedProcess, @NotNull IdeProfilerServices ideProfilerServices) {
        TraceProcessorModel.Builder builder;
        Intrinsics.checkNotNullParameter(processes, (String)"processes");
        Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        TraceProcessorModel.Builder modelBuilder = builder = new TraceProcessorModel.Builder();
        boolean bl = false;
        List requests2 = TraceProcessorServiceImpl.Companion.cpuDataRequest(processes, selectedProcess, modelBuilder);
        Collection $this$toTypedArray$iv = requests2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RequestBuilder[] requestBuilderArray = thisCollection$iv.toArray(new RequestBuilder[0]);
        this.handleRequest(traceId, ideProfilerServices, (Function4<? super FeatureTracker, ? super TraceProcessorDaemonQueryStats.QueryReturnStatus, ? super Long, ? super Long, Unit>)((Function4)loadCpuData.1.1.INSTANCE), Arrays.copyOf(requestBuilderArray, requestBuilderArray.length));
        return (SystemTraceModelAdapter)builder.build();
    }

    public void loadMemoryData(long traceId, @NotNull String abi, @NotNull NativeMemoryHeapSet memorySet, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Intrinsics.checkNotNullParameter((Object)memorySet, (String)"memorySet");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        HeapProfdConverter converter = new HeapProfdConverter(memorySet, new WindowsNameDemangler(0L, 1, null));
        RequestBuilder[] requestBuilderArray = new RequestBuilder[]{new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)TraceProcessorServiceImpl::loadMemoryData$lambda$0), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> TraceProcessorServiceImpl.loadMemoryData$lambda$1(converter, arg_0)))};
        this.handleRequest(traceId, ideProfilerServices, (Function4<? super FeatureTracker, ? super TraceProcessorDaemonQueryStats.QueryReturnStatus, ? super Long, ? super Long, Unit>)((Function4)loadMemoryData.1.INSTANCE), requestBuilderArray);
    }

    private final void handleRequest(long traceId, IdeProfilerServices ideProfilerServices, Function4<? super FeatureTracker, ? super TraceProcessorDaemonQueryStats.QueryReturnStatus, ? super Long, ? super Long, Unit> trackFeature, RequestBuilder ... requestBuilders) {
        Stopwatch methodStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessor.QueryBatchRequest queryProto = TraceProcessorServiceImpl.Companion.buildBatchQuery(traceId, ArraysKt.asList((Object[])requestBuilders));
        LOGGER.info("TPD Service: Querying cpu data for trace " + traceId + ".");
        Stopwatch queryStopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.executeBatchQuery(traceId, queryProto, ideProfilerServices);
        queryStopwatch.stop();
        long queryTimeMs = queryStopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (!queryResult.getCompleted()) {
            methodStopwatch.stop();
            long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
            trackFeature.invoke((Object)ideProfilerServices.getFeatureTracker(), (Object)TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_FAILED, (Object)methodTimeMs, (Object)queryTimeMs);
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.info("TPD Service: Fail to get cpu data for trace " + traceId + ": " + failureReason.getMessage());
            throw new RuntimeException("TPD Service: Fail to get cpu data for trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.QueryBatchResponse queryBatchResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)queryBatchResponse);
        TraceProcessor.QueryBatchResponse response2 = queryBatchResponse;
        boolean queryError = false;
        List list2 = response2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResultList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv;
            boolean bl = false;
            if (it.getOk()) continue;
            queryError = true;
            LOGGER.warn("TPD Service: Load cpu data query error - " + it.getFailureReason() + " - " + it.getError());
        }
        List list3 = response2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getResultList(...)");
        $this$forEach$iv = CollectionsKt.zip((Iterable)list3, (Object[])requestBuilders);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            TraceProcessor.QueryResult result2 = (TraceProcessor.QueryResult)pair.component1();
            RequestBuilder request = (RequestBuilder)pair.component2();
            Function1<TraceProcessor.QueryResult, Unit> function1 = request.getHandle();
            Intrinsics.checkNotNull((Object)result2);
            function1.invoke((Object)result2);
        }
        methodStopwatch.stop();
        long methodTimeMs = methodStopwatch.elapsed(TimeUnit.MILLISECONDS);
        TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus = queryError ? TraceProcessorDaemonQueryStats.QueryReturnStatus.QUERY_ERROR : TraceProcessorDaemonQueryStats.QueryReturnStatus.OK;
        trackFeature.invoke((Object)ideProfilerServices.getFeatureTracker(), (Object)queryStatus, (Object)methodTimeMs, (Object)queryTimeMs);
    }

    @NotNull
    public List<String> getTraceMetadata(long traceId, @NotNull String metadataName, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)metadataName, (String)"metadataName");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        TraceProcessor.QueryBatchRequest query = TraceProcessor.QueryBatchRequest.newBuilder().addQuery(TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId).setTraceMetadataRequest(TraceProcessor.QueryParameters.TraceMetadataParameters.newBuilder().setName(metadataName).setType("metadata").build())).build();
        LOGGER.info("TPD Service: Querying trace metadata for trace " + traceId + ".");
        Intrinsics.checkNotNull((Object)query);
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.executeBatchQuery(traceId, query, ideProfilerServices);
        if (!queryResult.getCompleted()) {
            Exception exception = queryResult.getFailure();
            Intrinsics.checkNotNull((Object)exception);
            Exception failureReason = exception;
            LOGGER.warn("TPD Service: Fail to get trace metadata for trace " + traceId + ": " + failureReason.getMessage());
            throw new RuntimeException("TPD Service: Fail to get trace metadata for trace " + traceId + ": " + failureReason.getMessage(), failureReason);
        }
        TraceProcessor.QueryBatchResponse queryBatchResponse = queryResult.getResponse();
        Intrinsics.checkNotNull((Object)queryBatchResponse);
        TraceProcessor.QueryBatchResponse response2 = queryBatchResponse;
        List results2 = new ArrayList();
        List list2 = response2.getResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResultList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TraceProcessor.QueryResult result2 = (TraceProcessor.QueryResult)element$iv;
            boolean bl = false;
            if (!result2.getOk()) {
                LOGGER.warn("TPD Service: Trace metadata query error - " + result2.getFailureReason() + " - " + result2.getError());
            }
            if (!result2.hasTraceMetadataResult()) continue;
            List list3 = result2.getTraceMetadataResult().getMetadataRowList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getMetadataRowList(...)");
            Iterable $this$forEach$iv2 = list3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TraceProcessor.TraceMetadataRow it = (TraceProcessor.TraceMetadataRow)element$iv2;
                boolean bl2 = false;
                String string = it.getStringValue();
                if (string == null) {
                    string = String.valueOf(it.getInt64Value());
                }
                results2.add(string);
            }
        }
        return results2;
    }

    private final TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> executeBatchQuery(long traceId, TraceProcessor.QueryBatchRequest query, IdeProfilerServices ideProfilerServices) {
        boolean bl;
        TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse> queryResult = this.client.queryBatchRequest(query, ideProfilerServices.getFeatureTracker());
        Object object = queryResult.getResponse();
        if (object != null && (object = object.getResultList()) != null) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TraceProcessor.QueryResult it = (TraceProcessor.QueryResult)element$iv;
                        boolean bl3 = false;
                        if (!(it.getFailureReason() == TraceProcessor.QueryResult.QueryFailureReason.TRACE_NOT_FOUND)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            File loadedTrace = this.loadedTraces.get(traceId);
            if (loadedTrace != null) {
                this.loadTrace(traceId, loadedTrace, ideProfilerServices);
                queryResult = this.client.queryBatchRequest(query, ideProfilerServices.getFeatureTracker());
            } else {
                return new TraceProcessorDaemonQueryResult<TraceProcessor.QueryBatchResponse>(new IllegalStateException("Trace " + traceId + " needs to be loaded before querying."));
            }
        }
        return queryResult;
    }

    public void dispose() {
    }

    private static final Unit getProcessMetadata$lambda$0$0(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
        $this$RequestBuilder.setProcessMetadataRequest(TraceProcessor.QueryParameters.ProcessMetadataParameters.getDefaultInstance());
        return Unit.INSTANCE;
    }

    private static final Unit getProcessMetadata$lambda$0$1(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TraceProcessor.ProcessMetadataResult processMetadataResult = it.getProcessMetadataResult();
        Intrinsics.checkNotNullExpressionValue((Object)processMetadataResult, (String)"getProcessMetadataResult(...)");
        $modelBuilder.addProcessMetadata(processMetadataResult);
        return Unit.INSTANCE;
    }

    private static final Unit loadMemoryData$lambda$0(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
        $this$RequestBuilder.setMemoryRequest(Memory.AllocationDataRequest.getDefaultInstance());
        return Unit.INSTANCE;
    }

    private static final Unit loadMemoryData$lambda$1(HeapProfdConverter $converter, TraceProcessor.QueryResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Memory.NativeAllocationContext nativeAllocationContext = it.getMemoryEvents();
        Intrinsics.checkNotNullExpressionValue((Object)nativeAllocationContext, (String)"getMemoryEvents(...)");
        $converter.populateHeapSet(nativeAllocationContext);
        return Unit.INSTANCE;
    }

    public TraceProcessorServiceImpl() {
        this(null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final TraceProcessorService getInstance() {
        return Companion.getInstance();
    }

    static {
        Logger logger = Logger.getInstance(TraceProcessorServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorService;", "cpuDataRequest", "", "Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$RequestBuilder;", "processes", "Lcom/android/tools/profilers/cpu/systemtrace/ProcessModel;", "selectedProcess", "modelBuilder", "Lcom/android/tools/profilers/perfetto/traceprocessor/TraceProcessorModel$Builder;", "buildCpuDataRequestProto", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryBatchRequest;", "traceId", "", "buildBatchQuery", "requestBuilders", "intellij.android.profilersAndroid"})
    @SourceDebugExtension(value={"SMAP\nTraceProcessorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceProcessorService.kt\ncom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1563#2:331\n1634#2,3:332\n1869#2,2:335\n*S KotlinDebug\n*F\n+ 1 TraceProcessorService.kt\ncom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$Companion\n*L\n109#1:331\n109#1:332,3\n134#1:335,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TraceProcessorService getInstance() {
            Object object = ApplicationManager.getApplication().getService(TraceProcessorServiceImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TraceProcessorService)object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<RequestBuilder> cpuDataRequest(List<ProcessModel> processes, ProcessModel selectedProcess, TraceProcessorModel.Builder modelBuilder) {
            void $this$mapTo$iv$iv;
            Object v0;
            List requests2;
            Object object;
            block4: {
                object = new RequestBuilder[]{new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)Companion::cpuDataRequest$lambda$2), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$3(modelBuilder, arg_0))), new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)Companion::cpuDataRequest$lambda$4), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$5(modelBuilder, arg_0))), new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)Companion::cpuDataRequest$lambda$6), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$7(modelBuilder, arg_0))), new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$8(selectedProcess, arg_0)), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$9(modelBuilder, arg_0))), new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)Companion::cpuDataRequest$lambda$10), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$11(modelBuilder, arg_0))), com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorServiceImpl$Companion.cpuDataRequest$androidFrameTimelineRequest(selectedProcess.getId(), (Function1<? super TraceProcessor.AndroidFrameTimelineResult, Unit>)((Function1)new Function1<TraceProcessor.AndroidFrameTimelineResult, Unit>((Object)modelBuilder){

                    public final void invoke(TraceProcessor.AndroidFrameTimelineResult p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((TraceProcessorModel.Builder)this.receiver).addAndroidFrameTimelineEvents(p0);
                    }
                }))};
                requests2 = CollectionsKt.mutableListOf((Object[])object);
                Iterable iterable = processes;
                for (Object t : iterable) {
                    ProcessModel it = (ProcessModel)t;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it.getSafeProcessName(), (String)"surfaceflinger", (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            object = v0;
            if (object != null) {
                int surfaceflingerId = object.getId();
                boolean bl = false;
                requests2.add(com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorServiceImpl$Companion.cpuDataRequest$androidFrameTimelineRequest(surfaceflingerId, (Function1<? super TraceProcessor.AndroidFrameTimelineResult, Unit>)((Function1)new Function1<TraceProcessor.AndroidFrameTimelineResult, Unit>((Object)modelBuilder){

                    public final void invoke(TraceProcessor.AndroidFrameTimelineResult p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((TraceProcessorModel.Builder)this.receiver).indexSurfaceflingerFrameTimelineEvents(p0);
                    }
                })));
            }
            Iterable $this$map$iv = processes;
            boolean $i$f$map = false;
            Iterable surfaceflingerId = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProcessModel processModel = (ProcessModel)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getId());
            }
            object = ((List)destination$iv$iv).iterator();
            while (object.hasNext()) {
                int id2 = ((Number)object.next()).intValue();
                requests2.add(new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$15(id2, arg_0)), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$16(modelBuilder, arg_0))));
                requests2.add(new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$17(id2, arg_0)), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$18(modelBuilder, arg_0))));
                requests2.add(new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$19(id2, arg_0)), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$lambda$20(modelBuilder, arg_0))));
            }
            return requests2;
        }

        @VisibleForTesting
        @NotNull
        public final TraceProcessor.QueryBatchRequest buildCpuDataRequestProto(long traceId, @NotNull List<ProcessModel> processes, @NotNull ProcessModel selectedProcess) {
            Intrinsics.checkNotNullParameter(processes, (String)"processes");
            Intrinsics.checkNotNullParameter((Object)selectedProcess, (String)"selectedProcess");
            return this.buildBatchQuery(traceId, this.cpuDataRequest(processes, selectedProcess, new TraceProcessorModel.Builder()));
        }

        private final TraceProcessor.QueryBatchRequest buildBatchQuery(long traceId, List<RequestBuilder> requestBuilders) {
            TraceProcessor.QueryBatchRequest.Builder $this$buildBatchQuery_u24lambda_u240 = TraceProcessor.QueryBatchRequest.newBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = requestBuilders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RequestBuilder requestBuilder = (RequestBuilder)element$iv;
                boolean bl2 = false;
                Function1<TraceProcessor.QueryParameters.Builder, Unit> setUp = requestBuilder.component1();
                TraceProcessor.QueryParameters.Builder builder = TraceProcessor.QueryParameters.newBuilder().setTraceId(traceId);
                setUp.invoke((Object)builder);
                $this$buildBatchQuery_u24lambda_u240.addQuery(builder);
            }
            TraceProcessor.QueryBatchRequest queryBatchRequest = $this$buildBatchQuery_u24lambda_u240.build();
            Intrinsics.checkNotNullExpressionValue((Object)queryBatchRequest, (String)"with(...)");
            return queryBatchRequest;
        }

        private static final RequestBuilder cpuDataRequest$androidFrameTimelineRequest(long id2, Function1<? super TraceProcessor.AndroidFrameTimelineResult, Unit> handle) {
            return new RequestBuilder((Function1<? super TraceProcessor.QueryParameters.Builder, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$androidFrameTimelineRequest$lambda$0(id2, arg_0)), (Function1<? super TraceProcessor.QueryResult, Unit>)((Function1)arg_0 -> Companion.cpuDataRequest$androidFrameTimelineRequest$lambda$1(handle, arg_0)));
        }

        private static final Unit cpuDataRequest$androidFrameTimelineRequest$lambda$0(long $id, TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setAndroidFrameTimelineRequest(TraceProcessor.QueryParameters.AndroidFrameTimelineParameters.newBuilder().setProcessId($id));
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$androidFrameTimelineRequest$lambda$1(Function1 $handle, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.AndroidFrameTimelineResult androidFrameTimelineResult = it.getAndroidFrameTimelineResult();
            Intrinsics.checkNotNullExpressionValue((Object)androidFrameTimelineResult, (String)"getAndroidFrameTimelineResult(...)");
            $handle.invoke((Object)androidFrameTimelineResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$2(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setProcessMetadataRequest(TraceProcessor.QueryParameters.ProcessMetadataParameters.getDefaultInstance());
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$3(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.ProcessMetadataResult processMetadataResult = it.getProcessMetadataResult();
            Intrinsics.checkNotNullExpressionValue((Object)processMetadataResult, (String)"getProcessMetadataResult(...)");
            $modelBuilder.addProcessMetadata(processMetadataResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$4(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setSchedRequest(TraceProcessor.QueryParameters.SchedulingEventsParameters.getDefaultInstance());
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$5(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.SchedulingEventsResult schedulingEventsResult = it.getSchedResult();
            Intrinsics.checkNotNullExpressionValue((Object)schedulingEventsResult, (String)"getSchedResult(...)");
            $modelBuilder.addSchedulingEvents(schedulingEventsResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$6(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setCpuCoreCountersRequest(TraceProcessor.QueryParameters.CpuCoreCountersParameters.getDefaultInstance());
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$7(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.CpuCoreCountersResult cpuCoreCountersResult = it.getCpuCoreCountersResult();
            Intrinsics.checkNotNullExpressionValue((Object)cpuCoreCountersResult, (String)"getCpuCoreCountersResult(...)");
            $modelBuilder.addCpuCounters(cpuCoreCountersResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$8(ProcessModel $selectedProcess, TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setAndroidFrameEventsRequest(TraceProcessor.QueryParameters.AndroidFrameEventsParameters.newBuilder().setLayerNameHint($selectedProcess.getName()));
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$9(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.AndroidFrameEventsResult androidFrameEventsResult = it.getAndroidFrameEventsResult();
            Intrinsics.checkNotNullExpressionValue((Object)androidFrameEventsResult, (String)"getAndroidFrameEventsResult(...)");
            $modelBuilder.addAndroidFrameEvents(androidFrameEventsResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$10(TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setPowerCounterTracksRequest(TraceProcessor.QueryParameters.PowerCounterTracksParameters.getDefaultInstance());
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$11(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.PowerCounterTracksResult powerCounterTracksResult = it.getPowerCounterTracksResult();
            Intrinsics.checkNotNullExpressionValue((Object)powerCounterTracksResult, (String)"getPowerCounterTracksResult(...)");
            $modelBuilder.addPowerCounters(powerCounterTracksResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$15(int $id, TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setTraceEventsRequest(TraceProcessor.QueryParameters.TraceEventsParameters.newBuilder().setProcessId((long)$id));
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$16(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.TraceEventsResult traceEventsResult = it.getTraceEventsResult();
            Intrinsics.checkNotNullExpressionValue((Object)traceEventsResult, (String)"getTraceEventsResult(...)");
            $modelBuilder.addTraceEvents(traceEventsResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$17(int $id, TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setProcessCountersRequest(TraceProcessor.QueryParameters.ProcessCountersParameters.newBuilder().setProcessId((long)$id));
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$18(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.ProcessCountersResult processCountersResult = it.getProcessCountersResult();
            Intrinsics.checkNotNullExpressionValue((Object)processCountersResult, (String)"getProcessCountersResult(...)");
            $modelBuilder.addProcessCounters(processCountersResult);
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$19(int $id, TraceProcessor.QueryParameters.Builder $this$RequestBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$RequestBuilder, (String)"$this$RequestBuilder");
            $this$RequestBuilder.setThreadStatesRequest(TraceProcessor.QueryParameters.ThreadStatesParameters.newBuilder().setProcessId((long)$id));
            return Unit.INSTANCE;
        }

        private static final Unit cpuDataRequest$lambda$20(TraceProcessorModel.Builder $modelBuilder, TraceProcessor.QueryResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TraceProcessor.ThreadStatesResult threadStatesResult = it.getThreadStatesResult();
            Intrinsics.checkNotNullExpressionValue((Object)threadStatesResult, (String)"getThreadStatesResult(...)");
            $modelBuilder.addThreadStates(threadStatesResult);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B4\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J:\u0010\u0010\u001a\u00020\u00002\u0019\b\u0002\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\"\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/profilers/perfetto/traceprocessor/TraceProcessorServiceImpl$RequestBuilder;", "", "setUpQuery", "Lkotlin/Function1;", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryParameters$Builder;", "", "Lkotlin/ExtensionFunctionType;", "handle", "Lcom/android/tools/profiler/perfetto/proto/TraceProcessor$QueryResult;", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getSetUpQuery", "()Lkotlin/jvm/functions/Function1;", "getHandle", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.profilersAndroid"})
    private static final class RequestBuilder {
        @NotNull
        private final Function1<TraceProcessor.QueryParameters.Builder, Unit> setUpQuery;
        @NotNull
        private final Function1<TraceProcessor.QueryResult, Unit> handle;

        public RequestBuilder(@NotNull Function1<? super TraceProcessor.QueryParameters.Builder, Unit> setUpQuery, @NotNull Function1<? super TraceProcessor.QueryResult, Unit> handle) {
            Intrinsics.checkNotNullParameter(setUpQuery, (String)"setUpQuery");
            Intrinsics.checkNotNullParameter(handle, (String)"handle");
            this.setUpQuery = setUpQuery;
            this.handle = handle;
        }

        @NotNull
        public final Function1<TraceProcessor.QueryParameters.Builder, Unit> getSetUpQuery() {
            return this.setUpQuery;
        }

        @NotNull
        public final Function1<TraceProcessor.QueryResult, Unit> getHandle() {
            return this.handle;
        }

        @NotNull
        public final Function1<TraceProcessor.QueryParameters.Builder, Unit> component1() {
            return this.setUpQuery;
        }

        @NotNull
        public final Function1<TraceProcessor.QueryResult, Unit> component2() {
            return this.handle;
        }

        @NotNull
        public final RequestBuilder copy(@NotNull Function1<? super TraceProcessor.QueryParameters.Builder, Unit> setUpQuery, @NotNull Function1<? super TraceProcessor.QueryResult, Unit> handle) {
            Intrinsics.checkNotNullParameter(setUpQuery, (String)"setUpQuery");
            Intrinsics.checkNotNullParameter(handle, (String)"handle");
            return new RequestBuilder(setUpQuery, handle);
        }

        public static /* synthetic */ RequestBuilder copy$default(RequestBuilder requestBuilder, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = requestBuilder.setUpQuery;
            }
            if ((n & 2) != 0) {
                function12 = requestBuilder.handle;
            }
            return requestBuilder.copy(function1, function12);
        }

        @NotNull
        public String toString() {
            return "RequestBuilder(setUpQuery=" + this.setUpQuery + ", handle=" + this.handle + ")";
        }

        public int hashCode() {
            int result2 = this.setUpQuery.hashCode();
            result2 = result2 * 31 + this.handle.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestBuilder)) {
                return false;
            }
            RequestBuilder requestBuilder = (RequestBuilder)other;
            if (!Intrinsics.areEqual(this.setUpQuery, requestBuilder.setUpQuery)) {
                return false;
            }
            return Intrinsics.areEqual(this.handle, requestBuilder.handle);
        }
    }
}

