/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.commands;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.idea.transport.TransportServiceUtils;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/profilers/commands/LegacyAllocationCommandHandler;", "Lcom/android/tools/idea/transport/TransportProxy$ProxyCommandHandler;", "device", "Lcom/android/ddmlib/IDevice;", "eventQueue", "Ljava/util/concurrent/BlockingDeque;", "Lcom/android/tools/profiler/proto/Common$Event;", "filePathCache", "", "", "fetchExecutor", "Ljava/util/concurrent/Executor;", "legacyTrackerSupplier", "Ljava/util/function/BiFunction;", "", "Lcom/android/tools/idea/profilers/LegacyAllocationTracker;", "<init>", "(Lcom/android/ddmlib/IDevice;Ljava/util/concurrent/BlockingDeque;Ljava/util/Map;Ljava/util/concurrent/Executor;Ljava/util/function/BiFunction;)V", "getDevice", "()Lcom/android/ddmlib/IDevice;", "getEventQueue", "()Ljava/util/concurrent/BlockingDeque;", "getFilePathCache", "()Ljava/util/Map;", "getFetchExecutor", "()Ljava/util/concurrent/Executor;", "getLegacyTrackerSupplier", "()Ljava/util/function/BiFunction;", "myLegacyTrackers", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "myInProgressTrackingInfo", "Lcom/android/tools/profiler/proto/Memory$AllocationsInfo;", "execute", "Lcom/android/tools/profiler/proto/Transport$ExecuteResponse;", "command", "Lcom/android/tools/profiler/proto/Commands$Command;", "enableAllocations", "", "disableAllocations", "intellij.android.profilersAndroid"})
public final class LegacyAllocationCommandHandler
implements TransportProxy.ProxyCommandHandler {
    @NotNull
    private final IDevice device;
    @NotNull
    private final BlockingDeque<Common.Event> eventQueue;
    @NotNull
    private final Map<String, String> filePathCache;
    @NotNull
    private final Executor fetchExecutor;
    @NotNull
    private final BiFunction<IDevice, Integer, LegacyAllocationTracker> legacyTrackerSupplier;
    @NotNull
    private final Int2ObjectOpenHashMap<LegacyAllocationTracker> myLegacyTrackers;
    @NotNull
    private final Int2ObjectOpenHashMap<Memory.AllocationsInfo> myInProgressTrackingInfo;

    public LegacyAllocationCommandHandler(@NotNull IDevice device2, @NotNull BlockingDeque<Common.Event> eventQueue, @NotNull Map<String, String> filePathCache, @NotNull Executor fetchExecutor, @NotNull BiFunction<IDevice, Integer, LegacyAllocationTracker> legacyTrackerSupplier) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(eventQueue, (String)"eventQueue");
        Intrinsics.checkNotNullParameter(filePathCache, (String)"filePathCache");
        Intrinsics.checkNotNullParameter((Object)fetchExecutor, (String)"fetchExecutor");
        Intrinsics.checkNotNullParameter(legacyTrackerSupplier, (String)"legacyTrackerSupplier");
        this.device = device2;
        this.eventQueue = eventQueue;
        this.filePathCache = filePathCache;
        this.fetchExecutor = fetchExecutor;
        this.legacyTrackerSupplier = legacyTrackerSupplier;
        this.myLegacyTrackers = new Int2ObjectOpenHashMap();
        this.myInProgressTrackingInfo = new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final IDevice getDevice() {
        return this.device;
    }

    @NotNull
    public final BlockingDeque<Common.Event> getEventQueue() {
        return this.eventQueue;
    }

    @NotNull
    public final Map<String, String> getFilePathCache() {
        return this.filePathCache;
    }

    @NotNull
    public final Executor getFetchExecutor() {
        return this.fetchExecutor;
    }

    @NotNull
    public final BiFunction<IDevice, Integer, LegacyAllocationTracker> getLegacyTrackerSupplier() {
        return this.legacyTrackerSupplier;
    }

    @Override
    @NotNull
    public Transport.ExecuteResponse execute(@NotNull Commands.Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Commands.Command.CommandType commandType = command.getType();
        switch (commandType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType.ordinal()]) {
            case 1: {
                this.enableAllocations(command);
                break;
            }
            case 2: {
                this.disableAllocations(command);
            }
        }
        Transport.ExecuteResponse executeResponse = Transport.ExecuteResponse.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executeResponse, (String)"getDefaultInstance(...)");
        return executeResponse;
    }

    /*
     * WARNING - void declaration
     */
    private final void enableAllocations(Commands.Command command) {
        void $this$enableAllocations_u24lambda_u241_u240;
        Common.Event.Builder builder;
        Memory.MemoryAllocTrackingStatusData.Builder $this$enableAllocations_u24lambda_u240;
        Memory.MemoryAllocTrackingStatusData.Builder builder2;
        long requestTime = command.getStartAllocTracking().getRequestTime();
        Memory.TrackStatus.Builder statusBuilder = null;
        statusBuilder = Memory.TrackStatus.newBuilder();
        if (this.myInProgressTrackingInfo.containsKey(command.getPid())) {
            v0 = statusBuilder.setStatus(Memory.TrackStatus.Status.IN_PROGRESS);
        } else {
            LegacyAllocationTracker tracker;
            boolean success;
            if (!this.myLegacyTrackers.containsKey(command.getPid())) {
                this.myLegacyTrackers.put(command.getPid(), (Object)this.legacyTrackerSupplier.apply(this.device, command.getPid()));
            }
            if (success = (tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(command.getPid())).trackAllocations(true, null, null)) {
                void $this$enableAllocations_u24lambda_u240_u240;
                Memory.MemoryAllocTrackingData.Builder builder3;
                Memory.AllocationsInfo newInfo = Memory.AllocationsInfo.newBuilder().setStartTime(requestTime).setEndTime(Long.MAX_VALUE).setLegacy(true).build();
                this.myInProgressTrackingInfo.put(command.getPid(), (Object)newInfo);
                $this$enableAllocations_u24lambda_u240 = builder2 = Common.Event.newBuilder();
                boolean bl = false;
                $this$enableAllocations_u24lambda_u240.setPid(command.getPid());
                $this$enableAllocations_u24lambda_u240.setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING);
                $this$enableAllocations_u24lambda_u240.setGroupId(requestTime);
                $this$enableAllocations_u24lambda_u240.setTimestamp(requestTime);
                Memory.MemoryAllocTrackingData.Builder builder4 = builder3 = Memory.MemoryAllocTrackingData.newBuilder();
                Memory.MemoryAllocTrackingStatusData.Builder builder5 = $this$enableAllocations_u24lambda_u240;
                boolean bl2 = false;
                $this$enableAllocations_u24lambda_u240_u240.setInfo(newInfo);
                builder5.setMemoryAllocTracking(builder3.build());
                Common.Event allocEvent = builder2.build();
                this.eventQueue.offer(allocEvent);
                statusBuilder.setStartTime(requestTime);
                v0 = statusBuilder.setStatus(Memory.TrackStatus.Status.SUCCESS);
            } else {
                v0 = statusBuilder.setStatus(Memory.TrackStatus.Status.FAILURE_UNKNOWN);
            }
        }
        Common.Event.Builder $this$enableAllocations_u24lambda_u241 = builder = Common.Event.newBuilder();
        boolean bl = false;
        $this$enableAllocations_u24lambda_u241.setPid(command.getPid());
        $this$enableAllocations_u24lambda_u241.setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS);
        $this$enableAllocations_u24lambda_u241.setCommandId(command.getCommandId());
        $this$enableAllocations_u24lambda_u241.setTimestamp(requestTime);
        $this$enableAllocations_u24lambda_u240 = builder2 = Memory.MemoryAllocTrackingStatusData.newBuilder();
        Common.Event.Builder builder6 = $this$enableAllocations_u24lambda_u241;
        boolean bl3 = false;
        $this$enableAllocations_u24lambda_u241_u240.setStatus(statusBuilder.build());
        builder6.setMemoryAllocTrackingStatus(builder2.build());
        Common.Event statusEvent = builder.build();
        this.eventQueue.offer(statusEvent);
    }

    /*
     * WARNING - void declaration
     */
    private final void disableAllocations(Commands.Command command) {
        void $this$disableAllocations_u24lambda_u242_u240;
        Memory.MemoryAllocTrackingStatusData.Builder builder;
        Common.Event.Builder builder2;
        Memory.MemoryAllocTrackingStatusData.Builder builder3;
        long requestTime = command.getStopAllocTracking().getRequestTime();
        Memory.TrackStatus.Builder statusBuilder = null;
        statusBuilder = Memory.TrackStatus.newBuilder();
        if (!this.myInProgressTrackingInfo.containsKey(command.getPid())) {
            v0 = (MessageOrBuilder)statusBuilder.setStatus(Memory.TrackStatus.Status.NOT_ENABLED);
        } else {
            void $this$disableAllocations_u24lambda_u241_u240;
            Memory.MemoryAllocTrackingData.Builder builder4;
            boolean bl = this.myLegacyTrackers.containsKey(command.getPid());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            LegacyAllocationTracker tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(command.getPid());
            Memory.AllocationsInfo lastInfo = (Memory.AllocationsInfo)this.myInProgressTrackingInfo.get(command.getPid());
            boolean success = tracker.trackAllocations(false, this.fetchExecutor, arg_0 -> LegacyAllocationCommandHandler.disableAllocations$lambda$0(lastInfo, this, arg_0));
            Memory.AllocationsInfo.Builder lastInfoBuilder = lastInfo.toBuilder();
            lastInfoBuilder.setEndTime(requestTime);
            lastInfoBuilder.setSuccess(success);
            Memory.MemoryAllocTrackingStatusData.Builder $this$disableAllocations_u24lambda_u241 = builder3 = Common.Event.newBuilder();
            boolean bl2 = false;
            $this$disableAllocations_u24lambda_u241.setPid(command.getPid());
            $this$disableAllocations_u24lambda_u241.setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING);
            $this$disableAllocations_u24lambda_u241.setGroupId(lastInfoBuilder.getStartTime());
            $this$disableAllocations_u24lambda_u241.setIsEnded(true);
            $this$disableAllocations_u24lambda_u241.setTimestamp(requestTime);
            Memory.MemoryAllocTrackingData.Builder builder5 = builder4 = Memory.MemoryAllocTrackingData.newBuilder();
            Memory.MemoryAllocTrackingStatusData.Builder builder6 = $this$disableAllocations_u24lambda_u241;
            boolean bl3 = false;
            $this$disableAllocations_u24lambda_u241_u240.setInfo(lastInfoBuilder.build());
            builder6.setMemoryAllocTracking(builder4.build());
            Common.Event allocEvent = builder3.build();
            this.eventQueue.offer(allocEvent);
            this.addSessionEndedEvent(this.eventQueue, requestTime, command.getPid(), command.getSessionId());
            Memory.TrackStatus.Builder builder7 = success ? statusBuilder.setStatus(Memory.TrackStatus.Status.SUCCESS).setStartTime(lastInfo.getStartTime()) : statusBuilder.setStatus(Memory.TrackStatus.Status.FAILURE_UNKNOWN);
            v0 = (MessageOrBuilder)this.myInProgressTrackingInfo.remove(command.getPid());
        }
        Common.Event.Builder $this$disableAllocations_u24lambda_u242 = builder2 = Common.Event.newBuilder();
        boolean bl = false;
        $this$disableAllocations_u24lambda_u242.setPid(command.getPid());
        $this$disableAllocations_u24lambda_u242.setKind(Common.Event.Kind.MEMORY_ALLOC_TRACKING_STATUS);
        $this$disableAllocations_u24lambda_u242.setCommandId(command.getCommandId());
        $this$disableAllocations_u24lambda_u242.setTimestamp(requestTime);
        builder3 = builder = Memory.MemoryAllocTrackingStatusData.newBuilder();
        Common.Event.Builder builder8 = $this$disableAllocations_u24lambda_u242;
        boolean bl4 = false;
        $this$disableAllocations_u24lambda_u242_u240.setStatus(statusBuilder.build());
        builder8.setMemoryAllocTrackingStatus(builder.build());
        Common.Event statusEvent = builder2.build();
        this.eventQueue.offer(statusEvent);
    }

    private static final void disableAllocations$lambda$0(Memory.AllocationsInfo $lastInfo, LegacyAllocationCommandHandler this$0, byte[] bytes2) {
        String string;
        if (bytes2 == null || bytes2.length == 0) {
            string = "";
        } else {
            String string2 = "legacy_allocs_" + $lastInfo.getStartTime();
            ByteString byteString = ByteString.copyFrom((byte[])bytes2);
            Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"copyFrom(...)");
            string = TransportServiceUtils.createTempFile(string2, ".alloc", byteString).getAbsolutePath();
        }
        String path = string;
        Map<String, String> map2 = this$0.filePathCache;
        String string3 = String.valueOf($lastInfo.getStartTime());
        Intrinsics.checkNotNull((Object)path);
        map2.put(string3, path);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Commands.Command.CommandType.values().length];
            try {
                nArray[Commands.Command.CommandType.START_ALLOC_TRACKING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Commands.Command.CommandType.STOP_ALLOC_TRACKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

