/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.Channel;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.commands.CpuTraceInterceptCommandHandler;
import com.android.tools.idea.profilers.commands.GcCommandHandler;
import com.android.tools.idea.profilers.commands.LeakCanaryLogcatCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyAllocationCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyCpuTraceCommandHandler;
import com.android.tools.idea.profilers.eventpreprocessor.SimpleperfPipelinePreprocessor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.transport.TransportConfigContributor;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfSampleReporter;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerTransportConfigContributor
implements TransportConfigContributor {
    private final int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryAllocationDataFetchExecutor";

    @Override
    public void customizeProxyService(@NotNull TransportProxy proxy) {
        IDevice device2 = proxy.getDevice();
        proxy.registerProxyCommandHandler(Commands.Command.CommandType.GC, new GcCommandHandler(device2));
        if (device2.getVersion().getFeatureLevel() < 26) {
            LegacyAllocationCommandHandler trackAllocationHandler = new LegacyAllocationCommandHandler(device2, proxy.getEventQueue(), proxy.getFilePathCache(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), StudioLegacyAllocationTracker::new);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_ALLOC_TRACKING, trackAllocationHandler);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_ALLOC_TRACKING, trackAllocationHandler);
        }
        if (device2.getVersion().getFeatureLevel() < 26) {
            cpuTraceHandler = new LegacyCpuTraceCommandHandler(device2, TransportServiceGrpc.newBlockingStub((Channel)proxy.getTransportChannel()), proxy.getEventQueue(), proxy.getFilePathCache());
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_TRACE, cpuTraceHandler);
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_TRACE, cpuTraceHandler);
        } else if (device2.getVersion().getFeatureLevel() >= 30) {
            cpuTraceHandler = new CpuTraceInterceptCommandHandler(device2, TransportServiceGrpc.newBlockingStub((Channel)proxy.getTransportChannel()));
            proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_TRACE, cpuTraceHandler);
        }
        SimpleperfPipelinePreprocessor traceProcessor = new SimpleperfPipelinePreprocessor((TracePreProcessor)new SimpleperfSampleReporter(UsageTrackerUtils.deviceToDeviceInfo(device2)));
        proxy.registerEventPreprocessor(traceProcessor);
        proxy.registerDataPreprocessor(traceProcessor);
        LeakCanaryLogcatCommandHandler lcLogcatHandler = new LeakCanaryLogcatCommandHandler(device2, TransportServiceGrpc.newBlockingStub((Channel)proxy.getTransportChannel()), proxy.getEventQueue());
        proxy.registerProxyCommandHandler(Commands.Command.CommandType.START_LOGCAT_TRACKING, lcLogcatHandler);
        proxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_LOGCAT_TRACKING, lcLogcatHandler);
    }

    @Override
    public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
        configBuilder.setCommon(configBuilder.getCommonBuilder().setProfilerUnifiedPipeline(true).setProfilerTaskBasedUx(((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue())).setCpu(Transport.DaemonConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC).setUsePerfetto(true).setUseTracebox(((Boolean)StudioFlags.PROFILER_TRACEBOX.get()).booleanValue()));
    }

    @Override
    public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
        int liveAllocationSamplingRate = BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        configBuilder.setCommon(configBuilder.getCommonBuilder().setProfilerUnifiedPipeline(true).setProfilerTaskBasedUx(((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue())).setMem(Agent.AgentConfig.MemoryConfig.newBuilder().setMaxStackDepth(this.LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(true).setSamplingRate(Memory.MemoryAllocSamplingData.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setCpuApiTracingEnabled(true);
        if (runConfig != null && runConfig.getProfilerState().isNativeMemoryStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_TRACE);
        } else if (runConfig != null && runConfig.getProfilerState().isCpuStartupProfilingEnabled()) {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.ON_COMMAND);
            configBuilder.setAttachCommand(Commands.Command.CommandType.STOP_TRACE);
        } else {
            configBuilder.setAttachMethod(Agent.AgentConfig.AttachAgentMethod.INSTANT);
        }
    }
}

