/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.idea.codenavigation.IntelliJNavSource;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.flags.enums.PowerProfilerDisplayMode;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.ListBoxChooserDialog;
import com.android.tools.idea.profilers.ProfilerBuildAndLaunch;
import com.android.tools.idea.profilers.TemporaryProfilerPreferences;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.perfetto.traceprocessor.TraceProcessorServiceImpl;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.profilers.stacktrace.IntelliJNativeFrameSymbolizer;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerPreferences;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.perfetto.traceprocessor.TraceProcessorService;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IntellijProfilerServices
implements IdeProfilerServices,
Disposable {
    @NotNull
    private final SymbolFilesLocator mySymbolLocator;
    private final CodeNavigator myCodeNavigator;
    @NotNull
    private final NativeFrameSymbolizer myNativeSymbolizer;
    private final StudioFeatureTracker myFeatureTracker;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IntellijProfilerPreferences myPersistentPreferences;
    @NotNull
    private final TemporaryProfilerPreferences myTemporaryPreferences;

    private static Logger getLogger() {
        return Logger.getInstance(IntellijProfilerServices.class);
    }

    public IntellijProfilerServices(@NotNull Project project, @NotNull SymbolFilesLocator symbolLocator) {
        this.myProject = project;
        this.myFeatureTracker = new StudioFeatureTracker(this.myProject);
        this.mySymbolLocator = symbolLocator;
        NativeSymbolizer nativeSymbolizer = NativeSymbolizerKt.createNativeSymbolizer(this.mySymbolLocator);
        Disposer.register((Disposable)this, nativeSymbolizer::stop);
        this.myNativeSymbolizer = new IntelliJNativeFrameSymbolizer(nativeSymbolizer);
        this.myPersistentPreferences = new IntellijProfilerPreferences();
        this.myTemporaryPreferences = new TemporaryProfilerPreferences();
        this.myCodeNavigator = new CodeNavigator(new IntelliJNavSource(project, nativeSymbolizer), CodeNavigator.Companion.getApplicationExecutor());
        this.myCodeNavigator.addListener(location -> this.myFeatureTracker.trackNavigateToCode());
    }

    public void dispose() {
    }

    @NotNull
    public Executor getMainExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0);
    }

    @NotNull
    public Executor getPoolExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
    }

    public Set<String> getAllProjectClasses() {
        Query query = AllClassesSearch.search((SearchScope)ProjectScope.getProjectScope((Project)this.myProject), (Project)this.myProject);
        HashSet<String> classNames = new HashSet<String>();
        query.forEach(aClass -> classNames.add(aClass.getQualifiedName()));
        return classNames;
    }

    public void saveFile(@NotNull File file, @NotNull Consumer<FileOutputStream> fileOutputStreamConsumer, @Nullable Runnable postRunnable) {
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    IntellijProfilerServices.getLogger().error("Could not create new file at: " + file.getPath());
                    return;
                }
            }
            catch (IOException e) {
                IntellijProfilerServices.getLogger().error((Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fileOutputStreamConsumer.accept(fos);
        }
        catch (IOException e) {
            IntellijProfilerServices.getLogger().error((Throwable)e);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            virtualFile.refresh(true, false, postRunnable);
        }
    }

    @NotNull
    public NativeFrameSymbolizer getNativeFrameSymbolizer() {
        return this.myNativeSymbolizer;
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        return this.myCodeNavigator;
    }

    @NotNull
    public FeatureTracker getFeatureTracker() {
        return this.myFeatureTracker;
    }

    public void enableAdvancedProfiling() {
        RunnerAndConfigurationSettings configurationSettings;
        AndroidRunConfigurationBase androidConfiguration = null;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && configurationSettings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            androidConfiguration = (AndroidRunConfigurationBase)configurationSettings.getConfiguration();
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(true);
        }
        EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(this.myProject);
        dialog2.show();
        if (androidConfiguration != null) {
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(false);
        }
    }

    @NotNull
    public FeatureConfig getFeatureConfig() {
        return new FeatureConfigProd();
    }

    @NotNull
    public ProfilerPreferences getTemporaryProfilerPreferences() {
        return this.myTemporaryPreferences;
    }

    @NotNull
    public ProfilerPreferences getPersistentProfilerPreferences() {
        return this.myPersistentPreferences;
    }

    public void openYesNoDialog(String message, String title2, Runnable yesCallback, Runnable noCallback) {
        int dialogResult = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)title2, (Icon)Messages.getWarningIcon());
        (dialogResult == 0 ? yesCallback : noCallback).run();
    }

    public boolean openOkCancelDialog(@NotNull String message, @NotNull String title2, final @NotNull Consumer<Boolean> doNotShowSettingSaver) {
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)title2, (String)message).icon(Messages.getInformationIcon())).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){

            public void rememberChoice(boolean isSelected, int exitCode2) {
                doNotShowSettingSaver.accept(isSelected);
            }

            @NotNull
            public String getDoNotShowMessage() {
                return "Do not show again";
            }
        })).ask(this.myProject);
    }

    @Nullable
    public <T> T openListBoxChooserDialog(@NotNull String title2, @Nullable String message, @NotNull List<T> options, @NotNull Function<T, String> listBoxPresentationAdapter) {
        AtomicReference<Object> selectedValue = new AtomicReference<Object>();
        Supplier<Object> dialog2 = () -> {
            ListBoxChooserDialog listBoxDialog = new ListBoxChooserDialog(title2, message, options, listBoxPresentationAdapter);
            listBoxDialog.show();
            return listBoxDialog.getExitCode() != 0 ? null : listBoxDialog.getSelectedValue();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            selectedValue.set(dialog2.get());
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                ApplicationManager.getApplication().invokeLater(() -> {
                    selectedValue.set(dialog2.get());
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (T)selectedValue.get();
    }

    @NotNull
    public @Unmodifiable List<String> getNativeSymbolsDirectories() {
        String arch = this.myCodeNavigator.getCpuArchSource().get();
        Collection<File> dirs = this.mySymbolLocator.getDirectories(arch);
        return ContainerUtil.map(dirs, file -> file.getAbsolutePath());
    }

    public List<ProfilingConfiguration> getUserCpuProfilerConfigs(int apiLevel) {
        CpuProfilerConfigsState configsState = CpuProfilerConfigsState.getInstance(this.myProject);
        return CpuProfilerConfigConverter.toProfilingConfiguration(configsState.getUserConfigs(), apiLevel);
    }

    public List<ProfilingConfiguration> getTaskCpuProfilerConfigs(int apiLevel) {
        CpuProfilerConfigsState configsState = CpuProfilerConfigsState.getInstance(this.myProject);
        return CpuProfilerConfigConverter.toProfilingConfiguration(configsState.getSavedTaskConfigsIfPresentOrDefault(), apiLevel);
    }

    public List<ProfilingConfiguration> getDefaultCpuProfilerConfigs(int apiLevel) {
        return CpuProfilerConfigConverter.toProfilingConfiguration(CpuProfilerConfigsState.getDefaultConfigs(), apiLevel);
    }

    public void enableStartupTask(@NotNull ProfilerTaskType taskType, @NotNull TaskHomeTabModel.TaskRecordingType recordingType) {
        RunConfiguration runConfiguration;
        RunnerAndConfigurationSettings configurationSettings;
        assert (this.isTaskSupportedOnStartup(taskType));
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && (runConfiguration = configurationSettings.getConfiguration()) instanceof AndroidRunConfigurationBase) {
            AndroidRunConfigurationBase androidConfiguration = (AndroidRunConfigurationBase)runConfiguration;
            ProfilerState profilerState = androidConfiguration.getProfilerState();
            profilerState.disableStartupProfiling();
            profilerState.STARTUP_PROFILING_ENABLED = true;
            if (taskType == ProfilerTaskType.NATIVE_ALLOCATIONS) {
                profilerState.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED = true;
            } else {
                profilerState.STARTUP_CPU_PROFILING_ENABLED = true;
                profilerState.STARTUP_CPU_PROFILING_CONFIGURATION_NAME = CpuProfilerConfigConverter.fromTaskTypeToConfigName(taskType, recordingType);
            }
        }
    }

    public void clearStartupTaskConfigs() {
        RunConfiguration runConfiguration;
        RunnerAndConfigurationSettings configurationSettings;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && (runConfiguration = configurationSettings.getConfiguration()) instanceof AndroidRunConfigurationBase) {
            AndroidRunConfigurationBase androidConfiguration = (AndroidRunConfigurationBase)runConfiguration;
            ProfilerState profilerState = androidConfiguration.getProfilerState();
            profilerState.disableStartupProfiling();
        }
    }

    public boolean isTaskSupportedOnStartup(@NotNull ProfilerTaskType taskType) {
        return Arrays.stream(CpuProfilerConfig.Technology.values()).anyMatch(value2 -> CpuProfilerConfigConverter.fromTechnologyToTaskType(value2) == taskType);
    }

    public boolean isNativeProfilingConfigurationPreferred() {
        ImmutableList nativeExtensions = ImmutableList.of((Object)"c", (Object)"cc", (Object)"cpp", (Object)"cxx", (Object)"c++", (Object)"h", (Object)"hh", (Object)"hpp", (Object)"hxx", (Object)"h++");
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).anyMatch(file -> {
            String extension = file.getExtension();
            return extension != null && nativeExtensions.contains((Object)StringUtil.toLowerCase((String)extension));
        });
    }

    public int getNativeAllocationsMemorySamplingRate() {
        if (this.getFeatureConfig().isTaskBasedUxEnabled()) {
            CpuProfilerConfigsState configsState = CpuProfilerConfigsState.getInstance(this.myProject);
            return configsState.getNativeAllocationsConfigForTaskConfig().getSamplingRateBytes();
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
        if (settings != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            AndroidRunConfigurationBase runConfig = (AndroidRunConfigurationBase)settings.getConfiguration();
            return runConfig.getProfilerState().NATIVE_MEMORY_SAMPLE_RATE_BYTES;
        }
        return 2048;
    }

    public void showNotification(@NotNull Notification notification) {
        NotificationType type = null;
        switch (notification.getSeverity()) {
            case INFO: {
                type = NotificationType.INFORMATION;
                break;
            }
            case WARNING: {
                type = NotificationType.WARNING;
                break;
            }
            case ERROR: {
                type = NotificationType.ERROR;
            }
        }
        Notification.UrlData urlData = notification.getUrlData();
        if (urlData != null) {
            NotificationHyperlink hyperlink = new NotificationHyperlink(this, urlData.getUrl(), urlData.getText()){

                protected void execute(@NotNull Project project) {
                    BrowserUtil.browse((String)this.getUrl());
                }
            };
            AndroidNotification.getInstance((Project)this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, false, new NotificationHyperlink[]{hyperlink});
        } else {
            AndroidNotification.getInstance((Project)this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, new NotificationHyperlink[0]);
        }
    }

    @NotNull
    public TraceProcessorService getTraceProcessorService() {
        return TraceProcessorServiceImpl.getInstance();
    }

    public void buildAndLaunchAction(boolean profileableMode, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ProcessListModel.ProfilerDeviceSelection device2) {
        ProfilerBuildAndLaunch.buildAndLaunchAction(this.myProject, profileableMode, device2);
    }

    @VisibleForTesting
    public static class FeatureConfigProd
    implements FeatureConfig {
        public boolean isMemoryCSVExportEnabled() {
            return (Boolean)StudioFlags.PROFILER_MEMORY_CSV_EXPORT.get();
        }

        public boolean isPerformanceMonitoringEnabled() {
            return (Boolean)StudioFlags.PROFILER_PERFORMANCE_MONITORING.get();
        }

        public boolean isTestingModeEnabled() {
            return (Boolean)StudioFlags.PROFILER_TESTING_MODE.get();
        }

        public PowerProfilerDisplayMode getSystemTracePowerProfilerDisplayMode() {
            return (PowerProfilerDisplayMode)StudioFlags.PROFILER_SYSTEM_TRACE_POWER_PROFILER_DISPLAY_MODE.get();
        }

        public boolean isTaskBasedUxEnabled() {
            return (Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get();
        }

        public boolean isTraceboxEnabled() {
            return (Boolean)StudioFlags.PROFILER_TRACEBOX.get();
        }

        public boolean isLeakCanaryEnabled() {
            return (Boolean)StudioFlags.PROFILER_LEAKCANARY.get();
        }

        public boolean isLeakCanaryMilestone2Enabled() {
            return (Boolean)StudioFlags.PROFILER_LEAKCANARY_MILESTONE2.get();
        }

        public boolean isTaskTitleV2Enabled() {
            return (Boolean)StudioFlags.PROFILER_TASK_TITLE_V2.get();
        }
    }
}

