/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.sdk.LoadStatus;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.device.FormFactor;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBox;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.stats.DistributionService;
import com.android.tools.idea.ui.ChooseApiLevelDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFactorSdkControls
implements Disposable {
    private final BindingsManager myBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();
    private final AndroidVersionsInfo myAndroidVersionsInfo = new AndroidVersionsInfo();
    private LoadStatus mySdkDataLoadingStatus;
    private LoadStatus myStatsDataLoadingStatus;
    private JPanel myStatsPanel;
    private JBLabel myApiPercentIcon;
    private JBLabel myApiPercentLabel;
    private HyperlinkLabel myLearnMoreLink;
    private JPanel myLoadingDataPanel;
    private AsyncProcessIcon myLoadingDataIcon;
    private JLabel myLoadingDataLabel;
    private final AndroidApiLevelComboBox myMinSdkCombobox = new AndroidApiLevelComboBox();
    private JPanel myRoot;

    public FormFactorSdkControls() {
        this.setupUI();
    }

    public void init(OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo, Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myBindings.bind(androidSdkInfo, new SelectedItemProperty(this.myMinSdkCombobox));
        this.myListeners.listen(androidSdkInfo, value2 -> value2.ifPresent(item -> this.updateApiPercentLabel((AndroidVersionsInfo.VersionItem)item)));
        this.myLoadingDataLabel.setForeground((Color)JBColor.GRAY);
        this.myApiPercentIcon.setIcon(AllIcons.General.BalloonInformation);
        this.myLearnMoreLink.setHyperlinkText(AndroidBundle.message("android.wizard.module.help.choose", new Object[0]));
        this.myLearnMoreLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                int minApiLevel = FormFactorSdkControls.this.getSelectedApiLevel().getMinApiLevel();
                ChooseApiLevelDialog chooseApiLevelDialog = new ChooseApiLevelDialog(null, minApiLevel);
                Disposer.register((Disposable)FormFactorSdkControls.this, (Disposable)chooseApiLevelDialog.getDisposable());
                if (!chooseApiLevelDialog.showAndGet()) {
                    return;
                }
                int selectedApiLevel = chooseApiLevelDialog.getSelectedApiLevel();
                for (int i = 0; i < FormFactorSdkControls.this.myMinSdkCombobox.getItemCount(); ++i) {
                    AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)FormFactorSdkControls.this.myMinSdkCombobox.getItemAt(i);
                    if (item.getMinApiLevel() != selectedApiLevel) continue;
                    FormFactorSdkControls.this.myMinSdkCombobox.setSelectedItem(item);
                    break;
                }
            }
        });
    }

    @NotNull
    public AndroidApiLevelComboBox getMinSdkComboBox() {
        return this.myMinSdkCombobox;
    }

    @NotNull
    public JPanel getRoot() {
        return this.myRoot;
    }

    public void showStatsPanel(boolean show2) {
        this.myStatsPanel.setVisible(show2);
    }

    public void startDataLoading(FormFactor formFactor, int minSdk) {
        this.mySdkDataLoadingStatus = LoadStatus.LOADING;
        this.myStatsDataLoadingStatus = this.myStatsPanel.isVisible() ? LoadStatus.LOADING : LoadStatus.LOADED;
        this.updateLoadingProgress();
        this.myMinSdkCombobox.init(formFactor, this.myAndroidVersionsInfo.getKnownTargetVersions(formFactor, minSdk).stream().filter(it -> !it.isPreview()).toList());
        this.mySdkDataLoadingStatus = LoadStatus.LOADED;
        this.updateLoadingProgress();
        if (this.myStatsPanel.isVisible()) {
            DistributionService.getInstance().refresh(() -> ApplicationManager.getApplication().invokeLater(() -> {
                this.myStatsDataLoadingStatus = LoadStatus.LOADED;
                this.updateLoadingProgress();
            }, ModalityState.any()), () -> ApplicationManager.getApplication().invokeLater(() -> {
                this.myStatsDataLoadingStatus = LoadStatus.FAILED;
                this.updateLoadingProgress();
            }, ModalityState.any()), false);
        }
    }

    public Collection<? extends UpdatablePackage> getSdkInstallPackageList() {
        return this.myAndroidVersionsInfo.loadInstallPackageList(Collections.singletonList(this.getSelectedApiLevel()));
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private void createUIComponents() {
        this.myLoadingDataIcon = new AsyncProcessIcon(AndroidBundle.message("android.wizard.module.help.loading", new Object[0]));
    }

    private void updateLoadingProgress() {
        this.myLoadingDataPanel.setVisible(this.mySdkDataLoadingStatus != LoadStatus.LOADED || this.myStatsDataLoadingStatus != LoadStatus.LOADED);
        this.myLoadingDataIcon.setVisible(this.mySdkDataLoadingStatus == LoadStatus.LOADING || this.myStatsDataLoadingStatus == LoadStatus.LOADING);
        if (this.mySdkDataLoadingStatus == LoadStatus.LOADING) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.project.loading.sdks", new Object[0]));
        } else if (this.myStatsDataLoadingStatus == LoadStatus.LOADING) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.module.help.refreshing", new Object[0]));
        } else if (this.myStatsDataLoadingStatus == LoadStatus.LOADED) {
            AndroidVersionsInfo.VersionItem currentVersionItem = this.getSelectedApiLevel();
            if (currentVersionItem != null) {
                this.updateApiPercentLabel(currentVersionItem);
            }
        } else if (this.myStatsDataLoadingStatus == LoadStatus.FAILED) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.project.loading.stats.fail", new Object[0]));
        }
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRoot = new JPanel();
        this.myRoot.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myStatsPanel = new JPanel();
        this.myStatsPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 4, -1));
        this.myRoot.add((Component)this.myStatsPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.myApiPercentIcon = new JBLabel();
        this.myApiPercentIcon.setText("");
        this.myStatsPanel.add((Component)this.myApiPercentIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myApiPercentLabel = new JBLabel();
        this.myApiPercentLabel.setText("API level percentage");
        this.myStatsPanel.add((Component)this.myApiPercentLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, null, null, 0, false));
        this.myLearnMoreLink = new HyperlinkLabel();
        Font myLearnMoreLinkFont = this.getFont(null, -1, 11, this.myLearnMoreLink.getFont());
        if (myLearnMoreLinkFont != null) {
            this.myLearnMoreLink.setFont(myLearnMoreLinkFont);
        }
        this.myLearnMoreLink.setOpaque(true);
        this.myLearnMoreLink.setText("");
        this.myLearnMoreLink.setVisible(true);
        this.myStatsPanel.add((Component)this.myLearnMoreLink, new GridConstraints(1, 1, 1, 1, 8, 0, 5, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRoot.add((Component)spacer1, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myLoadingDataPanel = new JPanel();
        this.myLoadingDataPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myRoot.add((Component)this.myLoadingDataPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 3, null, null, null, 0, false));
        this.myLoadingDataPanel.add((Component)this.myLoadingDataIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myLoadingDataLabel = new JBLabel();
        this.myLoadingDataLabel.setText("(loading SDK Data and Stats)");
        this.myLoadingDataPanel.add((Component)this.myLoadingDataLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRoot.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 12), null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    @Slow
    private static String getApiHelpText(int selectedApi) {
        double percentage = DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0;
        String percentageStr = percentage < 1.0 ? "<b>&lt; 1%</b>" : String.format("approximately <b>" + (percentage >= 10.0 ? "%.3g%%" : "%.2g%%") + "</b>", percentage);
        return String.format("<html>Your app will run on %1$s of devices.</html>", percentageStr);
    }

    private void updateApiPercentLabel(AndroidVersionsInfo.VersionItem item) {
        CompletableFuture.supplyAsync(() -> FormFactorSdkControls.getApiHelpText(item.getMinApiLevel()), AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(text2 -> this.myApiPercentLabel.setText(text2), (Executor)EdtExecutorService.getInstance());
    }

    @Nullable
    AndroidVersionsInfo.VersionItem getSelectedApiLevel() {
        return (AndroidVersionsInfo.VersionItem)this.myMinSdkCombobox.getSelectedItem();
    }
}

