/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.gradle.project.GradleVersionCatalogDetector;
import com.android.tools.idea.gradle.util.KotlinGradleProjectSystemUtil;
import com.android.tools.idea.npw.project.SourceProviderAdapter;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersion;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\"\u000e\u0010\u0013\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"getSourceProvider", "Lcom/android/tools/idea/npw/project/SourceProviderAdapter;", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "getContainingModule", "Lcom/intellij/openapi/module/Module;", "file", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "setGradleWrapperExecutable", "", "projectRoot", "determineKotlinVersionOrDefault", "", "isNewProject", "", "determineKotlinVersion", "Lorg/jetbrains/kotlin/idea/gradleTooling/KotlinGradlePluginVersion;", "determineVersionCatalogUse", "DEFAULT_KOTLIN_VERSION_FOR_NEW_PROJECTS", "intellij.android.newProjectWizard"})
@JvmName(name="AndroidGradleModuleUtils")
@SourceDebugExtension(value={"SMAP\nAndroidGradleModuleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidGradleModuleUtils.kt\ncom/android/tools/idea/npw/project/AndroidGradleModuleUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class AndroidGradleModuleUtils {
    @NotNull
    public static final String DEFAULT_KOTLIN_VERSION_FOR_NEW_PROJECTS = "2.0.21";

    @NotNull
    public static final SourceProviderAdapter getSourceProvider(@NotNull NamedModuleTemplate $this$getSourceProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getSourceProvider, (String)"<this>");
        return new SourceProviderAdapter($this$getSourceProvider.getName(), $this$getSourceProvider.getPaths());
    }

    @Nullable
    public static final Module getContainingModule(@Nullable File file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        File file2 = file;
        Intrinsics.checkNotNull((Object)file2);
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        return vFile == null || vFile.isDirectory() ? null : ProjectFileIndex.getInstance((Project)project).getModuleForFile(vFile, false);
    }

    public static final void setGradleWrapperExecutable(@NotNull File projectRoot) throws IOException {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        if (!SystemInfo.isUnix) {
            return;
        }
        File gradlewFile = new File(projectRoot, "gradlew");
        if (!gradlewFile.isFile()) {
            throw new IOException("Could not find gradle wrapper. Command line builds may not work properly.");
        }
        FileUtil.setExecutable((File)gradlewFile);
    }

    @Slow
    @NotNull
    public static final String determineKotlinVersionOrDefault(@NotNull Project project, boolean isNewProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (isNewProject) {
            return DEFAULT_KOTLIN_VERSION_FOR_NEW_PROJECTS;
        }
        KotlinGradlePluginVersion versionInUse = AndroidGradleModuleUtils.determineKotlinVersion(project);
        Object object = versionInUse;
        if (object == null || (object = object.toString()) == null) {
            object = DEFAULT_KOTLIN_VERSION_FOR_NEW_PROJECTS;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Slow
    @Nullable
    public static final KotlinGradlePluginVersion determineKotlinVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) return null;
        String it = string;
        boolean bl = false;
        List<KotlinGradlePluginVersion> list2 = KotlinGradleProjectSystemUtil.INSTANCE.getKotlinVersionsInUse(project, it);
        if (list2 == null) return null;
        KotlinGradlePluginVersion kotlinGradlePluginVersion = (KotlinGradlePluginVersion)CollectionsKt.firstOrNull(list2);
        return kotlinGradlePluginVersion;
    }

    @Slow
    public static final boolean determineVersionCatalogUse(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradleVersionCatalogDetector.Companion.getInstance(project).isVersionCatalogProject();
    }
}

