/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module.recipes.kotlinMultiplatformLibrary;

import com.android.ide.common.repository.AgpVersion;
import com.android.sdklib.AndroidMajorVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.npw.module.recipes.SharedMacrosKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u00a8\u0006\f"}, d2={"buildKmpGradle", "", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "name", "packageName", "compileApi", "Lcom/android/sdklib/AndroidVersion;", "minApi", "Lcom/android/sdklib/AndroidMajorVersion;", "androidTargetConfig", "iosTargetConfig", "intellij.android.newProjectWizard"})
public final class BuildGradleKt {
    @NotNull
    public static final String buildKmpGradle(@NotNull AgpVersion agpVersion, @NotNull String name2, @NotNull String packageName, @NotNull AndroidVersion compileApi, @NotNull AndroidMajorVersion minApi) {
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)compileApi, (String)"compileApi");
        Intrinsics.checkNotNullParameter((Object)minApi, (String)"minApi");
        String androidTargetBlock = BuildGradleKt.androidTargetConfig(agpVersion, packageName, compileApi, minApi);
        String iosTargetBlock = BuildGradleKt.iosTargetConfig(name2);
        String sourceSetConfigurationsBlock = "\n      // Source set declarations.\n      // Declaring a target automatically creates a source set with the same name. By default, the\n      // Kotlin Gradle Plugin creates additional source sets that depend on each other, since it is\n      // common to share sources between related targets.\n      // See: https://kotlinlang.org/docs/multiplatform-hierarchy.html\n    sourceSets {\n      commonMain {\n        dependencies {\n          // Add KMP dependencies here\n        }\n      }\n\n      commonTest {\n        dependencies {\n        }\n      }\n\n      androidMain {\n        dependencies {\n          // Add Android-specific dependencies here. Note that this source set depends on\n          // commonMain by default and will correctly pull the Android artifacts of any KMP\n          // dependencies declared in commonMain.\n        }\n      }\n\n      getByName(\"androidDeviceTest\") {\n        dependencies {\n        }\n      }\n\n      iosMain {\n        dependencies {\n          // Add iOS-specific dependencies here. This a source set created by Kotlin Gradle\n          // Plugin (KGP) that each specific iOS target (e.g., iosX64) depends on as\n          // part of KMP\u2019s default source set hierarchy. Note that this source set depends\n          // on common by default and will correctly pull the iOS artifacts of any\n          // KMP dependencies declared in commonMain.\n        }\n      }\n    }\n  ";
        String kotlinBlock = StringsKt.trimIndent((String)("\n    kotlin {\n      " + androidTargetBlock + "\n      " + iosTargetBlock + "\n      " + sourceSetConfigurationsBlock + "\n    }\n  "));
        String allBlocks = "\n    " + SharedMacrosKt.emptyPluginsBlock() + "\n    " + kotlinBlock + "\n    ";
        return com.android.tools.idea.npw.module.recipes.androidModule.BuildGradleKt.gradleToKtsIfKts(allBlocks, true);
    }

    private static final String androidTargetConfig(AgpVersion agpVersion, String packageName, AndroidVersion compileApi, AndroidMajorVersion minApi) {
        return "\n      // Target declarations - add or remove as needed below. These define\n      // which platforms this KMP module supports.\n      // See: https://kotlinlang.org/docs/multiplatform-discover-project.html#targets\n    androidLibrary {\n      namespace '" + packageName + "'\n      " + SharedMacrosKt.compileSdk(compileApi, agpVersion) + "\n      " + SharedMacrosKt.minSdk(minApi, agpVersion) + "\n\n      withHostTestBuilder {\n      }\n\n      withDeviceTestBuilder {\n          sourceSetTreeName = \"test\"\n      }.configure {\n        instrumentationRunner = \"androidx.test.runner.AndroidJUnitRunner\"\n      }\n    }\n";
    }

    private static final String iosTargetConfig(String name2) {
        return "\n      // For iOS targets, this is also where you should\n      // configure native binary output. For more information, see:\n      // https://kotlinlang.org/docs/multiplatform-build-native-binaries.html#build-xcframeworks\n\n      // A step-by-step guide on how to include this library in an XCode\n      // project can be found here:\n      // https://developer.android.com/kotlin/multiplatform/migrate\n    val xcfName = \"" + name2 + "Kit\"\n\n    iosX64 {\n      binaries.framework {\n        baseName = xcfName\n      }\n    }\n\n    iosArm64 {\n      binaries.framework {\n        baseName = xcfName\n      }\n    }\n\n    iosSimulatorArm64 {\n      binaries.framework {\n        baseName = xcfName\n      }\n    }\n  ";
    }
}

