/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.TvChannelIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.utils.Pair;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class TvChannelPreviewPanel
extends PreviewIconsPanel {
    TvChannelPreviewPanel() {
        super("", PreviewIconsPanel.Theme.TRANSPARENT);
    }

    @Override
    public void showPreviewImages(@NotNull IconGeneratorResult result2) {
        Collection<GeneratedIcon> generatedIcons = result2.getIcons();
        List<Pair<String, BufferedImage>> list2 = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> this.filterPreviewIcon((GeneratedImageIcon)icon, ((TvChannelIconGenerator.TvChannelIconOptions)result2.getOptions()).previewDensity)).map(icon -> Pair.of((Object)((Object)TvChannelPreviewPanel.getPreviewShapeFromId(icon.getName())), (Object)icon.getImage())).sorted((pair1, pair2) -> TvChannelPreviewPanel.comparePreviewShapes((TvChannelIconGenerator.PreviewShape)((Object)((Object)pair1.getFirst())), (TvChannelIconGenerator.PreviewShape)((Object)((Object)pair2.getFirst())))).map(pair -> Pair.of((Object)((TvChannelIconGenerator.PreviewShape)((Object)((Object)pair.getFirst()))).displayName, (Object)((BufferedImage)pair.getSecond()))).collect(Collectors.toList());
        this.showPreviewImagesImpl(list2);
    }

    protected boolean filterPreviewIcon(@NotNull GeneratedImageIcon icon, @NotNull Density density) {
        return icon.getCategory() == IconCategory.PREVIEW && icon.getDensity() == density;
    }

    private static int comparePreviewShapes(@NotNull TvChannelIconGenerator.PreviewShape x, @NotNull TvChannelIconGenerator.PreviewShape y) {
        return Integer.compare(TvChannelPreviewPanel.getPreviewShapeDisplayOrder(x), TvChannelPreviewPanel.getPreviewShapeDisplayOrder(y));
    }

    private static int getPreviewShapeDisplayOrder(@NotNull TvChannelIconGenerator.PreviewShape previewShape) {
        switch (previewShape) {
            case ADAPTIVE: {
                return 1;
            }
            case LEGACY: {
                return 2;
            }
        }
        return 1000;
    }

    @NotNull
    private static TvChannelIconGenerator.PreviewShape getPreviewShapeFromId(@NotNull String previewShapeId) {
        for (TvChannelIconGenerator.PreviewShape shape : TvChannelIconGenerator.PreviewShape.values()) {
            if (!Objects.equals(shape.id, previewShapeId)) continue;
            return shape;
        }
        return TvChannelIconGenerator.PreviewShape.NONE;
    }
}

