/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAsset
implements PersistentStateComponent<PersistentState> {
    private static final String TRIMMED_PROPERTY = "trimmed";
    private static final String PADDING_PERCENT_PROPERTY = "paddingPercent";
    private static final String SCALING_PERCENT_PROPERTY = "scalingPercent";
    private static final String COLOR_PROPERTY = "color";
    private static final String OPACITY_PERCENT_PROPERTY = "opacityPercent";
    private final BoolProperty myTrimmed = new BoolValueProperty();
    private final IntProperty myPaddingPercent = new IntValueProperty(0);
    private final IntProperty myScalingPercent = new IntValueProperty(100);
    private final OptionalValueProperty<Color> myColor = new OptionalValueProperty();
    private final IntProperty myOpacityPercent = new IntValueProperty(100);

    @NotNull
    public BoolProperty trimmed() {
        return this.myTrimmed;
    }

    @NotNull
    public IntProperty paddingPercent() {
        return this.myPaddingPercent;
    }

    @NotNull
    public IntProperty scalingPercent() {
        return this.myScalingPercent;
    }

    @NotNull
    public OptionalValueProperty<Color> color() {
        return this.myColor;
    }

    public boolean isColorable() {
        return true;
    }

    @NotNull
    public IntProperty opacityPercent() {
        return this.myOpacityPercent;
    }

    @NotNull
    public ObservableBool isResizable() {
        return ObservableBool.TRUE;
    }

    @Nullable
    public abstract ListenableFuture<BufferedImage> toImage();

    @UiThread
    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.set(TRIMMED_PROPERTY, (Boolean)this.myTrimmed.get(), false);
        state2.set(PADDING_PERCENT_PROPERTY, (Integer)this.myPaddingPercent.get(), 0);
        state2.set(SCALING_PERCENT_PROPERTY, (Integer)this.myScalingPercent.get(), 100);
        state2.setEncoded(COLOR_PROPERTY, (Color)this.myColor.getValueOrNull(), color -> ColorUtil.toHex((Color)color));
        state2.set(OPACITY_PERCENT_PROPERTY, (Integer)this.myOpacityPercent.get(), 100);
        return state2;
    }

    @UiThread
    public void loadState(@NotNull PersistentState state2) {
        this.myTrimmed.set(state2.get(TRIMMED_PROPERTY, false));
        this.myPaddingPercent.set(state2.get(PADDING_PERCENT_PROPERTY, 0));
        this.myScalingPercent.set(state2.get(SCALING_PERCENT_PROPERTY, 100));
        Color color = (Color)state2.getDecoded(COLOR_PROPERTY, rgb -> ColorUtil.fromHex((String)rgb));
        if (color != null) {
            this.myColor.setValue(color);
        }
        this.myOpacityPercent.set(state2.get(OPACITY_PERCENT_PROPERTY, 100));
    }
}

