/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.intellij.openapi.project.Project;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VectorIconGenerator
extends IconGenerator {
    public VectorIconGenerator(@NotNull Project project, int minSdkVersion2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, null));
    }

    @Override
    @NotNull
    public VectorIconOptions createOptions(boolean forPreview) {
        VectorIconOptions options = new VectorIconOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options.density = Density.ANYDPI;
        return options;
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        BufferedImage image = VectorIconGenerator.getTrimmedAndPaddedImage(options);
        if (image == null) {
            return PLACEHOLDER_IMAGE;
        }
        return new AnnotatedImage(image, null);
    }

    @Nullable
    private static BufferedImage getTrimmedAndPaddedImage(@NotNull IconGenerator.IconOptions options) {
        if (options.sourceImageFuture == null) {
            return null;
        }
        try {
            BufferedImage image = (BufferedImage)options.sourceImageFuture.get();
            if (image != null) {
                if (options.isTrimmed) {
                    image = AssetStudioUtils.trim(image);
                }
                if (options.paddingPercent != 0) {
                    image = AssetStudioUtils.pad(image, options.paddingPercent);
                }
            }
            return image;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name2) {
        VectorAsset vectorAsset = (VectorAsset)this.sourceAsset().getValue();
        VectorAsset.Preview result2 = vectorAsset.generatePreview();
        if (!result2.isValid()) {
            return Collections.emptySet();
        }
        String xmlContent = result2.getXmlContent();
        assert (xmlContent != null);
        GeneratedXmlResource icon = new GeneratedXmlResource(name2, new PathString(this.getIconPath(options, name2)), IconCategory.XML_RESOURCE, xmlContent);
        return Collections.singleton(icon);
    }

    public static class VectorIconOptions
    extends IconGenerator.IconOptions {
        public VectorIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
        }
    }
}

