/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.npw.assetstudio.ProportionalImageScalerKt;
import com.intellij.util.ui.JBUI;
import java.awt.Image;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler;", "", "minHeight", "", "maxHeight", "<init>", "(II)V", "scale", "Ljava/awt/Image;", "image", "maxAllowedHeight", "Companion", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=1)
public final class ProportionalImageScaler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minHeight;
    private final int maxHeight;
    public static final int $stable;

    private ProportionalImageScaler(int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @NotNull
    public final Image scale(@NotNull Image image, int maxAllowedHeight) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (maxAllowedHeight < 0) {
            throw new IllegalArgumentException("Height constraint " + maxAllowedHeight + " is invalid because image heights can't be negative.");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (height == 0 || this.maxHeight < maxAllowedHeight) {
            return image;
        }
        double scaleFactor = ProportionalImageScalerKt.determineScaleFactor(height, this.minHeight, this.maxHeight, maxAllowedHeight);
        int newWidth = (int)JBUI.scale((float)((float)((double)width * scaleFactor)));
        int newHeight = (int)JBUI.scale((float)((float)((double)height * scaleFactor)));
        Image image2 = image.getScaledInstance(newWidth, newHeight, 4);
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"getScaledInstance(...)");
        return image2;
    }

    @JvmStatic
    @NotNull
    public static final ProportionalImageScaler forImages(@NotNull Collection<? extends Image> images) {
        return Companion.forImages(images);
    }

    public /* synthetic */ ProportionalImageScaler(int minHeight, int maxHeight, DefaultConstructorMarker $constructor_marker) {
        this(minHeight, maxHeight);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler$Companion;", "", "<init>", "()V", "forImages", "Lcom/android/tools/idea/npw/assetstudio/ProportionalImageScaler;", "images", "", "Ljava/awt/Image;", "intellij.android.newProjectWizard"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProportionalImageScaler forImages(@NotNull Collection<? extends Image> images) {
            Intrinsics.checkNotNullParameter(images, (String)"images");
            int minHeight = Integer.MAX_VALUE;
            int maxHeight = 0;
            for (Image image : images) {
                int height = image.getHeight(null);
                minHeight = Math.min(minHeight, height);
                maxHeight = Math.max(maxHeight, height);
            }
            return new ProportionalImageScaler(minHeight, maxHeight, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

