/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialDesignIcons {
    private static final String DEFAULT_ICON_NAME = "/action/ic_android_black_24dp.xml";
    private static final String PATH = "images/material_design_icons";
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("images/material_design_icons/(\\w+)/");

    private MaterialDesignIcons() {
    }

    @Nullable
    public static String getPathForBasename(@NotNull String basename) {
        return MaterialDesignIcons.getBasenameToPathMap(path -> BuiltInImages.getResourcesNames(path, ".xml")).get(basename);
    }

    @NotNull
    @VisibleForTesting
    public static Map<String, String> getBasenameToPathMap(@NotNull Function<String, List<String>> generator) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int dotXmlLength = ".xml".length();
        for (String category : MaterialDesignIcons.getCategories()) {
            String path = "images/material_design_icons/" + category;
            for (String name2 : generator.apply(path)) {
                builder.put((Object)name2.substring(0, name2.length() - dotXmlLength), (Object)(path + "/" + name2));
            }
        }
        return builder.build();
    }

    @NotNull
    private static Collection<String> getCategories() {
        return MaterialDesignIcons.getCategories(MaterialDesignIcons.getResourceUrl(PATH));
    }

    @NotNull
    public static URL getIcon(@NotNull String iconName, @NotNull String categoryName) {
        return MaterialDesignIcons.getResourceUrl(MaterialDesignIcons.getIconDirectoryPath(categoryName) + iconName);
    }

    @NotNull
    public static URL getDefaultIcon() {
        URL url = MaterialDesignIcons.getResourceUrl("images/material_design_icons/action/ic_android_black_24dp.xml");
        assert (url != null);
        return url;
    }

    @VisibleForTesting
    public static Collection<String> getCategories(@Nullable URL url) {
        if (url == null) {
            return Collections.emptyList();
        }
        switch (url.getProtocol()) {
            case "file": {
                return MaterialDesignIcons.getCategoriesFromFile(new File(url.getPath()));
            }
            case "jar": {
                Collection<String> collection2;
                String jarPath = BuiltInImages.getJarFilePath(url);
                ZipFile jarFile = new ZipFile(jarPath);
                try {
                    collection2 = MaterialDesignIcons.getCategoriesFromJar(jarFile);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return Collections.emptyList();
                    }
                }
                jarFile.close();
                return collection2;
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    @VisibleForTesting
    public static Collection<String> getCategoriesFromFile(@NotNull File file) {
        String[] array = file.list();
        if (array == null) {
            return Collections.emptyList();
        }
        List<String> list2 = Arrays.asList(array);
        list2.sort(String::compareTo);
        return list2;
    }

    @NotNull
    @VisibleForTesting
    public static Collection<String> getCategoriesFromJar(@NotNull ZipFile jar) {
        return jar.stream().map(MaterialDesignIcons::getCategory).filter(Objects::nonNull).sorted().collect(Collectors.toList());
    }

    @Nullable
    private static String getCategory(@NotNull ZipEntry entry) {
        Matcher matcher = CATEGORY_PATTERN.matcher(entry.getName());
        return matcher.matches() ? matcher.group(1) : null;
    }

    @NotNull
    private static String getIconDirectoryPath(String categoryName) {
        return PATH + StringUtil.toLowerCase((String)categoryName) + "/";
    }

    private static URL getResourceUrl(String iconPath) {
        return MaterialDesignIcons.class.getClassLoader().getResource(iconPath);
    }
}

