/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.assetstudio.AdaptiveIconGenerator;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioWizardTracker;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherIconGenerator
extends AdaptiveIconGenerator {
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX = new Rectangle(0, 0, 768, 768);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX = new Rectangle(0, 0, 528, 529);
    private static final Rectangle IMAGE_SIZE_TARGET_PLAY_STORE_PX = new Rectangle(8, 4, 528, 529);
    private final BoolProperty myGenerateRoundIcon = new BoolValueProperty(true);
    private final BoolProperty myGeneratePlayStoreIcon = new BoolValueProperty(true);
    private final BoolProperty myGenerateWebpIcons = new BoolValueProperty(true);
    private final ObjectProperty<IconGenerator.Shape> myLegacyIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
    private final BoolProperty myShowGrid = new BoolValueProperty();
    private final ObjectValueProperty<Density> myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);

    public LauncherIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2, AssetStudioWizardTracker assetStudioWizardTracker) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2), assetStudioWizardTracker);
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        return this.myGenerateRoundIcon;
    }

    @NotNull
    public BoolProperty generatePlayStoreIcon() {
        return this.myGeneratePlayStoreIcon;
    }

    @NotNull
    public BoolProperty generateWebpIcons() {
        return this.myGenerateWebpIcons;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> legacyIconShape() {
        return this.myLegacyIconShape;
    }

    @NotNull
    public BoolProperty showGrid() {
        return this.myShowGrid;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        return this.myPreviewDensity;
    }

    @Override
    @NotNull
    public LauncherIconOptions createOptions(boolean forPreview) {
        BaseAsset monochromeAsset;
        ImageAsset backgroundAsset;
        LauncherIconOptions options = new LauncherIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options.foregroundColor = color.getRGB();
            }
            options.foregroundImage = this.createAndTransformAsset(foregroundAsset, color);
        }
        if ((backgroundAsset = this.backgroundImageAsset().getValueOrNull()) != null) {
            double scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        if ((monochromeAsset = this.monochromeImageAsset().getValueOrNull()) != null) {
            Color color;
            options.useMonochromeColor = monochromeAsset.isColorable();
            Color color3 = color = monochromeAsset.isColorable() ? (Color)monochromeAsset.color().getValueOrNull() : null;
            if (color != null) {
                options.monochromeColor = color.getRGB();
            }
            options.monochromeImage = this.createAndTransformAsset(monochromeAsset, color);
            if (!forPreview && this.myAssetStudioWizardTracker != null) {
                this.myAssetStudioWizardTracker.logMonochromeIconGenerated();
            }
        }
        options.backgroundColor = ((Color)this.backgroundColor().get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.showSafeZone().get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.foregroundLayerName().get();
        options.monochromeLayerName = (String)this.monochromeLayerName().get();
        options.backgroundLayerName = (String)this.backgroundLayerName().get();
        options.generateLegacyIcon = (Boolean)this.generateLegacyIcon().get();
        options.legacyIconShape = (IconGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generatePlayStoreIcon = (Boolean)this.myGeneratePlayStoreIcon.get();
        options.generateWebpIcons = (Boolean)this.myGenerateWebpIcons.get();
        return options;
    }

    private TransformedImageAsset createAndTransformAsset(BaseAsset asset, Color color) {
        double scaleFactor = (double)((Integer)asset.scalingPercent().get()).intValue() / 100.0;
        if (asset instanceof ImageAsset && ((ImageAsset)asset).isClipart()) {
            scaleFactor *= 0.58;
        } else if (asset instanceof TextAsset) {
            scaleFactor *= 0.46;
        } else if (((Boolean)asset.trimmed().get()).booleanValue()) {
            scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
        }
        return new TransformedImageAsset(asset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext(), this.myLineSeparator);
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name2) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name2, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name2, launcherIconOptions, tasks);
        this.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name2, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            LauncherIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name2, localOptions, density, tasks);
        }
        if (options.generatePlayStoreIcon) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generatePlayStoreIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = IconGenerator.Shape.NONE;
                AnnotatedImage image = this.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name2, new PathString(this.getIconPath(localOptions, name2)), IconCategory.PLAY_STORE, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name2, @NotNull LauncherIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions foregroundOptions = options.clone();
                foregroundOptions.generatePlayStoreIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions backgroundOptions = options.clone();
                backgroundOptions.generatePlayStoreIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.monochromeImage != null && options.monochromeImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions monochromeOptions = options.clone();
                monochromeOptions.generatePlayStoreIcon = false;
                monochromeOptions.generatePreviewIcons = false;
                monochromeOptions.generateOutputIcons = true;
                AnnotatedImage monochromeImage = this.generateIconMonochromeLayer(context, monochromeOptions);
                return new GeneratedImageIcon(monochromeOptions.monochromeLayerName, new PathString(this.getIconPath(monochromeOptions, options.monochromeLayerName)), IconCategory.ADAPTIVE_MONOCHROME_LAYER, density, monochromeImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                AnnotatedImage legacy = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name2, new PathString(this.getIconPath(legacyOptions, name2)), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generatePlayStoreIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = IconGenerator.Shape.CIRCLE;
                AnnotatedImage legacyRound = this.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name2 + "_round", new PathString(this.getIconPath(legacyOptions, name2 + "_round")), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name2, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (!options.generateOutputIcons) {
            return;
        }
        LauncherIconOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.generatePlayStoreIcon = false;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, name2)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (iconOptions.generateRoundIcon) {
            tasks.add(() -> {
                String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
                return new GeneratedXmlResource(name2 + "_round", new PathString(this.getIconPath(iconOptions, name2 + "_round")), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
            });
        }
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            image = options.foregroundImage;
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                return this.createDrawableXml(name2, iconOptions, image, "foreground", iconOptions.foregroundLayerName, IconCategory.ADAPTIVE_FOREGROUND_LAYER);
            });
        }
        if (options.monochromeImage != null && options.monochromeImage.isDrawable()) {
            image = options.monochromeImage;
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                return this.createDrawableXml(name2, iconOptions, image, "monochrome", iconOptions.monochromeLayerName, IconCategory.ADAPTIVE_MONOCHROME_LAYER);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            image = options.backgroundImage;
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                return this.createDrawableXml(name2, iconOptions, image, "background", iconOptions.backgroundLayerName, IconCategory.ADAPTIVE_BACKGROUND_LAYER);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generatePlayStoreIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private GeneratedXmlResource createDrawableXml(@NotNull String name2, LauncherIconOptions iconOptions, TransformedImageAsset image, String imageType, String layerName, IconCategory foregroundIconCategory) {
        String xmlDrawableText;
        iconOptions.generatePlayStoreIcon = false;
        iconOptions.density = Density.ANYDPI;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
        if (!image.isDrawable()) {
            LauncherIconGenerator.getLog().error(StringUtil.capitalize((String)imageType) + " image is not drawable!", new Throwable());
        }
        if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
            LauncherIconGenerator.getLog().error("Transformed " + imageType + " drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
            xmlDrawableText = "<vector/>";
        }
        iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
        return new GeneratedXmlResource(name2, new PathString(this.getIconPath(iconOptions, layerName)), foregroundIconCategory, xmlDrawableText);
    }

    private void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.MONOCHROME_CIRCLE);
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generatePlayStoreIcon) {
            previewShapes.add(PreviewShape.PLAY_STORE);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                AnnotatedImage image;
                LauncherIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generatePlayStoreIcon = previewShape == PreviewShape.PLAY_STORE;
                try {
                    image = this.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    LauncherIconGenerator.getLog().error(e);
                    image = LauncherIconGenerator.createPlaceholderErrorImage(e, localOptions);
                }
                return new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, AnnotatedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options, @NotNull String name2) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        LauncherIconOptions localOptions = launcherIconOptions.clone();
        localOptions.generatePlayStoreIcon = false;
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name2);
        icons.stream().filter(icon -> icon instanceof GeneratedImageIcon).map(icon -> (GeneratedImageIcon)icon).filter(icon -> icon.getOutputPath() != null).forEach(icon -> {
            assert (icon.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(icon.getCategory().toString(), k -> new LinkedHashMap());
            LauncherIconOptions iconOptions = localOptions.clone();
            iconOptions.density = icon.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            iconOptions.generatePlayStoreIcon = icon.getCategory() == IconCategory.PLAY_STORE;
            imageMap.put(icon.getOutputPath().toString(), new AnnotatedImage(icon.getImage(), icon.getErrorMessage()));
        });
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return this.generatePreviewImage(context, (LauncherIconOptions)options);
    }

    @NotNull
    private AnnotatedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        switch (options.previewShape.ordinal()) {
            case 0: {
                return this.generateMonochromeViewportPreviewImage(context, options);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.generateViewportPreviewImage(context, options);
            }
            case 6: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = false;
                return this.generateLegacyImage(context, options);
            }
            case 7: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = false;
                options.legacyIconShape = IconGenerator.Shape.CIRCLE;
                return this.generateLegacyImage(context, options);
            }
            case 5: {
                AnnotatedImage annotatedImage = this.generateFullBleedPreviewImage(context, options);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(annotatedImage.getImage(), 0.8f), annotatedImage.getErrorMessage());
            }
            case 8: {
                options.generatePreviewIcons = true;
                options.generatePlayStoreIcon = true;
                options.legacyIconShape = IconGenerator.Shape.SQUARE;
                AnnotatedImage annotatedImage = this.generateLegacyImage(context, options);
                BufferedImage image = AssetUtil.trimmedImage((BufferedImage)annotatedImage.getImage());
                double scale = LauncherIconGenerator.getMdpiScaleFactor(options.previewDensity);
                return new AnnotatedImage(LauncherIconGenerator.scaledPreviewImage(image, 0.22 * scale), annotatedImage.getErrorMessage());
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private AnnotatedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, Color.BLACK);
        LauncherIconGenerator.drawGrid(options, mergedImage.getImage());
        return mergedImage;
    }

    @NotNull
    private AnnotatedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        Rectangle viewportRect = this.getViewportRectangle(options);
        Rectangle legacyRect = this.getLegacyRectangle(options);
        Density legacyOrPlayStoreDensity = options.generatePlayStoreIcon ? Density.NODPI : options.density;
        Rectangle legacyShapeRect = options.generatePlayStoreIcon ? IMAGE_SIZE_TARGET_PLAY_STORE_PX : LauncherLegacyIconGenerator.getTargetRect(options.legacyIconShape, legacyOrPlayStoreDensity);
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage fullBleed = mergedImage.getImage();
        double viewportScale = LauncherIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : LauncherIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != IconGenerator.Shape.NONE) {
            shapeImageBack = LauncherIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrPlayStoreDensity);
            shapeImageFore = LauncherIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrPlayStoreDensity, IconGenerator.Style.SIMPLE);
            shapeImageMask = LauncherIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrPlayStoreDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = LauncherIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return new AnnotatedImage(legacyImage, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        AnnotatedImage mergedImage = this.generateMergedLayers(context, options, null);
        BufferedImage image = mergedImage.getImage();
        BufferedImage mask = this.generateMaskLayer(context, options, options.previewShape);
        image = this.cropImageToViewport(options, image);
        image = LauncherIconGenerator.applyMask(image, mask);
        LauncherIconGenerator.drawGrid(options, image);
        return new AnnotatedImage(image, mergedImage.getErrorMessage());
    }

    @NotNull
    private AnnotatedImage generateMonochromeViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        AnnotatedImage monochromeLayer = this.generateIconMonochromeLayer(context, options);
        BufferedImage image = monochromeLayer.getImage();
        BufferedImage mask = this.generateMaskLayer(context, options, PreviewShape.MONOCHROME_CIRCLE);
        image = this.cropImageToViewport(options, image);
        image = LauncherIconGenerator.applyMask(image, mask);
        LauncherIconGenerator.drawGrid(options, image);
        return new AnnotatedImage(image, monochromeLayer.getErrorMessage());
    }

    @Nullable
    private BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        switch (shape.ordinal()) {
            case 0: 
            case 1: {
                String string = "circle";
                break;
            }
            case 4: {
                String string = "square";
                break;
            }
            case 3: {
                String string = "rounded_corner";
                break;
            }
            case 2: {
                String string = "squircle";
                break;
            }
            default: {
                String string = maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generatePlayStoreIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            double scale = LauncherIconGenerator.getRectangleInsideScale(maskRect, this.getViewportRectangle(options));
            return options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(mask, scale) : LauncherIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @Override
    @NotNull
    protected Rectangle getFullBleedRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            return IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @Override
    @NotNull
    protected Rectangle getViewportRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            return IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @Override
    @NotNull
    protected Rectangle getLegacyRectangle(@NotNull AdaptiveIconGenerator.AdaptiveIconOptions options) {
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            return options.generatePreviewIcons ? IMAGE_SIZE_VIEWPORT_PREVIEW_PLAY_STORE_PX : IMAGE_SIZE_VIEWPORT_PLAY_STORE_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @Override
    protected boolean isMonochromeSupported() {
        return (Boolean)StudioFlags.ENABLE_MONOCHROME_ICON_EDITOR_TAB.get();
    }

    @Override
    protected Rectangle getMaxIconRectangle() {
        return IMAGE_SIZE_FULL_BLEED_PLAY_STORE_PX;
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        LauncherIconGenerator.drawGrid(launcherIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull Graphics2D gOut) {
        if (launcherIconOptions.generatePlayStoreIcon) {
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
                LauncherIconGenerator.drawFullBleedIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.LEGACY || launcherIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (launcherIconOptions.showGrid) {
                LauncherIconGenerator.drawLegacyIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
            LauncherIconGenerator.drawAdaptiveIconGrid(launcherIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, LauncherIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.IconOptions options, @NotNull String iconName) {
        if (((LauncherIconOptions)options).generatePlayStoreIcon) {
            return iconName + "-playstore.png";
        }
        return super.getIconPath(options, iconName);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(LauncherIconGenerator.class);
    }

    public static class LauncherIconOptions
    extends AdaptiveIconGenerator.AdaptiveIconOptions
    implements Cloneable {
        public boolean generateRoundIcon = true;
        public boolean generatePlayStoreIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public IconGenerator.Shape legacyIconShape = IconGenerator.Shape.SQUARE;
        public boolean showGrid;

        public LauncherIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public LauncherIconOptions clone() {
            return (LauncherIconOptions)super.clone();
        }
    }

    public static enum PreviewShape {
        MONOCHROME_CIRCLE("monochrome-circle", "Monochrome"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        PLAY_STORE("play-store", "Google Play Store"),
        NONE("none", "none");

        public final String id;
        public final String displayName;

        private PreviewShape(String id2, String displayName) {
            this.id = id2;
            this.displayName = displayName;
        }
    }
}

