/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.apk.SourceFolders;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibraryNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibFolderNode
extends ProjectViewNode<VirtualFile> {
    @NotNull
    private final VirtualFile myFolder;

    public LibFolderNode(@NotNull Project project, @NotNull VirtualFile libFolder, @NotNull ViewSettings settings) {
        super(project, (Object)libFolder, settings);
        this.myFolder = libFolder;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        assert (this.myProject != null);
        ArrayList<NativeLibrary> libraries = new ArrayList<NativeLibrary>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ApkFacet facet = ApkFacet.getInstance(module);
            if (facet == null) continue;
            libraries.addAll(((ApkFacetConfiguration)facet.getConfiguration()).NATIVE_LIBRARIES);
        }
        ViewSettings settings = this.getSettings();
        ArrayList<LibraryNode> children2 = new ArrayList<LibraryNode>();
        for (NativeLibrary library : libraries) {
            children2.add(new LibraryNode(this.myProject, library, settings));
        }
        return children2;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (VfsUtilCore.isAncestor((VirtualFile)this.myFolder, (VirtualFile)file, (boolean)false)) {
            return true;
        }
        assert (this.myProject != null);
        return SourceFolders.isInSourceFolder(file, this.myProject);
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.addText(LibFolderNode.getSourceType().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(" (lib)", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFolder;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return LibFolderNode.getSourceType();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.PACKAGE.getWeight();
    }

    @NotNull
    private static AndroidSourceType getSourceType() {
        return AndroidSourceType.CPP.INSTANCE;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return LibFolderNode.getSourceType().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibFolderNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LibFolderNode node = (LibFolderNode)((Object)o);
        return Objects.equals(this.myFolder, node.myFolder);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myFolder);
    }
}

