/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiFileNode
extends PsiFileNode {
    @Nullable
    private final String mySourceSetName;

    public AndroidPsiFileNode(@NotNull Project project, @NotNull PsiFile file, @NotNull ViewSettings settings, @Nullable String sourceSetName) {
        super(project, file, settings);
        this.mySourceSetName = sourceSetName;
    }

    protected void updateImpl(@NotNull PresentationData data2) {
        super.updateImpl(data2);
        if (this.mySourceSetName != null && !"main".equals(this.mySourceSetName)) {
            data2.addText(data2.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data2.addText(" (" + this.mySourceSetName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String sourceProviderName = this.mySourceSetName == null ? "" : this.mySourceSetName;
        return this.getQualifiedNameSortKey() + "-" + ("main".equals(sourceProviderName) ? "" : sourceProviderName);
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.FILE.getWeight();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        assert (file != null);
        return AndroidPsiDirectoryNode.toTestString(file.getName(), this.mySourceSetName);
    }
}

