/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.projectView.ProjectToolWindowSettings;
import com.android.tools.idea.navigator.nodes.AndroidViewNodeProvider;
import com.android.tools.idea.navigator.nodes.other.NonAndroidModuleNode;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a.\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\"\"\u0010\u000f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"createChildModuleNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "submodules", "", "Lcom/intellij/openapi/module/Module;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "showInProjectBuildScriptsGroup", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "showBuildFilesInModule", "overrideShowBuildFilesInModule", "getOverrideShowBuildFilesInModule", "()Ljava/lang/Boolean;", "setOverrideShowBuildFilesInModule", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isProjectBuildScript", "intellij.android.navigator"})
@JvmName(name="ModuleNodeUtils")
@SourceDebugExtension(value={"SMAP\nModuleNodeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleNodeUtils.kt\ncom/android/tools/idea/navigator/nodes/ModuleNodeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1869#2:71\n1617#2,9:72\n1869#2:81\n1870#2:83\n1626#2:84\n1870#2:85\n1#3:82\n*S KotlinDebug\n*F\n+ 1 ModuleNodeUtils.kt\ncom/android/tools/idea/navigator/nodes/ModuleNodeUtils\n*L\n41#1:71\n42#1:72,9\n42#1:81\n42#1:83\n42#1:84\n41#1:85\n42#1:82\n*E\n"})
public final class ModuleNodeUtils {
    @VisibleForTesting
    @Nullable
    private static Boolean overrideShowBuildFilesInModule;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AbstractTreeNode<?>> createChildModuleNodes(@NotNull Project project, @NotNull Collection<? extends Module> submodules, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(submodules, (String)"submodules");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Collection<AndroidViewNodeProvider> providers = AndroidViewNodeProvider.Companion.getProviders();
        ArrayList children2 = new ArrayList(submodules.size());
        Iterable $this$forEach$iv = submodules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            Module module = (Module)element$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = providers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                List<AbstractTreeNode<?>> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                AndroidViewNodeProvider provider = (AndroidViewNodeProvider)element$iv$iv;
                boolean bl3 = false;
                if (provider.getModuleNodes(module, settings) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List nodeGroups = (List)destination$iv$iv;
            children2.addAll(!((Collection)nodeGroups).isEmpty() ? CollectionsKt.flatten((Iterable)nodeGroups) : CollectionsKt.listOf((Object)((Object)new NonAndroidModuleNode(project, module, settings))));
        }
        return children2;
    }

    public static final boolean showInProjectBuildScriptsGroup(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (ModuleNodeUtils.isProjectBuildScript(psiFile)) {
            return true;
        }
        return !ModuleNodeUtils.showBuildFilesInModule();
    }

    public static final boolean showBuildFilesInModule() {
        Boolean bl = overrideShowBuildFilesInModule;
        return bl != null ? bl.booleanValue() : ProjectToolWindowSettings.Companion.getInstance().getShowBuildFilesInModule();
    }

    @Nullable
    public static final Boolean getOverrideShowBuildFilesInModule() {
        return overrideShowBuildFilesInModule;
    }

    public static final void setOverrideShowBuildFilesInModule(@Nullable Boolean bl) {
        overrideShowBuildFilesInModule = bl;
    }

    private static final boolean isProjectBuildScript(PsiFile psiFile) {
        Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)psiFile));
        return Intrinsics.areEqual((Object)(module != null ? GradleProjectPathKt.getGradleIdentityPath(module) : null), (Object)":");
    }
}

