/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.nodes.ModuleNodeUtils;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidViewModuleNode
extends ProjectViewModuleNode {
    public AndroidViewModuleNode(@NotNull Project project, @NotNull Module value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode<?>> getModuleChildren();

    @NotNull
    protected final Collection<AbstractTreeNode<?>> platformGetChildren() {
        return super.getChildren();
    }

    @NotNull
    public final Collection<AbstractTreeNode<?>> getChildren() {
        Project project = this.getProject();
        Module module = (Module)this.getValue();
        if (project == null || module == null) {
            return this.getModuleChildren();
        }
        return CollectionsKt.plus(this.createSubmoduleNodes(), this.getModuleChildren());
    }

    @Nullable
    private AndroidModuleSystem getAndroidModuleSystem() {
        if (this.getProject() == null || this.getValue() == null) {
            return null;
        }
        AndroidProjectSystem projectSystem = ProjectSystemService.getInstance(this.getProject()).getProjectSystem();
        return projectSystem.getModuleSystem((Module)this.getValue());
    }

    @NotNull
    private List<AbstractTreeNode<?>> createSubmoduleNodes() {
        AndroidModuleSystem androidModuleSystem = this.getAndroidModuleSystem();
        if (androidModuleSystem == null) {
            return ContainerUtil.emptyList();
        }
        return ModuleNodeUtils.createChildModuleNodes(Objects.requireNonNull(this.getProject()), androidModuleSystem.getSubmodules(), this.getSettings());
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (super.contains(file)) {
            return true;
        }
        Module module = (Module)this.getValue();
        if (module.isDisposed()) {
            return false;
        }
        List<Module> sourceSetModules = LinkedAndroidModuleGroupUtilsKt.getAllLinkedModules(module);
        for (Module m : sourceSetModules) {
            if (m == module || m.isDisposed()) continue;
            for (VirtualFile root : ModuleRootManager.getInstance((Module)m).getContentRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return this.createSubmoduleNodes().stream().anyMatch(it -> it instanceof ProjectViewNode && ((ProjectViewNode)it).contains(file));
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module value2 = (Module)this.getValue();
        if (value2 == null) {
            return "null";
        }
        return ProjectSystemUtil.getModuleSystem(value2).getDisplayNameForModule();
    }

    public void update(@NotNull PresentationData presentation) {
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            this.setValue(null);
            return;
        }
        String moduleShortName = ProjectSystemUtil.getModuleSystem(module).getDisplayNameForModule();
        presentation.setPresentableText(moduleShortName);
        presentation.addText(moduleShortName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        presentation.setIcon(ModuleType.get((Module)module).getIcon());
        presentation.setTooltip(ModuleType.get((Module)module).getName());
    }
}

