/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.nav.safeargs.module;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.nav.safeargs.index.NavXmlData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J1\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/nav/safeargs/module/NavEntry;", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resource", "Lcom/android/ide/common/resources/ResourceItem;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "data", "Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/ResourceItem;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "getResource", "()Lcom/android/ide/common/resources/ResourceItem;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "()Lcom/android/tools/idea/nav/safeargs/index/NavXmlData;", "backingXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getBackingXmlFile", "()Lcom/intellij/psi/xml/XmlFile;", "backingXmlFile$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.nav.safeargs.common"})
public final class NavEntry {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final ResourceItem resource;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final NavXmlData data;
    @NotNull
    private final Lazy backingXmlFile$delegate;

    public NavEntry(@NotNull AndroidFacet facet, @NotNull ResourceItem resource, @NotNull VirtualFile file, @NotNull NavXmlData data2) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.facet = facet;
        this.resource = resource;
        this.file = file;
        this.data = data2;
        this.backingXmlFile$delegate = LazyKt.lazy(() -> NavEntry.backingXmlFile_delegate$lambda$0(this));
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    @NotNull
    public final ResourceItem getResource() {
        return this.resource;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final NavXmlData getData() {
        return this.data;
    }

    @Nullable
    public final XmlFile getBackingXmlFile() {
        Lazy lazy = this.backingXmlFile$delegate;
        return (XmlFile)lazy.getValue();
    }

    @NotNull
    public final AndroidFacet component1() {
        return this.facet;
    }

    @NotNull
    public final ResourceItem component2() {
        return this.resource;
    }

    @NotNull
    public final VirtualFile component3() {
        return this.file;
    }

    @NotNull
    public final NavXmlData component4() {
        return this.data;
    }

    @NotNull
    public final NavEntry copy(@NotNull AndroidFacet facet, @NotNull ResourceItem resource, @NotNull VirtualFile file, @NotNull NavXmlData data2) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return new NavEntry(facet, resource, file, data2);
    }

    public static /* synthetic */ NavEntry copy$default(NavEntry navEntry, AndroidFacet androidFacet, ResourceItem resourceItem, VirtualFile virtualFile, NavXmlData navXmlData, int n, Object object) {
        if ((n & 1) != 0) {
            androidFacet = navEntry.facet;
        }
        if ((n & 2) != 0) {
            resourceItem = navEntry.resource;
        }
        if ((n & 4) != 0) {
            virtualFile = navEntry.file;
        }
        if ((n & 8) != 0) {
            navXmlData = navEntry.data;
        }
        return navEntry.copy(androidFacet, resourceItem, virtualFile, navXmlData);
    }

    @NotNull
    public String toString() {
        return "NavEntry(facet=" + this.facet + ", resource=" + this.resource + ", file=" + this.file + ", data=" + this.data + ")";
    }

    public int hashCode() {
        int result2 = this.facet.hashCode();
        result2 = result2 * 31 + this.resource.hashCode();
        result2 = result2 * 31 + this.file.hashCode();
        result2 = result2 * 31 + this.data.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NavEntry)) {
            return false;
        }
        NavEntry navEntry = (NavEntry)other;
        if (!Intrinsics.areEqual((Object)this.facet, (Object)navEntry.facet)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resource, (Object)navEntry.resource)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)navEntry.file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)navEntry.data);
    }

    private static final XmlFile backingXmlFile_delegate$lambda$0(NavEntry this$0) {
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.facet.getModule().getProject()).findFile(this$0.file);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }
}

