/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.manifmerger.Actions;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.dom.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ImmutablePermissionHolder;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestInfo;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.ResourceNamespacing;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MergedManifestSnapshotFactory {
    MergedManifestSnapshotFactory() {
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element, @Nullable String namespaceUri, @NotNull String attributeName) {
        return Strings.emptyToNull((String)element.getAttributeNS(namespaceUri, attributeName));
    }

    @Nullable
    private static ResourceValue getResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull Element element, @Nullable String namespaceUri, @NotNull String attributeName) {
        String value2 = MergedManifestSnapshotFactory.getAttributeValue(element, namespaceUri, attributeName);
        if (value2 == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)value2);
        ResourceReference reference = url == null ? null : url.resolve(namespace, namespacePrefix -> element.lookupNamespaceURI(namespacePrefix));
        return new ManifestResourceValue(namespace, type, attributeName, value2, reference);
    }

    private static AndroidVersion getApiVersion(@NotNull Element usesSdk, @NotNull String attribute2, @NotNull AndroidVersion defaultApiLevel) {
        AndroidVersion version2;
        String valueString = MergedManifestSnapshotFactory.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute2);
        if (valueString != null && (version2 = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version2;
        }
        return defaultApiLevel;
    }

    @NotNull
    static MergedManifestSnapshot createEmptyMergedManifestSnapshot(@NotNull Module module, @Nullable AndroidFacet facet, @Nullable Exception exception) {
        return new MergedManifestSnapshot(module, null, null, null, (Map<String, ActivityAttributesSnapshot>)ImmutableMap.of(), facet != null ? MergedManifestInfo.createEmpty(facet) : null, AndroidVersion.DEFAULT, AndroidVersion.DEFAULT, null, null, false, null, null, (List<? extends VirtualFile>)ImmutableList.of(), ImmutablePermissionHolder.EMPTY, (List<? extends Element>)ImmutableList.of(), (List<? extends Element>)ImmutableList.of(), null, false, exception);
    }

    @NotNull
    static MergedManifestSnapshot createMergedManifestSnapshot(@NotNull AndroidFacet facet) {
        try {
            String packageName;
            Element root;
            MergedManifestInfo mergedManifestInfo = MergedManifestInfo.create(facet);
            Document document = mergedManifestInfo.getXmlDocument();
            Element element = root = document == null ? null : document.getDocumentElement();
            if (root == null) {
                throw new MergedManifestException.MissingElement("manifest", mergedManifestInfo);
            }
            String manifestPackageName = MergedManifestSnapshotFactory.getAttributeValue(root, null, "package");
            String moduleSystemPackageName = ProjectSystemUtil.getModuleSystem(facet).getPackageName();
            String string = packageName = moduleSystemPackageName != null ? moduleSystemPackageName : manifestPackageName;
            if (packageName == null) {
                throw new MergedManifestException.MissingAttribute("manifest", null, "package", mergedManifestInfo);
            }
            ResourceNamespacing namespacing = StudioResourceRepositoryManager.getInstance(facet).getNamespacing();
            ResourceNamespace namespace = namespacing == ResourceNamespacing.DISABLED ? ResourceNamespace.RES_AUTO : ResourceNamespace.fromPackageName((String)packageName);
            String versionCodeStr = MergedManifestSnapshotFactory.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            Integer versionCode2 = null;
            try {
                versionCode2 = versionCodeStr != null ? Integer.valueOf(versionCodeStr) : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ResourceValue appIcon = null;
            ResourceValue appLabel = null;
            String manifestTheme = null;
            boolean supportsRtl = false;
            Boolean isAppDebuggable = null;
            HashMap<String, ActivityAttributesSnapshot> activityAttributesMap = new HashMap<String, ActivityAttributesSnapshot>();
            ArrayList<Element> activities = new ArrayList<Element>();
            ArrayList<Element> services = new ArrayList<Element>(4);
            AndroidVersion targetSdk = AndroidVersion.DEFAULT;
            AndroidVersion minSdk = AndroidVersion.DEFAULT;
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String name2;
                String protectionLevel;
                Element element2;
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    appIcon = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, application, "http://schemas.android.com/apk/res/android", "icon");
                    appLabel = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, application, "http://schemas.android.com/apk/res/android", "label");
                    manifestTheme = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    supportsRtl = "true".equals(MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable2 = MergedManifestSnapshotFactory.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    isAppDebuggable = debuggable2 == null ? null : Boolean.valueOf("true".equals(debuggable2));
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element3 = (Element)child;
                            ActivityAttributesSnapshot attributes = MergedManifestSnapshotFactory.createActivityAttributesSnapshot(element3, packageName, namespace);
                            activityAttributesMap.put(attributes.getName(), attributes);
                            activities.add(element3);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        services.add((Element)child);
                    }
                    continue;
                }
                if ("uses-sdk".equals(nodeName)) {
                    Element usesSdk = (Element)node;
                    minSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                    targetSdk = MergedManifestSnapshotFactory.getApiVersion(usesSdk, "targetSdkVersion", minSdk);
                    continue;
                }
                if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                    element2 = (Element)node;
                    String name3 = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (name3.isEmpty()) continue;
                    permissions.add(name3);
                    continue;
                }
                if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element2 = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name2 = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                revocable.add(name2);
            }
            AndroidVersion modelMinSdk = null;
            AndroidVersion modelTargetSdk = null;
            AndroidModel androidModel = AndroidModel.get(facet);
            if (androidModel != null) {
                modelMinSdk = androidModel.getMinSdkVersion();
                modelTargetSdk = androidModel.getTargetSdkVersion();
            }
            ImmutablePermissionHolder permissionHolder = new ImmutablePermissionHolder(modelMinSdk == null ? minSdk : modelMinSdk, modelTargetSdk == null ? targetSdk : modelTargetSdk, (Set<String>)ImmutableSet.copyOf((Collection)permissions), (Set<String>)ImmutableSet.copyOf((Collection)revocable));
            Actions actions2 = mergedManifestInfo.getActions();
            return new MergedManifestSnapshot(facet.getModule(), packageName, versionCode2, manifestTheme, (Map<String, ActivityAttributesSnapshot>)ImmutableMap.copyOf(activityAttributesMap), mergedManifestInfo, minSdk, targetSdk, appIcon, appLabel, supportsRtl, isAppDebuggable, document, (List<? extends VirtualFile>)ImmutableList.copyOf(mergedManifestInfo.getFiles()), permissionHolder, (List<? extends Element>)ImmutableList.copyOf(activities), (List<? extends Element>)ImmutableList.copyOf(services), actions2, true, null);
        }
        catch (MergedManifestException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MergedManifestException.InfrastructureError(e);
        }
    }

    @NotNull
    private static ActivityAttributesSnapshot createActivityAttributesSnapshot(@NotNull Element activity, @Nullable String packageName, @NotNull ResourceNamespace namespace) {
        Object name2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
        if (name2 == null || ((String)name2).isEmpty()) {
            throw new RuntimeException("Activity name cannot be empty.");
        }
        int index = ((String)name2).indexOf(46);
        if (index <= 0 && packageName != null && !packageName.isEmpty()) {
            name2 = packageName + (index == -1 ? "." : "") + (String)name2;
        }
        ResourceValue icon = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.DRAWABLE, activity, "http://schemas.android.com/apk/res/android", "icon");
        ResourceValue label2 = MergedManifestSnapshotFactory.getResourceValue(namespace, ResourceType.STRING, activity, "http://schemas.android.com/apk/res/android", "label");
        Object value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
        if (value2 == null || ((String)value2).isEmpty()) {
            for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                String metaDataName;
                if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifestSnapshotFactory.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index = ((String)value2).indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                value2 = packageName + (index == -1 ? "." : "") + (String)value2;
                break;
            }
        }
        String parentActivity = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
        String theme = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        value2 = MergedManifestSnapshotFactory.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
        String uiOptions = StringUtil.isNotEmpty((String)value2) ? value2 : null;
        return new ActivityAttributesSnapshot(activity, icon, label2, (String)name2, parentActivity, theme, uiOptions);
    }

    private static class ManifestResourceValue
    extends ResourceValueImpl {
        @Nullable
        private final ResourceReference myReference;

        ManifestResourceValue(@NotNull ResourceNamespace namespace, @NotNull ResourceType type, @NotNull String name2, @Nullable String value2, @Nullable ResourceReference reference) {
            super(namespace, type, name2, value2);
            this.myReference = reference;
        }

        @Nullable
        public ResourceReference getReference() {
            return this.myReference;
        }
    }
}

