/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.mlkit.MlModuleService;
import com.android.tools.idea.mlkit.MlUtils;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinResolveScopeEnlarger;

public class MlResolveScopeEnlarger
extends ResolveScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        return module != null ? MlResolveScopeEnlarger.getAdditionalResolveScope(module) : null;
    }

    @Nullable
    private static SearchScope getAdditionalResolveScope(@NotNull Module module) {
        if (!MlUtils.isMlModelBindingBuildFeatureEnabled(module)) {
            return null;
        }
        Project project = module.getProject();
        return (SearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SearchScope searchScopeIncludingDeps = MlResolveScopeEnlarger.getLocalResolveScope(module);
            for (Module moduleDep : ProjectSystemUtil.getModuleSystem(module).getResourceModuleDependencies()) {
                searchScopeIncludingDeps = searchScopeIncludingDeps.union(MlResolveScopeEnlarger.getLocalResolveScope(moduleDep));
            }
            return CachedValueProvider.Result.create((Object)searchScopeIncludingDeps, MlModuleService.getProjectDependencies(project));
        });
    }

    @NotNull
    private static SearchScope getLocalResolveScope(@NotNull Module module) {
        Project project = module.getProject();
        if (MlUtils.isMlModelBindingBuildFeatureEnabled(module)) {
            ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
            for (PsiClass psiClass : MlModuleService.getInstance(module).getLightModelClassList()) {
                virtualFiles.add(psiClass.getContainingFile().getViewProvider().getVirtualFile());
            }
            return GlobalSearchScope.filesWithoutLibrariesScope((Project)project, virtualFiles);
        }
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    public static class MlKotlinResolveScopeEnlarger
    implements KotlinResolveScopeEnlarger {
        @Nullable
        public SearchScope getAdditionalResolveScope(@NotNull Module module, boolean isTestScope) {
            return MlResolveScopeEnlarger.getAdditionalResolveScope(module);
        }
    }
}

