/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.NotNull;

public class APIVersion
implements Comparable<APIVersion> {
    @NotNull
    public static final APIVersion API_VERSION_1 = new APIVersion(SemVer.parseFromText((String)"1.0.0"), AgpVersion.parse((String)"4.1.0"));
    @NotNull
    public static final APIVersion API_VERSION_2 = new APIVersion(SemVer.parseFromText((String)"1.2.0"), AgpVersion.parse((String)"4.2.0-alpha08"));
    @NotNull
    private final SemVer myModelParserVersion;
    @NotNull
    private final AgpVersion myAgpVersion;

    @NotNull
    public static APIVersion fromProject(@NotNull Project project) {
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            Logger.getInstance(APIVersion.class).warn("AndroidPluginInfo is null in project: " + String.valueOf(project));
            return API_VERSION_1;
        }
        AgpVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null) {
            Logger.getInstance(APIVersion.class).warn("GradleVersion is null in project: " + String.valueOf(project));
            return API_VERSION_1;
        }
        if (agpVersion.compareTo(APIVersion.API_VERSION_2.myAgpVersion) >= 0) {
            return API_VERSION_2;
        }
        return API_VERSION_1;
    }

    private APIVersion(@NotNull SemVer modelParserVersion, @NotNull AgpVersion agpVersion) {
        this.myModelParserVersion = modelParserVersion;
        this.myAgpVersion = agpVersion;
    }

    public boolean isAtLeastVersion(@NotNull APIVersion apiVersion) {
        return this.compareTo(apiVersion) >= 0;
    }

    public boolean generateFallbackApiOnly(@NotNull String minParserVersion) {
        SemVer semVer = SemVer.parseFromText((String)minParserVersion);
        if (semVer == null) {
            Logger.getInstance(APIVersion.class).error("Model min parser version is null.");
            return false;
        }
        return !this.myModelParserVersion.isGreaterOrEqualThan(semVer);
    }

    @Override
    public int compareTo(@NotNull APIVersion o) {
        return this.myAgpVersion.compareTo(o.myAgpVersion);
    }
}

