/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.settings;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.LogcatToolWindowFactory;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterFileType;
import com.android.tools.idea.logcat.settings.AndroidLogcatSettings;
import com.android.tools.idea.logcat.settings.IgnoreValuesTextField;
import com.android.tools.idea.logcat.settings.LogcatApplicationSettingsConfigurable;
import com.android.tools.idea.logcat.settings.LogcatApplicationSettingsConfigurableKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GridBag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020,H\u0016J\b\u00102\u001a\u00020,H\u0016J\u000f\u00103\u001a\u0004\u0018\u000104H\u0002\u00a2\u0006\u0002\u00105R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0016\u0010\u0015\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0017\u001a\u00020\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b\u001e\u0010\u001aR\u0016\u0010 \u001a\u00020!8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020!8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0016\u0010&\u001a\u00020\u00108\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0012R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/idea/logcat/settings/LogcatApplicationSettingsConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "logcatSettings", "Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;", "<init>", "(Lcom/android/tools/idea/logcat/settings/AndroidLogcatSettings;)V", "cycleBufferSizeTextField", "Ljavax/swing/JTextField;", "getCycleBufferSizeTextField$intellij_android_logcat", "()Ljavax/swing/JTextField;", "defaultFilterTextField", "Lcom/intellij/ui/EditorTextField;", "getDefaultFilterTextField$intellij_android_logcat", "()Lcom/intellij/ui/EditorTextField;", "mostRecentlyUsedFilterIsDefaultCheckbox", "Ljavax/swing/JCheckBox;", "getMostRecentlyUsedFilterIsDefaultCheckbox$intellij_android_logcat", "()Ljavax/swing/JCheckBox;", "fontSize", "getFontSize$intellij_android_logcat", "overrideFontSize", "getOverrideFontSize$intellij_android_logcat", "ignoreTagsTextField", "Lcom/android/tools/idea/logcat/settings/IgnoreValuesTextField;", "getIgnoreTagsTextField$intellij_android_logcat", "()Lcom/android/tools/idea/logcat/settings/IgnoreValuesTextField;", "ignoreTagsTextField$delegate", "Lkotlin/Lazy;", "ignoreAppsTextField", "getIgnoreAppsTextField$intellij_android_logcat", "ignoreAppsTextField$delegate", "ignoreValuesNote", "Ljavax/swing/JLabel;", "getIgnoreValuesNote$intellij_android_logcat", "()Ljavax/swing/JLabel;", "cyclicBufferSizeWarningLabel", "getCyclicBufferSizeWarningLabel$intellij_android_logcat", "filterHistoryAutocompleteCheckbox", "getFilterHistoryAutocompleteCheckbox$intellij_android_logcat", "component", "Ljavax/swing/JPanel;", "createComponent", "updateWarningLabel", "", "getDisplayName", "", "isModified", "", "reset", "apply", "getBufferSizeKb", "", "()Ljava/lang/Integer;", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatApplicationSettingsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatApplicationSettingsConfigurable.kt\ncom/android/tools/idea/logcat/settings/LogcatApplicationSettingsConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1374#2:262\n1460#2,5:263\n1869#2,2:268\n*S KotlinDebug\n*F\n+ 1 LogcatApplicationSettingsConfigurable.kt\ncom/android/tools/idea/logcat/settings/LogcatApplicationSettingsConfigurable\n*L\n180#1:262\n180#1:263,5\n249#1:268,2\n*E\n"})
public final class LogcatApplicationSettingsConfigurable
implements Configurable,
Configurable.NoScroll {
    @NotNull
    private final AndroidLogcatSettings logcatSettings;
    @VisibleForTesting
    @NotNull
    private final JTextField cycleBufferSizeTextField;
    @VisibleForTesting
    @NotNull
    private final EditorTextField defaultFilterTextField;
    @VisibleForTesting
    @NotNull
    private final JCheckBox mostRecentlyUsedFilterIsDefaultCheckbox;
    @VisibleForTesting
    @NotNull
    private final JTextField fontSize;
    @VisibleForTesting
    @NotNull
    private final JCheckBox overrideFontSize;
    @NotNull
    private final Lazy ignoreTagsTextField$delegate;
    @NotNull
    private final Lazy ignoreAppsTextField$delegate;
    @VisibleForTesting
    @NotNull
    private final JLabel ignoreValuesNote;
    @VisibleForTesting
    @NotNull
    private final JLabel cyclicBufferSizeWarningLabel;
    @VisibleForTesting
    @NotNull
    private final JCheckBox filterHistoryAutocompleteCheckbox;
    @NotNull
    private final JPanel component;

    /*
     * WARNING - void declaration
     */
    public LogcatApplicationSettingsConfigurable(@NotNull AndroidLogcatSettings logcatSettings) {
        void $this$ignoreValuesNote_u24lambda_u240;
        JComponent $this$overrideFontSize_u24lambda_u240;
        JComponent $this$fontSize_u24lambda_u240;
        JComponent $this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u240;
        JComponent $this$defaultFilterTextField_u24lambda_u240;
        JTextField $this$cycleBufferSizeTextField_u24lambda_u240;
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)logcatSettings, (String)"logcatSettings");
        this.logcatSettings = logcatSettings;
        JTextField jTextField = jComponent = new JTextField();
        LogcatApplicationSettingsConfigurable logcatApplicationSettingsConfigurable = this;
        boolean bl = false;
        $this$cycleBufferSizeTextField_u24lambda_u240.setText(String.valueOf(this.logcatSettings.getBufferSize() / 1024));
        $this$cycleBufferSizeTextField_u24lambda_u240.setMinimumSize(new Dimension(JBUIScale.scale((int)130), $this$cycleBufferSizeTextField_u24lambda_u240.getMinimumSize().height));
        $this$cycleBufferSizeTextField_u24lambda_u240.setPreferredSize($this$cycleBufferSizeTextField_u24lambda_u240.getMinimumSize());
        logcatApplicationSettingsConfigurable.cycleBufferSizeTextField = jComponent;
        $this$cycleBufferSizeTextField_u24lambda_u240 = jComponent = new EditorTextField(ProjectManager.getInstance().getDefaultProject(), (FileType)LogcatFilterFileType.INSTANCE);
        logcatApplicationSettingsConfigurable = this;
        boolean bl2 = false;
        $this$defaultFilterTextField_u24lambda_u240.setEnabled(!this.logcatSettings.getMostRecentlyUsedFilterIsDefault());
        logcatApplicationSettingsConfigurable.defaultFilterTextField = jComponent;
        $this$defaultFilterTextField_u24lambda_u240 = jComponent = new JCheckBox(LogcatBundle.message("logcat.settings.default.filter.mru", new Object[0]));
        logcatApplicationSettingsConfigurable = this;
        boolean bl3 = false;
        ((AbstractButton)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u240).setSelected(this.logcatSettings.getMostRecentlyUsedFilterIsDefault());
        ((AbstractButton)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u240).addActionListener(arg_0 -> LogcatApplicationSettingsConfigurable.mostRecentlyUsedFilterIsDefaultCheckbox$lambda$0$0(this, (JCheckBox)$this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u240, arg_0));
        logcatApplicationSettingsConfigurable.mostRecentlyUsedFilterIsDefaultCheckbox = jComponent;
        $this$mostRecentlyUsedFilterIsDefaultCheckbox_u24lambda_u240 = jComponent = new JTextField();
        logcatApplicationSettingsConfigurable = this;
        boolean bl4 = false;
        $this$fontSize_u24lambda_u240.setText(String.valueOf(this.logcatSettings.getFontSize()));
        $this$fontSize_u24lambda_u240.setMinimumSize(new Dimension(JBUIScale.scale((int)60), $this$fontSize_u24lambda_u240.getMinimumSize().height));
        $this$fontSize_u24lambda_u240.setPreferredSize($this$fontSize_u24lambda_u240.getMinimumSize());
        logcatApplicationSettingsConfigurable.fontSize = jComponent;
        $this$fontSize_u24lambda_u240 = jComponent = new JCheckBox(LogcatBundle.message("logcat.settings.override.font.size", new Object[0]));
        logcatApplicationSettingsConfigurable = this;
        boolean bl5 = false;
        ((AbstractButton)$this$overrideFontSize_u24lambda_u240).setSelected(this.logcatSettings.getOverrideFontSize());
        ((AbstractButton)$this$overrideFontSize_u24lambda_u240).addActionListener(arg_0 -> LogcatApplicationSettingsConfigurable.overrideFontSize$lambda$0$0(this, (JCheckBox)$this$overrideFontSize_u24lambda_u240, arg_0));
        this.fontSize.setEnabled(((AbstractButton)$this$overrideFontSize_u24lambda_u240).isSelected());
        logcatApplicationSettingsConfigurable.overrideFontSize = jComponent;
        this.ignoreTagsTextField$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> LogcatApplicationSettingsConfigurable.ignoreTagsTextField_delegate$lambda$0(this));
        this.ignoreAppsTextField$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> LogcatApplicationSettingsConfigurable.ignoreAppsTextField_delegate$lambda$0(this));
        $this$overrideFontSize_u24lambda_u240 = jComponent = new JLabel(LogcatBundle.message("logcat.settings.ignore.tags.note", new Object[0]));
        logcatApplicationSettingsConfigurable = this;
        boolean bl6 = false;
        $this$ignoreValuesNote_u24lambda_u240.setForeground((Color)JBColor.red);
        logcatApplicationSettingsConfigurable.ignoreValuesNote = jComponent;
        this.cyclicBufferSizeWarningLabel = new JLabel();
        this.filterHistoryAutocompleteCheckbox = new JCheckBox(LogcatBundle.message("logcat.settings.history.autocomplete", new Object[0]), this.logcatSettings.getFilterHistoryAutocomplete());
        this.component = new JPanel(new GridBagLayout());
    }

    @NotNull
    public final JTextField getCycleBufferSizeTextField$intellij_android_logcat() {
        return this.cycleBufferSizeTextField;
    }

    @NotNull
    public final EditorTextField getDefaultFilterTextField$intellij_android_logcat() {
        return this.defaultFilterTextField;
    }

    @NotNull
    public final JCheckBox getMostRecentlyUsedFilterIsDefaultCheckbox$intellij_android_logcat() {
        return this.mostRecentlyUsedFilterIsDefaultCheckbox;
    }

    @NotNull
    public final JTextField getFontSize$intellij_android_logcat() {
        return this.fontSize;
    }

    @NotNull
    public final JCheckBox getOverrideFontSize$intellij_android_logcat() {
        return this.overrideFontSize;
    }

    @NotNull
    public final IgnoreValuesTextField getIgnoreTagsTextField$intellij_android_logcat() {
        Lazy lazy = this.ignoreTagsTextField$delegate;
        return (IgnoreValuesTextField)lazy.getValue();
    }

    @NotNull
    public final IgnoreValuesTextField getIgnoreAppsTextField$intellij_android_logcat() {
        Lazy lazy = this.ignoreAppsTextField$delegate;
        return (IgnoreValuesTextField)lazy.getValue();
    }

    @NotNull
    public final JLabel getIgnoreValuesNote$intellij_android_logcat() {
        return this.ignoreValuesNote;
    }

    @NotNull
    public final JLabel getCyclicBufferSizeWarningLabel$intellij_android_logcat() {
        return this.cyclicBufferSizeWarningLabel;
    }

    @NotNull
    public final JCheckBox getFilterHistoryAutocompleteCheckbox$intellij_android_logcat() {
        return this.filterHistoryAutocompleteCheckbox;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JPanel createComponent() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel $this$createComponent_u24lambda_u240 = jPanel2 = this.component;
        boolean bl = false;
        JPanel $this$createComponent_u24lambda_u240_u240 = jPanel = this.component;
        boolean bl2 = false;
        this.cyclicBufferSizeWarningLabel.setForeground((Color)JBColor.red);
        this.cycleBufferSizeTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ LogcatApplicationSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LogcatApplicationSettingsConfigurable.access$updateWarningLabel(this.this$0);
            }
        });
        GridBag gridBag = new GridBag().anchor(18);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"anchor(...)");
        GridBag gridBag2 = gridBag;
        $this$createComponent_u24lambda_u240_u240.add((Component)new JLabel(LogcatBundle.message("logcat.settings.buffer.size", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.cycleBufferSizeTextField, gridBag2.next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add((Component)new JLabel(LogcatBundle.message("logcat.settings.buffer.kb", new Object[0])), gridBag2.next().weightx(1.0).anchor(17));
        $this$createComponent_u24lambda_u240_u240.add((Component)this.cyclicBufferSizeWarningLabel, gridBag2.nextLine().next().coverLine().anchor(18).pady(10));
        $this$createComponent_u24lambda_u240_u240.add((Component)new JLabel(LogcatBundle.message("logcat.settings.default.filter", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.defaultFilterTextField, gridBag2.next().anchor(17).fillCellHorizontally().weightx(1.0).coverLine());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.mostRecentlyUsedFilterIsDefaultCheckbox, gridBag2.nextLine().setColumn(2).coverLine().anchor(17).pady(10));
        this.defaultFilterTextField.setText(this.logcatSettings.getDefaultFilter());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.overrideFontSize, gridBag2.nextLine().next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.fontSize, gridBag2.next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add((Component)new JLabel(LogcatBundle.message("logcat.settings.ignore.tags.label", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.getIgnoreTagsTextField$intellij_android_logcat().getComponent(), gridBag2.next().anchor(17).fillCellHorizontally().weightx(1.0).coverLine());
        $this$createComponent_u24lambda_u240_u240.add((Component)new JLabel(LogcatBundle.message("logcat.settings.ignore.apps.label", new Object[0])), gridBag2.nextLine().next().anchor(17));
        $this$createComponent_u24lambda_u240_u240.add(Box.createHorizontalStrut(JBUIScale.scale((int)20)), gridBag2.next());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.getIgnoreAppsTextField$intellij_android_logcat().getComponent(), gridBag2.next().anchor(17).fillCellHorizontally().weightx(1.0).coverLine());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.ignoreValuesNote, gridBag2.nextLine().setColumn(2).coverLine().anchor(17).pady(10));
        Iterable iterable = LogcatToolWindowFactory.Companion.getLogcatPresenters$intellij_android_logcat();
        JLabel jLabel = this.ignoreValuesNote;
        boolean $i$f$flatMap = false;
        void var11_11 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogcatPresenter it = (LogcatPresenter)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getTags();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        jLabel.setVisible(((List)destination$iv$iv).isEmpty());
        $this$createComponent_u24lambda_u240_u240.add((Component)this.filterHistoryAutocompleteCheckbox, gridBag2.nextLine().next().coverLine().anchor(18).pady(10));
        $this$createComponent_u24lambda_u240_u240.add((Component)new JPanel(), gridBag2.nextLine().next().weighty(1.0));
        return jPanel2;
    }

    private final void updateWarningLabel() {
        String string;
        Integer value2 = this.getBufferSizeKb();
        if (value2 == null || !LogcatApplicationSettingsConfigurableKt.access$isValidBufferSize(value2)) {
            Object[] objectArray = new Object[]{"102400", "100"};
            string = LogcatBundle.message("logcat.settings.buffer.warning.invalid", objectArray);
        } else {
            string = value2 > FileSizeLimit.Companion.getDefaultContentLoadLimit() / 1024 ? LogcatBundle.message("logcat.settings.buffer.warning.tooLarge", new Object[0]) : "";
        }
        this.cyclicBufferSizeWarningLabel.setText(string);
    }

    @NotNull
    public String getDisplayName() {
        return LogcatBundle.message("logcat.settings.title", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        Integer bufferSizeKb = this.getBufferSizeKb();
        if (bufferSizeKb != null && LogcatApplicationSettingsConfigurableKt.access$isValidBufferSize(bufferSizeKb)) {
            int n = this.logcatSettings.getBufferSize() / 1024;
            if (bufferSizeKb != n) return true;
        }
        if (!Intrinsics.areEqual((Object)this.defaultFilterTextField.getText(), (Object)this.logcatSettings.getDefaultFilter())) return true;
        if (this.mostRecentlyUsedFilterIsDefaultCheckbox.isSelected() != this.logcatSettings.getMostRecentlyUsedFilterIsDefault()) return true;
        if (this.filterHistoryAutocompleteCheckbox.isSelected() != this.logcatSettings.getFilterHistoryAutocomplete()) return true;
        if (this.overrideFontSize.isSelected() != this.logcatSettings.getOverrideFontSize()) return true;
        if (!Intrinsics.areEqual((Object)this.fontSize.getText(), (Object)String.valueOf(this.logcatSettings.getFontSize()))) return true;
        if (!Intrinsics.areEqual(this.getIgnoreTagsTextField$intellij_android_logcat().getIgnoredValues(), this.logcatSettings.getIgnoredTags())) return true;
        if (Intrinsics.areEqual(this.getIgnoreAppsTextField$intellij_android_logcat().getIgnoredValues(), this.logcatSettings.getIgnoredApps())) return false;
        return true;
    }

    public void reset() {
        this.cycleBufferSizeTextField.setText(String.valueOf(this.logcatSettings.getBufferSize() / 1024));
        this.defaultFilterTextField.setText(this.logcatSettings.getDefaultFilter());
        this.mostRecentlyUsedFilterIsDefaultCheckbox.setSelected(this.logcatSettings.getMostRecentlyUsedFilterIsDefault());
        this.filterHistoryAutocompleteCheckbox.setSelected(this.logcatSettings.getFilterHistoryAutocomplete());
        this.overrideFontSize.setSelected(this.logcatSettings.getOverrideFontSize());
        this.fontSize.setText(String.valueOf(this.logcatSettings.getFontSize()));
        this.getIgnoreTagsTextField$intellij_android_logcat().setIgnoredValues((Collection<String>)this.logcatSettings.getIgnoredTags());
        this.getIgnoreAppsTextField$intellij_android_logcat().setIgnoredValues((Collection<String>)this.logcatSettings.getIgnoredApps());
    }

    public void apply() {
        Integer n = this.getBufferSizeKb();
        if (n == null) {
            return;
        }
        this.logcatSettings.setBufferSize(n * 1024);
        String string = this.defaultFilterTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.logcatSettings.setDefaultFilter(string);
        this.logcatSettings.setMostRecentlyUsedFilterIsDefault(this.mostRecentlyUsedFilterIsDefaultCheckbox.isSelected());
        this.logcatSettings.setFilterHistoryAutocomplete(this.filterHistoryAutocompleteCheckbox.isSelected());
        this.logcatSettings.setOverrideFontSize(this.overrideFontSize.isSelected());
        String string2 = this.fontSize.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        Integer n2 = StringsKt.toIntOrNull((String)string2);
        this.logcatSettings.setFontSize(n2 != null ? n2 : 13);
        this.logcatSettings.setIgnoredTags(this.getIgnoreTagsTextField$intellij_android_logcat().getIgnoredValues());
        this.logcatSettings.setIgnoredApps(this.getIgnoreAppsTextField$intellij_android_logcat().getIgnoredValues());
        Iterable $this$forEach$iv = LogcatToolWindowFactory.Companion.getLogcatPresenters$intellij_android_logcat();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogcatPresenter it = (LogcatPresenter)element$iv;
            boolean bl = false;
            it.applyLogcatSettings(this.logcatSettings);
        }
    }

    private final Integer getBufferSizeKb() {
        Integer n;
        try {
            String string = this.cycleBufferSizeTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        return n;
    }

    private static final void mostRecentlyUsedFilterIsDefaultCheckbox$lambda$0$0(LogcatApplicationSettingsConfigurable this$0, JCheckBox $this_apply, ActionEvent it) {
        this$0.defaultFilterTextField.setEnabled(!$this_apply.isSelected());
    }

    private static final void overrideFontSize$lambda$0$0(LogcatApplicationSettingsConfigurable this$0, JCheckBox $this_apply, ActionEvent it) {
        this$0.fontSize.setEnabled($this_apply.isSelected());
    }

    private static final IgnoreValuesTextField ignoreTagsTextField_delegate$lambda$0(LogcatApplicationSettingsConfigurable this$0) {
        return new IgnoreValuesTextField(this$0.logcatSettings.getIgnoredTags(), (Function1<? super LogcatPresenter, ? extends Set<String>>)((Function1)ignoreTagsTextField.2.1.INSTANCE));
    }

    private static final IgnoreValuesTextField ignoreAppsTextField_delegate$lambda$0(LogcatApplicationSettingsConfigurable this$0) {
        return new IgnoreValuesTextField(this$0.logcatSettings.getIgnoredApps(), (Function1<? super LogcatPresenter, ? extends Set<String>>)((Function1)ignoreAppsTextField.2.1.INSTANCE));
    }

    public static final /* synthetic */ void access$updateWarningLabel(LogcatApplicationSettingsConfigurable $this) {
        $this.updateWarningLabel();
    }
}

