/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.service;

import com.android.logcat.proto.LogcatPriorityProto;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00010\u0001*\u00020\rH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\rH\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\rH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0012*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u0001*\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"TEXT_PREFIX", "", "getSize", "", "Ljava/nio/ByteBuffer;", "getBytes", "", "size", "toLogLevel", "Lcom/android/tools/idea/logcat/message/LogLevel;", "Lcom/android/logcat/proto/LogcatPriorityProto;", "toTag", "kotlin.jvm.PlatformType", "Lcom/google/protobuf/ByteString;", "NEWLINE", "", "toMessage", "endsWithNewline", "", "startsWith", "text", "readLine", "charset", "Ljava/nio/charset/Charset;", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatProtoShellCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatProtoShellCollector.kt\ncom/android/tools/idea/logcat/service/LogcatProtoShellCollectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1#2:300\n*E\n"})
public final class LogcatProtoShellCollectorKt {
    @NotNull
    private static final String TEXT_PREFIX = "--------- beginning of ";
    private static final byte NEWLINE = 10;

    private static final int getSize(ByteBuffer $this$getSize) {
        return Math.toIntExact($this$getSize.getLong());
    }

    private static final byte[] getBytes(ByteBuffer $this$getBytes, int size) {
        byte[] byArray;
        byte[] $this$getBytes_u24lambda_u240 = byArray = new byte[size];
        boolean bl = false;
        $this$getBytes.get($this$getBytes_u24lambda_u240);
        return byArray;
    }

    private static final LogLevel toLogLevel(LogcatPriorityProto $this$toLogLevel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toLogLevel.ordinal()]) {
            case 1 -> LogLevel.VERBOSE;
            case 2 -> LogLevel.DEBUG;
            case 3 -> LogLevel.INFO;
            case 4 -> LogLevel.WARN;
            case 5 -> LogLevel.ERROR;
            case 6 -> LogLevel.ASSERT;
            default -> {
                LogcatLoggerKt.getLOGGER().debug("Unexpected priority: " + $this$toLogLevel + ". Using 'ERROR' instead");
                yield LogLevel.ERROR;
            }
        };
    }

    private static final String toTag(ByteString $this$toTag) {
        return $this$toTag.substring(0, $this$toTag.size() - 1).toString(Charset.defaultCharset());
    }

    private static final String toMessage(ByteString $this$toMessage) {
        int n;
        int size = $this$toMessage.size();
        boolean bl = LogcatProtoShellCollectorKt.endsWithNewline($this$toMessage);
        if (bl) {
            n = size - 1;
        } else if (!bl) {
            n = size;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int end = n;
        String string = $this$toMessage.substring(0, end).toString(Charset.defaultCharset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean endsWithNewline(ByteString $this$endsWithNewline) {
        return $this$endsWithNewline.size() > 0 && $this$endsWithNewline.byteAt($this$endsWithNewline.size() - 1) == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean startsWith(ByteBuffer $this$startsWith, String text2) {
        $this$startsWith.mark();
        try {
            String string = text2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] prefixBytes = byArray;
            if ($this$startsWith.remaining() < prefixBytes.length) {
                boolean bl = false;
                return bl;
            }
            byte[] bytes2 = new byte[prefixBytes.length];
            $this$startsWith.get(bytes2);
            boolean bl = Arrays.equals(bytes2, prefixBytes);
            return bl;
        }
        finally {
            $this$startsWith.reset();
        }
    }

    private static final String readLine(ByteBuffer $this$readLine, Charset charset) {
        if (!$this$readLine.hasRemaining()) {
            throw new IllegalArgumentException("Buffer starts with --------- beginning of  but has no remaining bytes");
        }
        int startPosition = $this$readLine.position();
        int endOfLine = -1;
        int n = $this$readLine.limit();
        for (int i = startPosition; i < n; ++i) {
            if ($this$readLine.get(i) != 10) continue;
            endOfLine = i;
            break;
        }
        byte[] lineBytes = null;
        if (endOfLine == -1) {
            throw new IllegalArgumentException("Buffer starts with --------- beginning of  but has no newline");
        }
        int length = endOfLine - startPosition;
        lineBytes = new byte[length];
        $this$readLine.get(lineBytes);
        $this$readLine.get();
        return !(lineBytes.length == 0) && ArraysKt.last((byte[])lineBytes) == 13 ? new String(lineBytes, 0, lineBytes.length - 1, charset) : new String(lineBytes, charset);
    }

    static /* synthetic */ String readLine$default(ByteBuffer byteBuffer, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return LogcatProtoShellCollectorKt.readLine(byteBuffer, charset);
    }

    public static final /* synthetic */ byte[] access$getBytes(ByteBuffer $receiver, int size) {
        return LogcatProtoShellCollectorKt.getBytes($receiver, size);
    }

    public static final /* synthetic */ boolean access$startsWith(ByteBuffer $receiver, String text2) {
        return LogcatProtoShellCollectorKt.startsWith($receiver, text2);
    }

    public static final /* synthetic */ int access$getSize(ByteBuffer $receiver) {
        return LogcatProtoShellCollectorKt.getSize($receiver);
    }

    public static final /* synthetic */ LogLevel access$toLogLevel(LogcatPriorityProto $receiver) {
        return LogcatProtoShellCollectorKt.toLogLevel($receiver);
    }

    public static final /* synthetic */ String access$toTag(ByteString $receiver) {
        return LogcatProtoShellCollectorKt.toTag($receiver);
    }

    public static final /* synthetic */ String access$toMessage(ByteString $receiver) {
        return LogcatProtoShellCollectorKt.toMessage($receiver);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogcatPriorityProto.values().length];
            try {
                nArray[LogcatPriorityProto.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatPriorityProto.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatPriorityProto.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatPriorityProto.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatPriorityProto.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogcatPriorityProto.FATAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

