/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.messages.TimestampFormatKt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0080\b\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/logcat/messages/TimestampFormat;", "", "style", "Lcom/android/tools/idea/logcat/messages/TimestampFormat$Style;", "enabled", "", "<init>", "(Lcom/android/tools/idea/logcat/messages/TimestampFormat$Style;Z)V", "getStyle", "()Lcom/android/tools/idea/logcat/messages/TimestampFormat$Style;", "getEnabled", "()Z", "format", "", "instant", "Ljava/time/Instant;", "zoneId", "Ljava/time/ZoneId;", "width", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "Style", "intellij.android.logcat"})
public final class TimestampFormat {
    @NotNull
    private final Style style;
    private final boolean enabled;

    public TimestampFormat(@NotNull Style style, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.style = style;
        this.enabled = enabled;
    }

    public /* synthetic */ TimestampFormat(Style style, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            style = Style.DATETIME;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(style, bl);
    }

    @NotNull
    public final Style getStyle() {
        return this.style;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final String format(@NotNull Instant instant, @NotNull ZoneId zoneId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        if (this.enabled) {
            String string2 = this.style.getFormatter().format(LocalDateTime.ofInstant(instant, zoneId));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            string = "";
        }
        return string;
    }

    public final int width() {
        return this.enabled ? this.style.getWidth() : 0;
    }

    @NotNull
    public final Style component1() {
        return this.style;
    }

    public final boolean component2() {
        return this.enabled;
    }

    @NotNull
    public final TimestampFormat copy(@NotNull Style style, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        return new TimestampFormat(style, enabled);
    }

    public static /* synthetic */ TimestampFormat copy$default(TimestampFormat timestampFormat, Style style, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            style = timestampFormat.style;
        }
        if ((n & 2) != 0) {
            bl = timestampFormat.enabled;
        }
        return timestampFormat.copy(style, bl);
    }

    @NotNull
    public String toString() {
        return "TimestampFormat(style=" + this.style + ", enabled=" + this.enabled + ")";
    }

    public int hashCode() {
        int result2 = this.style.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimestampFormat)) {
            return false;
        }
        TimestampFormat timestampFormat = (TimestampFormat)other;
        if (this.style != timestampFormat.style) {
            return false;
        }
        return this.enabled == timestampFormat.enabled;
    }

    public TimestampFormat() {
        this(null, false, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/logcat/messages/TimestampFormat$Style;", "", "formatter", "Ljava/time/format/DateTimeFormatter;", "width", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/time/format/DateTimeFormatter;ILjava/lang/String;)V", "getFormatter", "()Ljava/time/format/DateTimeFormatter;", "getWidth", "()I", "getDisplayName", "()Ljava/lang/String;", "DATETIME", "TIME", "intellij.android.logcat"})
    public static final class Style
    extends Enum<Style> {
        @NotNull
        private final DateTimeFormatter formatter;
        private final int width;
        @NotNull
        private final String displayName;
        public static final /* enum */ Style DATETIME;
        public static final /* enum */ Style TIME;
        private static final /* synthetic */ Style[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Style(DateTimeFormatter formatter, int width, String displayName) {
            this.formatter = formatter;
            this.width = width;
            this.displayName = displayName;
        }

        @NotNull
        public final DateTimeFormatter getFormatter() {
            return this.formatter;
        }

        public final int getWidth() {
            return this.width;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static Style[] values() {
            return (Style[])$VALUES.clone();
        }

        public static Style valueOf(String value2) {
            return Enum.valueOf(Style.class, value2);
        }

        @NotNull
        public static EnumEntries<Style> getEntries() {
            return $ENTRIES;
        }

        static {
            DateTimeFormatter dateTimeFormatter = TimestampFormatKt.access$getDATE_TIME_FORMATTER$p();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"access$getDATE_TIME_FORMATTER$p(...)");
            DATETIME = new Style(dateTimeFormatter, 24, LogcatBundle.message("logcat.header.options.timestamp.datetime", new Object[0]));
            DateTimeFormatter dateTimeFormatter2 = TimestampFormatKt.access$getTIME_FORMATTER$p();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"access$getTIME_FORMATTER$p(...)");
            TIME = new Style(dateTimeFormatter2, 13, LogcatBundle.message("logcat.header.options.timestamp.time", new Object[0]));
            $VALUES = styleArray = new Style[]{Style.DATETIME, Style.TIME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

