/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.hyperlinks;

import com.android.sdklib.AndroidApiLevel;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.sources.SdkSourcePositionFinder;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u001b\u001a\u00020\u0018*\u00020\u0018H\u0002J\u0014\u0010\u001c\u001a\u00020\t*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfoBase;", "Lcom/intellij/execution/filters/FileHyperlinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "apiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;Lcom/android/sdklib/AndroidApiLevel;)V", "getFiles", "()Ljava/util/List;", "getApiLevel", "()Lcom/android/sdklib/AndroidApiLevel;", "navigate", "", "hyperlinkLocationPoint", "Lcom/intellij/ui/awt/RelativePoint;", "openFileChooser", "psiFiles", "Lcom/intellij/psi/PsiFile;", "openFile", "psiFile", "getAndroidSdkFile", "withFile", "newFile", "getDescriptor", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nSdkSourceRedirectLinkInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSourceRedirectLinkInfo.kt\ncom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1617#2,9:122\n1869#2:131\n1870#2:133\n1626#2:134\n1563#2:135\n1634#2,3:136\n1208#2,2:139\n1236#2,4:141\n1#3:132\n*S KotlinDebug\n*F\n+ 1 SdkSourceRedirectLinkInfo.kt\ncom/android/tools/idea/logcat/hyperlinks/SdkSourceRedirectLinkInfo\n*L\n49#1:122,9\n49#1:131\n49#1:133\n49#1:134\n66#1:135\n66#1:136,3\n67#1:139,2\n67#1:141,4\n49#1:132\n*E\n"})
public final class SdkSourceRedirectLinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    @NotNull
    private final Project project;
    @VisibleForTesting
    @NotNull
    private final List<VirtualFile> files;
    @NotNull
    private final OpenFileDescriptor descriptor;
    @VisibleForTesting
    @NotNull
    private final AndroidApiLevel apiLevel;

    public SdkSourceRedirectLinkInfo(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull OpenFileDescriptor descriptor2, @NotNull AndroidApiLevel apiLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)apiLevel, (String)"apiLevel");
        this.project = project;
        this.files = files2;
        this.descriptor = descriptor2;
        this.apiLevel = apiLevel;
    }

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    @NotNull
    public final AndroidApiLevel getApiLevel() {
        return this.apiLevel;
    }

    /*
     * WARNING - void declaration
     */
    public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = this.files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        switch (psiFiles.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.openFile((PsiFile)CollectionsKt.first((List)psiFiles), this.descriptor);
                break;
            }
            default: {
                this.openFileChooser(psiFiles, this.descriptor, hyperlinkLocationPoint);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void openFileChooser(List<? extends PsiFile> psiFiles, OpenFileDescriptor descriptor2, RelativePoint hyperlinkLocationPoint) {
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = psiFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getVirtualFile());
        }
        List files2 = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = psiFiles;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(it.getVirtualFile(), element$iv$iv);
        }
        Map map2 = destination$iv$iv2;
        JFrame frame = WindowManager.getInstance().getFrame(this.project);
        Serializable serializable = frame;
        int width = serializable != null && (serializable = serializable.getSize()) != null ? ((Dimension)serializable).width : 200;
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(files2).setRenderer((ListCellRenderer)new GotoFileCellRenderer(width)).setTitle(ExecutionBundle.message((String)"popup.title.choose.target.file", (Object[])new Object[0])).setItemChosenCallback(arg_0 -> SdkSourceRedirectLinkInfo.openFileChooser$lambda$3(arg_0 -> SdkSourceRedirectLinkInfo.openFileChooser$lambda$2(this, map2, descriptor2, arg_0), arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        if (hyperlinkLocationPoint != null) {
            popup.show(hyperlinkLocationPoint);
        } else {
            popup.showInFocusCenter();
        }
    }

    private final void openFile(PsiFile psiFile, OpenFileDescriptor descriptor2) {
        OpenFileDescriptor openFileDescriptor;
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdks, (String)"getInstance(...)");
        AndroidSdks androidSdks2 = androidSdks;
        if (androidSdks2.isInAndroidSdk((PsiElement)psiFile)) {
            VirtualFile virtualFile = this.getAndroidSdkFile(psiFile).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            openFileDescriptor = this.withFile(descriptor2, virtualFile);
        } else {
            openFileDescriptor = descriptor2;
        }
        OpenFileDescriptor newDescriptor = openFileDescriptor;
        newDescriptor.navigate(true);
    }

    private final PsiFile getAndroidSdkFile(PsiFile $this$getAndroidSdkFile) {
        Project project = $this$getAndroidSdkFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile = SdkSourcePositionFinder.Companion.getInstance(project).getSourcePosition(this.apiLevel, $this$getAndroidSdkFile, -1).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return psiFile;
    }

    private final OpenFileDescriptor withFile(OpenFileDescriptor $this$withFile, VirtualFile newFile) {
        return $this$withFile.getLine() >= 0 ? new OpenFileDescriptor($this$withFile.getProject(), newFile, $this$withFile.getLine(), $this$withFile.getColumn()) : new OpenFileDescriptor($this$withFile.getProject(), newFile, $this$withFile.getOffset());
    }

    @NotNull
    public OpenFileDescriptor getDescriptor() {
        return this.descriptor;
    }

    private static final Unit openFileChooser$lambda$2(SdkSourceRedirectLinkInfo this$0, Map $map, OpenFileDescriptor $descriptor, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this$0.openFile((PsiFile)MapsKt.getValue((Map)$map, (Object)file), this$0.withFile($descriptor, file));
        return Unit.INSTANCE;
    }

    private static final void openFileChooser$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

