/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatMessageWrapper;
import com.android.tools.idea.logcat.message.LogLevel;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/logcat/filters/ExactLevelFilter;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "level", "Lcom/android/tools/idea/logcat/message/LogLevel;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/android/tools/idea/logcat/message/LogLevel;Lcom/intellij/openapi/util/TextRange;)V", "getLevel", "()Lcom/android/tools/idea/logcat/message/LogLevel;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "displayText", "", "getDisplayText", "()Ljava/lang/String;", "matches", "", "message", "Lcom/android/tools/idea/logcat/filters/LogcatMessageWrapper;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.android.logcat"})
public final class ExactLevelFilter
extends LogcatFilter {
    @NotNull
    private final LogLevel level;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final String displayText;

    public ExactLevelFilter(@NotNull LogLevel level, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        super(textRange);
        this.level = level;
        this.textRange = textRange;
        Object[] objectArray = new Object[]{this.level.name()};
        this.displayText = LogcatBundle.message("logcat.filter.completion.hint.is.level", objectArray);
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    @NotNull
    public String getDisplayText() {
        return this.displayText;
    }

    @Override
    public boolean matches(@NotNull LogcatMessageWrapper message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message.getLogcatMessage().getHeader().getLogLevel() == this.level;
    }

    @NotNull
    public final LogLevel component1() {
        return this.level;
    }

    @NotNull
    public final TextRange component2() {
        return this.textRange;
    }

    @NotNull
    public final ExactLevelFilter copy(@NotNull LogLevel level, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        return new ExactLevelFilter(level, textRange);
    }

    public static /* synthetic */ ExactLevelFilter copy$default(ExactLevelFilter exactLevelFilter, LogLevel logLevel, TextRange textRange, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = exactLevelFilter.level;
        }
        if ((n & 2) != 0) {
            textRange = exactLevelFilter.textRange;
        }
        return exactLevelFilter.copy(logLevel, textRange);
    }

    @NotNull
    public String toString() {
        return "ExactLevelFilter(level=" + this.level + ", textRange=" + this.textRange + ")";
    }

    public int hashCode() {
        int result2 = this.level.hashCode();
        result2 = result2 * 31 + this.textRange.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExactLevelFilter)) {
            return false;
        }
        ExactLevelFilter exactLevelFilter = (ExactLevelFilter)other;
        if (this.level != exactLevelFilter.level) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textRange, (Object)exactLevelFilter.textRange);
    }
}

