/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.actions;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.LogcatPresenter;
import com.android.tools.idea.logcat.devices.Device;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.DocumentAppenderKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0011\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u0003\u001a\u0013\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0002*\u00020\u0003H\u0000\u001a\u0013\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0002*\u00020\u0003H\u0000\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0003\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u00020\u0003H\u0000\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0003\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"getEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getLogcatPresenter", "Lcom/android/tools/idea/logcat/LogcatPresenter;", "getConnectedDevice", "Lcom/android/tools/idea/logcat/devices/Device;", "getLogcatMessage", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "getLogcatMessages", "", "start", "", "end", "endsOnLineBreak", "", "Lcom/intellij/openapi/editor/SelectionModel;", "intellij.android.logcat"})
public final class ActionExtensionsKt {
    @Nullable
    public static final EditorEx getEditor(@NotNull AnActionEvent $this$getEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$getEditor, (String)"<this>");
        return (EditorEx)$this$getEditor.getData(LogcatPresenter.Companion.getEDITOR());
    }

    @Nullable
    public static final LogcatPresenter getLogcatPresenter(@NotNull AnActionEvent $this$getLogcatPresenter) {
        Intrinsics.checkNotNullParameter((Object)$this$getLogcatPresenter, (String)"<this>");
        return (LogcatPresenter)$this$getLogcatPresenter.getData(LogcatPresenter.Companion.getLOGCAT_PRESENTER_ACTION());
    }

    @Nullable
    public static final Device getConnectedDevice(@NotNull AnActionEvent $this$getConnectedDevice) {
        Intrinsics.checkNotNullParameter((Object)$this$getConnectedDevice, (String)"<this>");
        return (Device)$this$getConnectedDevice.getData(LogcatPresenter.Companion.getCONNECTED_DEVICE());
    }

    @Nullable
    public static final LogcatMessage getLogcatMessage(@NotNull AnActionEvent $this$getLogcatMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$getLogcatMessage, (String)"<this>");
        EditorEx editorEx = ActionExtensionsKt.getEditor($this$getLogcatMessage);
        if (editorEx == null || (editorEx = editorEx.getCaretModel()) == null) {
            return null;
        }
        int offset = editorEx.getOffset();
        return (LogcatMessage)CollectionsKt.firstOrNull(ActionExtensionsKt.getLogcatMessages($this$getLogcatMessage, offset, offset));
    }

    @NotNull
    public static final List<LogcatMessage> getLogcatMessages(@NotNull AnActionEvent $this$getLogcatMessages) {
        Intrinsics.checkNotNullParameter((Object)$this$getLogcatMessages, (String)"<this>");
        EditorEx editorEx = ActionExtensionsKt.getEditor($this$getLogcatMessages);
        if (editorEx == null) {
            return CollectionsKt.emptyList();
        }
        EditorEx editor = editorEx;
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        int end = ActionExtensionsKt.endsOnLineBreak(selectionModel2) ? selectionModel2.getSelectionEnd() - 1 : selectionModel2.getSelectionEnd();
        return ActionExtensionsKt.getLogcatMessages($this$getLogcatMessages, selectionModel2.getSelectionStart(), end);
    }

    @UiThread
    private static final List<LogcatMessage> getLogcatMessages(AnActionEvent $this$getLogcatMessages, int start2, int end) {
        List list2;
        EditorEx editorEx = ActionExtensionsKt.getEditor($this$getLogcatMessages);
        if (editorEx == null) {
            return CollectionsKt.emptyList();
        }
        EditorEx editor = editorEx;
        List $this$getLogcatMessages_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        editor.getDocument().processRangeMarkersOverlappingWith(start2, end, arg_0 -> ActionExtensionsKt.getLogcatMessages$lambda$0$1(arg_0 -> ActionExtensionsKt.getLogcatMessages$lambda$0$0($this$getLogcatMessages_u24lambda_u240, start2, end, arg_0), arg_0));
        return CollectionsKt.build((List)list2);
    }

    private static final boolean endsOnLineBreak(SelectionModel $this$endsOnLineBreak) {
        if ($this$endsOnLineBreak.getSelectionStart() >= $this$endsOnLineBreak.getSelectionEnd() || $this$endsOnLineBreak.getSelectionEnd() <= 0) {
            return false;
        }
        return $this$endsOnLineBreak.getEditor().getDocument().getImmutableCharSequence().charAt($this$endsOnLineBreak.getSelectionEnd() - 1) == '\n';
    }

    private static final boolean getLogcatMessages$lambda$0$0(List $this_buildList, int $start, int $end, RangeMarker it) {
        LogcatMessage message = (LogcatMessage)it.getUserData(DocumentAppenderKt.getLOGCAT_MESSAGE_KEY());
        if (message != null) {
            $this_buildList.add(message);
        }
        return $start != $end || message == null;
    }

    private static final boolean getLogcatMessages$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

