/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0004H\u0016J\u001f\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddUsesFeatureQuickFix;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "myFeatureName", "", "element", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "Companion", "intellij.android.lint"})
public final class AddUsesFeatureQuickFix
extends PsiBasedModCommandAction<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String myFeatureName;

    public AddUsesFeatureQuickFix(@NotNull String myFeatureName, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)myFeatureName, (String)"myFeatureName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.myFeatureName = myFeatureName;
    }

    @NotNull
    public String getFamilyName() {
        return "AddUsesFeatureQuickFix";
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, XmlTag.class);
        return Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"manifest") ? Presentation.of((String)"Add uses-feature tag") : null;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, XmlTag.class);
        if (xmlTag == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        XmlTag parent = xmlTag;
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)parent), (arg_0, arg_1) -> AddUsesFeatureQuickFix.perform$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    private static final void perform$lambda$0(AddUsesFeatureQuickFix this$0, XmlTag tag, ModPsiUpdater modPsiUpdater) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        XmlTag usesFeatureTag = tag.createChildTag("uses-feature", null, null, false);
        XmlTag ancestor = AddUsesFeatureQuickFix.Companion.findLocationForUsesFeature(tag);
        if (ancestor != null) {
            XmlTag xmlTag = usesFeatureTag;
            Intrinsics.checkNotNull((Object)xmlTag);
            PsiElement psiElement = tag.addAfter((PsiElement)xmlTag, (PsiElement)ancestor);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlTag");
            v2 = (XmlTag)psiElement;
        } else {
            v2 = usesFeatureTag = tag.addSubTag(usesFeatureTag, true);
        }
        if (usesFeatureTag != null) {
            usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this$0.myFeatureName);
            usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", "false");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddUsesFeatureQuickFix$Companion;", "", "<init>", "()V", "findLocationForUsesFeature", "Lcom/intellij/psi/xml/XmlTag;", "parent", "intellij.android.lint"})
    public static final class Companion {
        private Companion() {
        }

        private final XmlTag findLocationForUsesFeature(XmlTag parent) {
            String[] stringArray = new String[]{"uses-feature", "uses-configuration", "uses-sdk", "permission"};
            for (String string : stringArray) {
                XmlTag[] existingTags;
                Intrinsics.checkNotNull((Object)string);
                String elementName = string;
                Intrinsics.checkNotNullExpressionValue((Object)parent.findSubTags(elementName), (String)"findSubTags(...)");
                int len = existingTags.length;
                if (len <= 0) continue;
                return existingTags[len - 1];
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

