/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.idea.lint.inspections.AndroidLintSwitchIntDefInspection;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lint/inspections/AndroidLintSwitchIntDefInspection;", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "<init>", "()V", "getQuickFixes", "", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "message", "", "fixData", "Lcom/android/tools/lint/detector/api/LintFix;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)[Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "intellij.android.lint"})
public final class AndroidLintSwitchIntDefInspection
extends AndroidLintInspectionBase {
    public AndroidLintSwitchIntDefInspection() {
        super(AndroidLintBundle.Companion.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        List missingCases = LintFix.Companion.getStringList(fixData, "cases");
        LintIdeQuickFix[] lintIdeQuickFixArray = (LintIdeQuickFix[])missingCases;
        if (!(lintIdeQuickFixArray == null || lintIdeQuickFixArray.isEmpty())) {
            lintIdeQuickFixArray = new LintIdeQuickFix[]{new ModCommandLintQuickFix((ModCommandAction)new PsiBasedModCommandAction<PsiElement>(startElement, (List<String>)missingCases){
                final /* synthetic */ PsiElement $startElement;
                final /* synthetic */ List<String> $missingCases;
                {
                    this.$startElement = $startElement;
                    this.$missingCases = $missingCases;
                    super($startElement);
                }

                public String getFamilyName() {
                    return "AddMissingIntDefFix";
                }

                protected Presentation getPresentation(ActionContext context, PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Presentation presentation = Presentation.of((String)"Add Missing @IntDef Constants");
                    Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
                    return presentation;
                }

                protected ModCommand perform(ActionContext context, PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Project project = element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Project project2 = project;
                    if (Intrinsics.areEqual((Object)element.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
                        PsiElement psiElement = element.getParent();
                        PsiSwitchStatement psiSwitchStatement = psiElement instanceof PsiSwitchStatement ? (PsiSwitchStatement)psiElement : null;
                        if (psiSwitchStatement == null) {
                            ModCommand modCommand = ModCommand.nop();
                            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                            return modCommand;
                        }
                        PsiSwitchStatement switchStatement = psiSwitchStatement;
                        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)project2);
                        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)switchStatement), (arg_0, arg_1) -> getQuickFixes.1.perform$lambda$0(this.$missingCases, factory2, arg_0, arg_1));
                        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
                        return modCommand;
                    }
                    if (Intrinsics.areEqual((Object)element.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                        KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)this.$startElement, KtWhenExpression.class, (boolean)false);
                        if (ktWhenExpression == null) {
                            ModCommand modCommand = ModCommand.nop();
                            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                            return modCommand;
                        }
                        KtWhenExpression whenExpression = ktWhenExpression;
                        KtPsiFactory factory3 = new KtPsiFactory(project2, false, 2, null);
                        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)whenExpression), (arg_0, arg_1) -> getQuickFixes.1.perform$lambda$1(this.$missingCases, factory3, arg_0, arg_1));
                        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
                        return modCommand;
                    }
                    ModCommand modCommand = ModCommand.nop();
                    Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
                    return modCommand;
                }

                private static final void perform$lambda$0(List $missingCases, PsiElementFactory $factory, PsiSwitchStatement psiSwitchStatement, ModPsiUpdater modPsiUpdater) {
                    Intrinsics.checkNotNullParameter((Object)psiSwitchStatement, (String)"switch");
                    Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
                    PsiCodeBlock psiCodeBlock = psiSwitchStatement.getBody();
                    if (psiCodeBlock == null) {
                        return;
                    }
                    PsiCodeBlock body = psiCodeBlock;
                    PsiElement anchor = body.getLastChild();
                    for (E e : $missingCases) {
                        PsiStatement breakStatement;
                        PsiStatement caseStatement;
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        String string = (String)e;
                        String constant = TextFormat.RAW.convertTo(string, TextFormat.TEXT);
                        PsiElement parent = anchor.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)$factory.createStatementFromText("case " + constant + ":", anchor), (String)"createStatementFromText(...)");
                        parent.addBefore((PsiElement)caseStatement, anchor);
                        Intrinsics.checkNotNullExpressionValue((Object)$factory.createStatementFromText("break;", anchor), (String)"createStatementFromText(...)");
                        parent.addBefore((PsiElement)breakStatement, anchor);
                    }
                }

                private static final void perform$lambda$1(List $missingCases, KtPsiFactory $factory, KtWhenExpression whenExpr, ModPsiUpdater modPsiUpdater) {
                    Intrinsics.checkNotNullParameter((Object)whenExpr, (String)"whenExpr");
                    Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
                    PsiElement anchor = whenExpr.getCloseBrace();
                    for (E e : $missingCases) {
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        String string = (String)e;
                        String constant = TextFormat.RAW.convertTo(string, TextFormat.TEXT);
                        KtWhenEntry caseStatement = $factory.createWhenEntry(constant + "-> { TODO() }");
                        ((PsiElement)whenExpr).addBefore((PsiElement)caseStatement, anchor);
                        ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)whenExpr);
                    }
                }
            })};
            return lintIdeQuickFixArray;
        }
        LintIdeQuickFix[] lintIdeQuickFixArray2 = super.getQuickFixes(startElement, endElement, message, fixData);
        Intrinsics.checkNotNullExpressionValue((Object)lintIdeQuickFixArray2, (String)"getQuickFixes(...)");
        return lintIdeQuickFixArray2;
    }
}

