/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.lint.LintIdeAnalytics;
import com.google.wireless.android.sdk.stats.LintAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvideLintFeedbackPanel
extends DialogWrapper
implements ActionListener,
ChangeListener {
    private static final String REQUEST_FEEDBACK = "request-lint-feedback";
    private static Boolean requestFeedback = null;
    private final Project myProject;
    private final String myIssue;
    private JButton myFalsePositiveButton;
    private JButton myGreatButton;
    private JButton myUnclearMessageButton;
    private JButton myOtherButton;
    private JPanel myPanel;
    private JBCheckBox myFeedbackCheckBox;

    public ProvideLintFeedbackPanel(@Nullable Project project, @NotNull String issue2) {
        super(project);
        this.setupUI();
        this.myProject = project;
        this.myIssue = issue2;
        this.setTitle("Provide Feedback");
        this.init();
        this.myGreatButton.addActionListener(this);
        this.myFalsePositiveButton.addActionListener(this);
        this.myUnclearMessageButton.addActionListener(this);
        this.myOtherButton.addActionListener(this);
        this.myFeedbackCheckBox.addChangeListener((ChangeListener)this);
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getCancelAction()};
    }

    @Nullable
    protected JPanel createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LintAction.LintFeedback feedback;
        Object source2 = e.getSource();
        if (source2 == this.myGreatButton) {
            feedback = LintAction.LintFeedback.LOVE_IT;
        } else if (source2 == this.myFalsePositiveButton) {
            feedback = LintAction.LintFeedback.FALSE_POSITIVE;
        } else if (source2 == this.myUnclearMessageButton) {
            feedback = LintAction.LintFeedback.UNCLEAR_MESSAGE;
        } else if (source2 == this.myOtherButton) {
            feedback = LintAction.LintFeedback.UNKNOWN_FEEDBACK;
        } else {
            assert (false) : source2;
            return;
        }
        LintIdeAnalytics analytics = new LintIdeAnalytics(this.myProject);
        analytics.logFeedback(this.myIssue, feedback);
        this.close(1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean selected;
        if (e.getSource() == this.myFeedbackCheckBox && (selected = this.myFeedbackCheckBox.isSelected()) != ProvideLintFeedbackPanel.canRequestFeedback()) {
            ProvideLintFeedbackPanel.setRequestFeedback(selected);
        }
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Provide feedback on this issue reported by Android Lint:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFalsePositiveButton = new JButton();
        this.myFalsePositiveButton.setText("False Positive");
        this.myPanel.add((Component)this.myFalsePositiveButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Lint incorrectly diagnosed this problem; it's not a real issue.");
        this.myPanel.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.myGreatButton = new JButton();
        this.myGreatButton.setText("Great!");
        this.myPanel.add((Component)this.myGreatButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Lint found a real issue.");
        this.myPanel.add((Component)jBLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.myUnclearMessageButton = new JButton();
        this.myUnclearMessageButton.setText("Unclear Message");
        this.myPanel.add((Component)this.myUnclearMessageButton, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("The error message and/or full explanation is not clear; I'm not sure what to do.");
        this.myPanel.add((Component)jBLabel4, new GridConstraints(3, 1, 1, 1, 0, 0, 1, 0, null, null, null, 0, false));
        this.myOtherButton = new JButton();
        this.myOtherButton.setText("Other");
        this.myPanel.add((Component)this.myOtherButton, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("There is some other problem with this lint result.");
        this.myPanel.add((Component)jBLabel5, new GridConstraints(4, 1, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        this.myFeedbackCheckBox = new JBCheckBox();
        this.myFeedbackCheckBox.setSelected(true);
        this.myFeedbackCheckBox.setText("Continue to ask for feedback on lint checks");
        this.myPanel.add((Component)this.myFeedbackCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 4, new Dimension(-1, 12), new Dimension(-1, 12), null, 0, false));
    }

    public static boolean canRequestFeedback() {
        if (!AnalyticsSettings.getOptedIn()) {
            return false;
        }
        if (requestFeedback == null) {
            requestFeedback = PropertiesComponent.getInstance().getBoolean(REQUEST_FEEDBACK, true);
        }
        return requestFeedback;
    }

    private static void setRequestFeedback(boolean request) {
        requestFeedback = request;
        PropertiesComponent.getInstance().setValue(REQUEST_FEEDBACK, request);
    }
}

